/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.tinkerers_smithing.data;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import folk.sisby.tinkerers_smithing.TinkerersSmithing;
import folk.sisby.tinkerers_smithing.TinkerersSmithingLoader;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1856;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_7923;

public class SmithingUnitCostManager
extends class_4309 {
    public static final SmithingUnitCostManager INSTANCE = new SmithingUnitCostManager(new Gson());
    public static final class_2960 ID = class_2960.method_60655((String)"tinkerers_smithing", (String)"smithing_unit_cost_loader");
    public static final String KEY_REPLACE = "replace";
    public static final String KEY_VALUES = "values";
    public static final String KEY_VALUE_COST = "cost";

    public SmithingUnitCostManager(Gson gson) {
        super(gson, "smithing_unit_costs");
    }

    protected void apply(Map<class_2960, JsonElement> prepared, class_3300 manager, class_3695 profiler) {
        TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Loading Unit Costs!");
        TinkerersSmithingLoader.INSTANCE.COST_OVERRIDES.clear();
        prepared.forEach((id, json) -> class_7923.field_41178.method_17966(id).ifPresentOrElse(item -> {
            boolean replace = json.getAsJsonObject().get(KEY_REPLACE).getAsBoolean();
            HashMap<class_1856, Integer> costs = new HashMap<class_1856, Integer>();
            json.getAsJsonObject().get(KEY_VALUES).getAsJsonArray().forEach(jsonValue -> {
                class_1856 ingredient = (class_1856)((Pair)class_1856.field_46095.decode((DynamicOps)JsonOps.INSTANCE, (Object)jsonValue.getAsJsonObject()).getOrThrow()).getFirst();
                int cost = jsonValue.getAsJsonObject().get(KEY_VALUE_COST).getAsInt();
                if (!ingredient.method_8103()) {
                    costs.put(ingredient, cost);
                }
            });
            TinkerersSmithingLoader.INSTANCE.COST_OVERRIDES.put((class_1792)item, new UnitCostOverride(replace, costs));
        }, () -> TinkerersSmithing.LOGGER.warn("[Tinkerer's Smithing] Failed to override cost for invalid item {}", id)));
        TinkerersSmithing.LOGGER.info("[Tinkerer's Smithing] Reloaded unit cost overrides");
    }

    public String method_22322() {
        return ID.toString();
    }

    public record UnitCostOverride(boolean replace, Map<class_1856, Integer> costs) {
    }
}

