/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.tinkerers_smithing.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import folk.sisby.tinkerers_smithing.TinkerersSmithing;
import folk.sisby.tinkerers_smithing.TinkerersSmithingLoader;
import folk.sisby.tinkerers_smithing.recipe.ServerRecipe;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1867;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7710;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9694;
import org.apache.commons.lang3.ArrayUtils;
import org.jetbrains.annotations.Nullable;

public class ShapelessRepairRecipe
extends class_1867
implements ServerRecipe<class_1867> {
    public final class_1792 baseItem;
    public final class_1856 addition;
    public final int additionCount;

    public ShapelessRepairRecipe(class_1792 baseItem, class_1856 addition, int additionCount) {
        super("", class_7710.field_40250, ShapelessRepairRecipe.getPreviewResult(baseItem), ShapelessRepairRecipe.assembleIngredients(baseItem, addition, additionCount));
        this.baseItem = baseItem;
        this.addition = addition;
        this.additionCount = additionCount;
    }

    public class_8786<ShapelessRepairRecipe> toEntry() {
        return new class_8786(TinkerersSmithingLoader.repairRecipeId(this.baseItem, this.addition), (class_1860)this);
    }

    private static class_1799 getPreviewResult(class_1792 baseItem) {
        class_1799 stack = baseItem.method_7854().method_7972();
        stack.method_7974(1);
        return stack;
    }

    private static class_2371<class_1856> assembleIngredients(class_1792 item, class_1856 addition, int additionCount) {
        class_2371 ingredients = class_2371.method_10211();
        class_1856 additionWithAir = class_1856.method_8092(Arrays.stream((class_1856.class_1859[])ArrayUtils.addAll((Object[])addition.field_9019, (Object[])class_1856.method_8091((class_1935[])new class_1935[]{class_1802.field_8162}).field_9019)));
        ingredients.add((Object)class_1856.method_8091((class_1935[])new class_1935[]{item}));
        for (int i = 0; i < additionCount; ++i) {
            ingredients.add((Object)(i > 0 ? additionWithAir : addition));
        }
        return ingredients;
    }

    private class_1799 findBase(class_9694 recipeInput) {
        List<class_1799> bases = recipeInput.method_59989().stream().filter(s -> s.method_31574(this.baseItem)).toList();
        return bases.size() == 1 && !bases.get(0).method_7942() && bases.get(0).method_7986() ? bases.get(0) : null;
    }

    public boolean method_17730(class_9694 recipeInput, class_1937 world) {
        class_1799 base = this.findBase(recipeInput);
        long units = recipeInput.method_59989().stream().filter(this.addition).count();
        long empty = recipeInput.method_59989().stream().filter(class_1799::method_7960).count();
        if (base == null || units <= 0L || units > (long)this.additionCount || empty != (long)recipeInput.method_59983() - units - 1L) {
            return false;
        }
        return base.method_7919() - (int)Math.ceil((double)((long)base.method_7936() * (units - 1L)) / (double)this.additionCount) > 0;
    }

    public class_1799 method_17729(class_9694 recipeInput, class_7225.class_7874 wrapperLookup) {
        class_1799 base = this.findBase(recipeInput);
        long units = recipeInput.method_59989().stream().filter(this.addition).count();
        if (base == null || units <= 0L || units > (long)this.additionCount) {
            return class_1799.field_8037;
        }
        class_1799 output = super.method_17729(recipeInput, wrapperLookup);
        output.method_59692(base.method_57380());
        output.method_7974(Math.max(0, base.method_7919() - (int)Math.ceil((double)((long)base.method_7936() * units) / (double)this.additionCount)));
        return output;
    }

    public boolean method_8113(int width, int height) {
        return width * height >= 2;
    }

    public boolean method_8118() {
        return true;
    }

    public class_1865<?> method_8119() {
        return TinkerersSmithing.SHAPELESS_REPAIR_SERIALIZER;
    }

    @Override
    @Nullable
    public class_1865<class_1867> getFallbackSerializer() {
        return class_1865.field_9031;
    }

    public static class Serializer
    implements class_1865<ShapelessRepairRecipe> {
        MapCodec<ShapelessRepairRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41178.method_39673().fieldOf("baseItem").forGetter(r -> r.baseItem), (App)class_1856.field_46096.fieldOf("addition").forGetter(r -> r.addition), (App)Codec.INT.fieldOf("additionCount").forGetter(r -> r.additionCount)).apply((Applicative)instance, ShapelessRepairRecipe::new));
        class_9139<class_9129, ShapelessRepairRecipe> PACKET_CODEC = class_9139.method_56436((class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), r -> r.baseItem, (class_9139)class_1856.field_48355, r -> r.addition, (class_9139)class_9135.field_48550, r -> r.additionCount, ShapelessRepairRecipe::new);

        public MapCodec<ShapelessRepairRecipe> method_53736() {
            return this.CODEC;
        }

        public class_9139<class_9129, ShapelessRepairRecipe> method_56104() {
            return this.PACKET_CODEC;
        }
    }
}

