/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.tinkerers_smithing.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import folk.sisby.tinkerers_smithing.TinkerersSmithing;
import folk.sisby.tinkerers_smithing.TinkerersSmithingLoader;
import folk.sisby.tinkerers_smithing.recipe.ServerRecipe;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1865;
import net.minecraft.class_1935;
import net.minecraft.class_5321;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8060;
import net.minecraft.class_8786;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9697;
import org.jetbrains.annotations.Nullable;

public class SmithingUpgradeRecipe
extends class_8060
implements ServerRecipe<class_8060> {
    public final class_1792 baseItem;
    public final int additionCount;
    public final class_1792 resultItem;

    public SmithingUpgradeRecipe(class_1792 baseItem, class_1856 addition, int additionCount, class_1792 resultItem) {
        super(class_1856.method_35226(), class_1856.method_8091((class_1935[])new class_1935[]{baseItem}), addition, SmithingUpgradeRecipe.getPreviewResult(resultItem, additionCount));
        this.baseItem = baseItem;
        this.additionCount = additionCount;
        this.resultItem = resultItem;
    }

    public class_8786<SmithingUpgradeRecipe> toEntry() {
        return new class_8786(TinkerersSmithingLoader.recipeId("smithing", this.resultItem, this.baseItem), (class_1860)this);
    }

    private static class_1799 getPreviewResult(class_1792 resultItem, int additionCount) {
        class_1799 stack = resultItem.method_7854().method_7972();
        stack.method_7974(SmithingUpgradeRecipe.resultDamage(resultItem, additionCount, 1));
        return stack;
    }

    public static int resultDamage(class_1792 resultItem, int additionCount, int usedCount) {
        if (resultItem.method_7854().method_7936() == 0) {
            return additionCount == usedCount ? 0 : 1;
        }
        return Math.min(resultItem.method_7854().method_7936() - 1, (int)Math.floor((double)resultItem.method_7854().method_7936() * ((double)(additionCount - usedCount) / 4.0)));
    }

    public class_1799 method_60000(class_9697 recipeInput, class_7225.class_7874 wrapperLookup) {
        class_1799 output = super.method_60000(recipeInput, wrapperLookup);
        int usedCount = Math.min(this.additionCount, recipeInput.comp_2679().method_7947());
        int damage = SmithingUpgradeRecipe.resultDamage(output.method_7909(), this.additionCount, usedCount);
        if (damage > output.method_7936()) {
            return class_1799.field_8037;
        }
        output.method_7974(damage);
        return output;
    }

    public class_1865<?> method_8119() {
        return TinkerersSmithing.SMITHING_UPGRADE_SERIALIZER;
    }

    @Override
    @Nullable
    public class_1865<class_8060> getFallbackSerializer() {
        return class_1865.field_42027;
    }

    public static class Serializer
    implements class_1865<SmithingUpgradeRecipe> {
        MapCodec<SmithingUpgradeRecipe> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_7923.field_41178.method_39673().fieldOf("baseItem").forGetter(r -> r.baseItem), (App)class_1856.field_46096.fieldOf("addition").forGetter(r -> r.field_42032), (App)Codec.INT.fieldOf("additionCount").forGetter(r -> r.additionCount), (App)class_7923.field_41178.method_39673().fieldOf("resultItem").forGetter(r -> r.resultItem)).apply((Applicative)instance, SmithingUpgradeRecipe::new));
        class_9139<class_9129, SmithingUpgradeRecipe> PACKET_CODEC = class_9139.method_56905((class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), r -> r.baseItem, (class_9139)class_1856.field_48355, r -> r.field_42032, (class_9139)class_9135.field_48550, r -> r.additionCount, (class_9139)class_9135.method_56365((class_5321)class_7924.field_41197), r -> r.resultItem, SmithingUpgradeRecipe::new);

        public MapCodec<SmithingUpgradeRecipe> method_53736() {
            return this.CODEC;
        }

        public class_9139<class_9129, SmithingUpgradeRecipe> method_56104() {
            return this.PACKET_CODEC;
        }
    }
}

