/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.fabric;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.fabricmc.api.ClientModInitializer;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.command.v2.ClientCommandRegistrationCallback;
import net.fabricmc.fabric.api.client.command.v2.FabricClientCommandSource;
import net.fabricmc.fabric.api.client.event.lifecycle.v1.ClientTickEvents;
import net.fabricmc.fabric.api.client.keybinding.v1.KeyBindingHelper;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayConnectionEvents;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3695;
import net.minecraft.class_7923;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.commands.ClientCommandBuilder;
import nx.pingwheel.common.config.ClientConfig;
import nx.pingwheel.common.config.ConfigHandler;
import nx.pingwheel.common.core.ClientCore;
import nx.pingwheel.common.helper.LanguageUtils;
import nx.pingwheel.common.networking.PingLocationS2CPacket;
import nx.pingwheel.common.networking.UpdateChannelC2SPacket;
import nx.pingwheel.common.resource.ResourceReloadListener;
import nx.pingwheel.fabric.event.GuiRenderCallback;
import nx.pingwheel.fabric.event.WorldRenderCallback;

@Environment(value=EnvType.CLIENT)
public class Client
implements ClientModInitializer {
    public static final class_2960 RELOAD_LISTENER_ID = class_2960.method_60655((String)"ping-wheel", (String)"reload-listener");

    public void onInitializeClient() {
        ClientGlobal.ConfigHandler = new ConfigHandler<ClientConfig>(ClientConfig.class, FabricLoader.getInstance().getConfigDir().resolve("ping-wheel.json"));
        ClientGlobal.ConfigHandler.load();
        class_2378.method_10230((class_2378)class_7923.field_41172, (class_2960)ClientGlobal.PING_SOUND_ID, (Object)ClientGlobal.PING_SOUND_EVENT);
        this.registerNetworkPackets();
        this.registerReloadListener();
        this.registerKeyBindings();
        ClientPlayConnectionEvents.JOIN.register((a, b, c) -> Global.NetHandler.sendToServer(new UpdateChannelC2SPacket(ClientGlobal.ConfigHandler.getConfig().getChannel())));
        ClientPlayConnectionEvents.DISCONNECT.register((a, b) -> ClientCore.onDisconnect());
        GuiRenderCallback.START.register(ClientCore::onRenderGUI);
        WorldRenderCallback.START.register(ClientCore::onRenderWorld);
        ClientCommandRegistrationCallback.EVENT.register((dispatcher, registryAccess) -> dispatcher.register(ClientCommandBuilder.build((context, success, response) -> {
            if (success.booleanValue()) {
                ((FabricClientCommandSource)context.getSource()).sendFeedback((class_2561)LanguageUtils.withModPrefix(response));
            } else {
                ((FabricClientCommandSource)context.getSource()).sendError((class_2561)LanguageUtils.withModPrefix(response));
            }
        })));
    }

    private void registerNetworkPackets() {
        ClientPlayNetworking.registerGlobalReceiver(PingLocationS2CPacket.PACKET_TYPE, (packet, context) -> ClientCore.onPingLocation(packet));
    }

    private void registerReloadListener() {
        ResourceManagerHelper.get((class_3264)class_3264.field_14188).registerReloadListener(new IdentifiableResourceReloadListener(this){

            public class_2960 getFabricId() {
                return RELOAD_LISTENER_ID;
            }

            public CompletableFuture<Void> method_25931(class_3302.class_4045 helper, class_3300 resourceManager, class_3695 loadProfiler, class_3695 applyProfiler, Executor loadExecutor, Executor applyExecutor) {
                return ResourceReloadListener.reloadTextures(helper, resourceManager, loadExecutor, applyExecutor);
            }
        });
    }

    private void registerKeyBindings() {
        KeyBindingHelper.registerKeyBinding((class_304)ClientGlobal.KEY_BINDING_PING);
        KeyBindingHelper.registerKeyBinding((class_304)ClientGlobal.KEY_BINDING_SETTINGS);
        KeyBindingHelper.registerKeyBinding((class_304)ClientGlobal.KEY_BINDING_NAME_LABELS);
        ClientTickEvents.START_CLIENT_TICK.register(client -> ClientCore.onTick());
    }
}

