/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.fabric;

import com.mojang.brigadier.context.CommandContext;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2168;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_5250;
import net.minecraft.class_9139;
import nx.pingwheel.common.Global;
import nx.pingwheel.common.commands.ServerCommandBuilder;
import nx.pingwheel.common.config.ConfigHandler;
import nx.pingwheel.common.config.ServerConfig;
import nx.pingwheel.common.core.ServerCore;
import nx.pingwheel.common.helper.LanguageUtils;
import nx.pingwheel.common.networking.PingLocationC2SPacket;
import nx.pingwheel.common.networking.PingLocationS2CPacket;
import nx.pingwheel.common.networking.UpdateChannelC2SPacket;
import nx.pingwheel.fabric.networking.NetworkHandler;
import org.apache.logging.log4j.util.TriConsumer;

public class Main
implements ModInitializer {
    private static final class_9139<class_2540, PingLocationS2CPacket> PING_LOCATION_S2C_CODEC = class_9139.method_56438(PingLocationS2CPacket::write, PingLocationS2CPacket::readSafe);
    private static final class_9139<class_2540, PingLocationC2SPacket> PING_LOCATION_C2S_CODEC = class_9139.method_56438(PingLocationC2SPacket::write, PingLocationC2SPacket::readSafe);
    private static final class_9139<class_2540, UpdateChannelC2SPacket> UPDATE_CHANNEL_C2S_CODEC = class_9139.method_56438(UpdateChannelC2SPacket::write, UpdateChannelC2SPacket::readSafe);

    public void onInitialize() {
        Global.LOGGER.info("Init");
        Global.NetHandler = new NetworkHandler();
        Global.ServerConfigHandler = new ConfigHandler<ServerConfig>(ServerConfig.class, FabricLoader.getInstance().getConfigDir().resolve("ping-wheel.server.json"));
        Global.ServerConfigHandler.load();
        Global.ModVersion = FabricLoader.getInstance().getModContainer("ping-wheel").map(container -> container.getMetadata().getVersion().getFriendlyString()).orElse("Unknown");
        PayloadTypeRegistry.playS2C().register(PingLocationS2CPacket.PACKET_TYPE, PING_LOCATION_S2C_CODEC);
        PayloadTypeRegistry.playC2S().register(PingLocationC2SPacket.PACKET_TYPE, PING_LOCATION_C2S_CODEC);
        PayloadTypeRegistry.playC2S().register(UpdateChannelC2SPacket.PACKET_TYPE, UPDATE_CHANNEL_C2S_CODEC);
        ServerPlayNetworking.registerGlobalReceiver(PingLocationC2SPacket.PACKET_TYPE, (packet, context) -> ServerCore.onPingLocation(context.player().field_13995, context.player(), packet));
        ServerPlayNetworking.registerGlobalReceiver(UpdateChannelC2SPacket.PACKET_TYPE, (packet, context) -> ServerCore.onChannelUpdate(context.player(), packet));
        ServerPlayConnectionEvents.DISCONNECT.register((networkHandler, a) -> ServerCore.onPlayerDisconnect(networkHandler.field_14140));
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> dispatcher.register(ServerCommandBuilder.build((TriConsumer<CommandContext<class_2168>, Boolean, class_5250>)((TriConsumer)(context, success, response) -> {
            if (success.booleanValue()) {
                ((class_2168)context.getSource()).method_9226(() -> LanguageUtils.withModPrefix(response), false);
            } else {
                ((class_2168)context.getSource()).method_9213((class_2561)LanguageUtils.withModPrefix(response));
            }
        }))));
        ServerCore.init();
    }
}

