/*
 * Decompiled with CFR 0.152.
 */
package com.shmove.cat_jam;

import com.shmove.cat_jam.discs.Disc;
import com.shmove.cat_jam.discs.DiscManager;
import com.shmove.cat_jam.discs.DiscPlayback;
import com.shmove.cat_jam.discs.DiscSegment;
import com.shmove.cat_jam.discs.NodPattern;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class cat_jam {
    public static final String MOD_ID = "cat_jam";
    public static final DiscManager discManager = new DiscManager();
    private static final HashMap<class_2338, DiscPlayback> musicSourceBlocks = new HashMap();
    private static final HashMap<Integer, DiscPlayback> musicSourceEntities = new HashMap();
    public static final double JAM_RADIUS = 3.46;
    public static final Logger LOGGER = LoggerFactory.getLogger((String)"cat_jam");

    public static void init() {
        cat_jam.initialiseDiscs();
    }

    public static void tickPlayingDiscs(class_1937 world) {
        DiscPlayback playback;
        ArrayList<class_2338> musicSourceBlockKeys = new ArrayList<class_2338>(musicSourceBlocks.keySet());
        ArrayList<Integer> musicSourceEntityKeys = new ArrayList<Integer>(musicSourceEntities.keySet());
        for (class_2338 sourcePos : musicSourceBlockKeys) {
            if (cat_jam.isBlockEntityLoadedAtPos(world, sourcePos)) {
                playback = musicSourceBlocks.get(sourcePos);
                if (playback == null) continue;
                playback.tick();
                continue;
            }
            cat_jam.removeMusicSource(sourcePos);
        }
        for (Integer musicSourceEntityID : musicSourceEntityKeys) {
            if (world.method_8469(musicSourceEntityID.intValue()) != null) {
                playback = musicSourceEntities.get(musicSourceEntityID);
                if (playback == null) continue;
                playback.tick();
                continue;
            }
            cat_jam.removeMusicSource(musicSourceEntityID);
        }
    }

    public static void clearPlayingDiscs() {
        musicSourceBlocks.clear();
        musicSourceEntities.clear();
    }

    private static boolean shouldIgnoreDiscPlayback(Disc disc) {
        return disc.getSegment(0).bpm() == 0.0;
    }

    public static void addMusicSource(class_2338 sourcePos, Disc disc) {
        if (cat_jam.shouldIgnoreDiscPlayback(disc)) {
            return;
        }
        musicSourceBlocks.put(sourcePos, new DiscPlayback(disc));
    }

    public static void addMusicSource(Integer sourceEntityID, Disc disc) {
        if (cat_jam.shouldIgnoreDiscPlayback(disc)) {
            return;
        }
        musicSourceEntities.put(sourceEntityID, new DiscPlayback(disc));
    }

    public static void removeMusicSource(class_2338 sourcePos) {
        musicSourceBlocks.remove(sourcePos);
    }

    public static void removeMusicSource(Integer sourceEntityID) {
        musicSourceEntities.remove(sourceEntityID);
    }

    @Nullable
    public static class_2338 getClosestListenableSourcePos(class_243 catPos) {
        class_2338 closestPos = null;
        double closestDistance = Double.MAX_VALUE;
        ArrayList<class_2338> musicSourceBlockPositions = new ArrayList<class_2338>(musicSourceBlocks.keySet());
        for (class_2338 sourcePos : musicSourceBlockPositions) {
            double distance = sourcePos.method_19770((class_2374)catPos);
            if (!(distance < closestDistance) || !(distance < class_3532.method_33723((double)3.46))) continue;
            closestPos = sourcePos;
            closestDistance = distance;
        }
        return closestPos;
    }

    @Nullable
    public static class_1297 getClosestListenableSourceEntity(class_243 catPos) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return null;
        }
        class_1297 closestEntity = null;
        double closestDistance = Double.MAX_VALUE;
        ArrayList<Integer> musicSourceEntityIDs = new ArrayList<Integer>(musicSourceEntities.keySet());
        for (Integer sourceEntityID : musicSourceEntityIDs) {
            double distance;
            class_1297 sourceEntity = world.method_8469(sourceEntityID.intValue());
            if (sourceEntity == null || !((distance = sourceEntity.method_19538().method_1025(catPos)) < closestDistance) || !(distance < class_3532.method_33723((double)3.46))) continue;
            closestEntity = sourceEntity;
            closestDistance = distance;
        }
        return closestEntity;
    }

    private static boolean isBlockEntityLoadedAtPos(class_1937 world, class_2338 pos) {
        if (world == null) {
            return false;
        }
        return world.method_8321(pos) != null;
    }

    public static boolean isSourcePlayingAtPos(class_2338 sourcePos) {
        return musicSourceBlocks.containsKey(sourcePos);
    }

    public static boolean isSourcePlayingFromEntity(Integer sourceEntityID) {
        return musicSourceEntities.containsKey(sourceEntityID);
    }

    public static DiscPlayback getDiscPlaybackAtPos(class_2338 sourcePos) {
        return musicSourceBlocks.get(sourcePos);
    }

    public static DiscPlayback getDiscPlaybackFromEntity(Integer sourceEntityID) {
        return musicSourceEntities.get(sourceEntityID);
    }

    private static void initialiseDiscs() {
        discManager.addDisc(new Disc("minecraft:music_disc.13", 0.0, 0.0));
        List<DiscSegment> DISC_CAT_SEGMENTS = List.of(new DiscSegment(112.0, 56, NodPattern.SLIGHT), new DiscSegment(112.0, 32, NodPattern.NORMAL_SLIGHT_ALTERNATING), new DiscSegment(112.0, 16, NodPattern.NONE), new DiscSegment(112.0, 64), new DiscSegment(112.0, 32, NodPattern.SLIGHT), new DiscSegment(112.0, 32, NodPattern.NONE), new DiscSegment(112.0, 16, NodPattern.NORMAL_SLIGHT_ALTERNATING), new DiscSegment(112.0, 64), new DiscSegment(112.0, 16, NodPattern.SLIGHT), new DiscSegment(112.0, 13, new NodPattern("x_")), new DiscSegment(112.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.cat", DISC_CAT_SEGMENTS, 0.0));
        List<DiscSegment> DISC_BLOCKS_SEGMENTS = List.of(new DiscSegment(110.0, 47, NodPattern.SLIGHT), new DiscSegment(110.0, 1, NodPattern.NONE), new DiscSegment(110.0, 95, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(110.0, 1, NodPattern.NONE), new DiscSegment(110.0, 47, NodPattern.SLIGHT), new DiscSegment(55.0, 12, NodPattern.SLIGHT), new DiscSegment(110.0, 41, NodPattern.NONE), new DiscSegment(110.0, 63, NodPattern.NORMAL_SLIGHT_ALTERNATING), new DiscSegment(110.0, 27, NodPattern.SLIGHT), new DiscSegment(110.0, 101, NodPattern.NONE), new DiscSegment(880.0, 7, NodPattern.NONE), new DiscSegment(110.0, 1, NodPattern.SLIGHT), new DiscSegment(110.0, 4, NodPattern.NONE), new DiscSegment(55.0, 2, NodPattern.SLIGHT), new DiscSegment(110.0, 7, NodPattern.NONE), new DiscSegment(110.0, 1, NodPattern.SLIGHT), new DiscSegment(110.0, 6, NodPattern.NONE), new DiscSegment(55.0, 4, NodPattern.SLIGHT), new DiscSegment(110.0, 66, NodPattern.SLIGHT), new DiscSegment(55.0, 34, NodPattern.SLIGHT), new DiscSegment(110.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.blocks", DISC_BLOCKS_SEGMENTS, 6.56));
        List<DiscSegment> DISC_CHIRP_SEGMENTS = List.of(new DiscSegment(109.85, 16, new NodPattern("X_x_")), new DiscSegment(109.85, 65), new DiscSegment(109.85, 16, new NodPattern("__xX")), new DiscSegment(109.85, 16), new DiscSegment(54.925, 6, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(54.925, 2, NodPattern.SLIGHT), new DiscSegment(27.4625, 16, NodPattern.SLIGHT), new DiscSegment(54.925, 8, NodPattern.SLIGHT), new DiscSegment(109.85, 64, NodPattern.NORMAL_SLIGHT_ALTERNATING), new DiscSegment(27.4625, 1, NodPattern.SLIGHT), new DiscSegment(109.85, 4, new NodPattern("__xX")), new DiscSegment(109.85, 23), new DiscSegment(109.85, 24, new NodPattern("x_______")), new DiscSegment(109.85, 6, new NodPattern("x_")), new DiscSegment(109.85, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.chirp", DISC_CHIRP_SEGMENTS, 0.0));
        List<DiscSegment> DISC_FAR_SEGMENTS = List.of(new DiscSegment(16.25, 11, NodPattern.SLIGHT), new DiscSegment(32.5, 12, NodPattern.SLIGHT), new DiscSegment(65.0, 16, NodPattern.SLIGHT), new DiscSegment(32.5, 3, NodPattern.SLIGHT), new DiscSegment(32.5, 9, NodPattern.NORMAL_SLIGHT_ALTERNATING), new DiscSegment(65.0, 12, new NodPattern("_XXX")), new DiscSegment(65.0, 3, NodPattern.NONE), new DiscSegment(260.0, 3, NodPattern.NONE), new DiscSegment(260.0, 63, new NodPattern("X_______x__x____")), new DiscSegment(130.0, 65, NodPattern.DOWNBEAT4), new DiscSegment(65.0, 12, new NodPattern("___X")), new DiscSegment(65.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.far", DISC_FAR_SEGMENTS, 0.0));
        List<DiscSegment> DISC_MALL_SEGMENTS = List.of(new DiscSegment(115.0, 28, new NodPattern("x_")), new DiscSegment(115.0, 4, NodPattern.SLIGHT), new DiscSegment(115.0, 30), new DiscSegment(115.0, 2, NodPattern.NONE), new DiscSegment(115.0, 64), new DiscSegment(115.0, 56, NodPattern.NONE), new DiscSegment(115.0, 32, NodPattern.SLIGHT), new DiscSegment(115.0, 32, NodPattern.NORMAL_SLIGHT_ALTERNATING), new DiscSegment(115.0, 64), new DiscSegment(230.0, 12, new NodPattern("_x___x__x__x")), new DiscSegment(115.0, 10, NodPattern.NONE), new DiscSegment(115.0, 1, NodPattern.SLIGHT), new DiscSegment(115.0, 7, NodPattern.NONE), new DiscSegment(115.0, 1, NodPattern.SLIGHT), new DiscSegment(115.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.mall", DISC_MALL_SEGMENTS, 16.69));
        List<DiscSegment> DISC_MELLOHI_SEGMENTS = List.of(new DiscSegment(90.75, 24, new NodPattern("x__")), new DiscSegment(90.75, 21, NodPattern.DOWNBEAT3), new DiscSegment(90.75, 3, new NodPattern("X__")), new DiscSegment(90.75, 45, NodPattern.DOWNBEAT3), new DiscSegment(90.75, 3, new NodPattern("X__")), new DiscSegment(90.75, 24, NodPattern.DOWNBEAT3), new DiscSegment(90.75, 12, new NodPattern("X__")), new DiscSegment(90.75, 12, new NodPattern("x__")), new DiscSegment(90.75, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.mellohi", DISC_MELLOHI_SEGMENTS, 0.0));
        List<DiscSegment> DISC_STAL_SEGMENTS = List.of(new DiscSegment(105.0, 16, new NodPattern("xX_X")), new DiscSegment(105.0, 50, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(105.0, 1, NodPattern.NONE), new DiscSegment(105.0, 1, NodPattern.SLIGHT), new DiscSegment(105.0, 32, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(105.0, 4, new NodPattern("x_xx")), new DiscSegment(105.0, 12, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(105.0, 2, NodPattern.NONE), new DiscSegment(105.0, 2, NodPattern.SLIGHT), new DiscSegment(105.0, 12, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(105.0, 1, NodPattern.SLIGHT), new DiscSegment(105.0, 16, NodPattern.NONE), new DiscSegment(52.5, 3, NodPattern.SLIGHT), new DiscSegment(105.0, 1, NodPattern.NONE), new DiscSegment(105.0, 52, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(105.0, 4, new NodPattern("x_xx")), new DiscSegment(105.0, 33, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(52.5, 5, NodPattern.SLIGHT), new DiscSegment(105.0, 1), new DiscSegment(105.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.stal", DISC_STAL_SEGMENTS, 0.0));
        List<DiscSegment> DISC_STRAD_SEGMENTS = List.of(new DiscSegment(47.0, 8, NodPattern.SLIGHT), new DiscSegment(94.0, 53, NodPattern.SLIGHT), new DiscSegment(94.0, 4, NodPattern.NONE), new DiscSegment(94.0, 64), new DiscSegment(94.0, 1, NodPattern.SLIGHT), new DiscSegment(47.0, 2, NodPattern.SLIGHT), new DiscSegment(94.0, 32, NodPattern.SLIGHT), new DiscSegment(47.0, 8, NodPattern.SLIGHT), new DiscSegment(94.0, 15, NodPattern.SLIGHT), new DiscSegment(94.0, 16, NodPattern.DOWNBEAT4), new DiscSegment(94.0, 16, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(94.0, 17), new DiscSegment(94.0, 6, NodPattern.NONE), new DiscSegment(47.0, 9, NodPattern.SLIGHT), new DiscSegment(94.0, 8, NodPattern.SLIGHT), new DiscSegment(188.0, 15, NodPattern.SLIGHT), new DiscSegment(188.0, 1), new DiscSegment(94.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.strad", DISC_STRAD_SEGMENTS, 0.0));
        List<DiscSegment> DISC_WARD_SEGMENTS = List.of(new DiscSegment(107.0, 32, NodPattern.SLIGHT), new DiscSegment(107.0, 48, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(107.0, 64, NodPattern.SLIGHT), new DiscSegment(107.0, 36, NodPattern.NONE), new DiscSegment(107.0, 64), new DiscSegment(107.0, 16, NodPattern.SLIGHT), new DiscSegment(107.0, 10, NodPattern.NONE), new DiscSegment(214.0, 1, NodPattern.NONE), new DiscSegment(53.5, 5, NodPattern.SLIGHT), new DiscSegment(107.0, 7, NodPattern.SLIGHT), new DiscSegment(107.0, 16, NodPattern.DOWNBEAT4), new DiscSegment(107.0, 1, NodPattern.SLIGHT), new DiscSegment(214.0, 1, NodPattern.NONE), new DiscSegment(107.0, 72, NodPattern.NORMAL_SLIGHT_ALTERNATING), new DiscSegment(107.0, 8, NodPattern.SLIGHT), new DiscSegment(53.5, 7, NodPattern.SLIGHT), new DiscSegment(107.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.ward", DISC_WARD_SEGMENTS, 17.95));
        discManager.addDisc(new Disc("minecraft:music_disc.11", 0.0, 0.0));
        List<DiscSegment> DISC_WAIT_SEGMENTS = List.of(new DiscSegment(57.0, 8, NodPattern.SLIGHT), new DiscSegment(114.0, 1, NodPattern.NONE), new DiscSegment(114.0, 48, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(114.0, 4, NodPattern.SLIGHT), new DiscSegment(114.0, 16, NodPattern.DOWNBEAT8), new DiscSegment(114.0, 7, NodPattern.DOWNBEAT4), new DiscSegment(114.0, 1, NodPattern.NONE), new DiscSegment(114.0, 8, NodPattern.DOWNBEAT4), new DiscSegment(114.0, 32), new DiscSegment(114.0, 32, NodPattern.DOWNBEAT8), new DiscSegment(114.0, 32, new NodPattern("x_______")), new DiscSegment(114.0, 128, NodPattern.NONE), new DiscSegment(114.0, 32, NodPattern.DOWNBEAT8), new DiscSegment(114.0, 33, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(57.0, 8, NodPattern.SLIGHT), new DiscSegment(28.5, 4, NodPattern.SLIGHT), new DiscSegment(14.25, 1, NodPattern.SLIGHT), new DiscSegment(114.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.wait", DISC_WAIT_SEGMENTS, 0.0));
        List<DiscSegment> DISC_OTHERSIDE_SEGMENTS = List.of(new DiscSegment(92.0, 15, NodPattern.NONE), new DiscSegment(46.0, 8, NodPattern.SLIGHT), new DiscSegment(92.0, 1), new DiscSegment(92.0, 126, NodPattern.SLIGHT_NORMAL_ALTERNATING), new DiscSegment(46.0, 9, NodPattern.SLIGHT), new DiscSegment(92.0, 16, NodPattern.SLIGHT), new DiscSegment(92.0, 64), new DiscSegment(92.0, 25, NodPattern.SLIGHT), new DiscSegment(46.0, 3, NodPattern.SLIGHT), new DiscSegment(92.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.otherside", DISC_OTHERSIDE_SEGMENTS, 0.0));
        discManager.addDisc(new Disc("minecraft:music_disc.5", 0.0, 0.0));
        List<DiscSegment> DISC_PIGSTEP_SEGMENTS = List.of(new DiscSegment(21.25, 8, NodPattern.SLIGHT), new DiscSegment(56.666666666666664, 1, NodPattern.SLIGHT), new DiscSegment(34.0, 1, NodPattern.NORMAL), new DiscSegment(85.0, 29), new DiscSegment(85.0, 2, NodPattern.SLIGHT), new DiscSegment(85.0, 30), new DiscSegment(85.0, 2, NodPattern.SLIGHT), new DiscSegment(85.0, 16, NodPattern.DOWNBEAT8), new DiscSegment(85.0, 16, NodPattern.DOWNBEAT4), new DiscSegment(85.0, 16, NodPattern.NORMAL_SLIGHT_ALTERNATING), new DiscSegment(85.0, 1, NodPattern.SLIGHT), new DiscSegment(28.333333333333332, 1, NodPattern.SLIGHT), new DiscSegment(21.25, 1, NodPattern.SLIGHT), new DiscSegment(85.0, 8, NodPattern.NONE), new DiscSegment(85.0, 32), new DiscSegment(85.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.pigstep", DISC_PIGSTEP_SEGMENTS, 1.4));
        List<DiscSegment> DISC_RELIC_SEGMENTS = List.of(new DiscSegment(75.0, 4), new DiscSegment(69.0, 4), new DiscSegment(59.0, 4), new DiscSegment(59.0, 2, NodPattern.NONE), new DiscSegment(236.0, 1), new DiscSegment(17.0, 4), new DiscSegment(34.0, 3, NodPattern.SLIGHT), new DiscSegment(34.0, 1), new DiscSegment(34.0, 2, NodPattern.SLIGHT), new DiscSegment(68.0, 5, NodPattern.NONE), new DiscSegment(68.0, 2, NodPattern.SLIGHT), new DiscSegment(68.0, 2, NodPattern.NONE), new DiscSegment(68.0, 7, NodPattern.SLIGHT), new DiscSegment(68.0, 3, NodPattern.NONE), new DiscSegment(68.0, 11, NodPattern.SLIGHT), new DiscSegment(68.0, 1, NodPattern.NONE), new DiscSegment(68.0, 1, NodPattern.SLIGHT), new DiscSegment(68.0, 3, NodPattern.NONE), new DiscSegment(136.0, 62, new NodPattern("XxX_xxX_")), new DiscSegment(68.0, 1, NodPattern.NONE), new DiscSegment(136.0, 64, new NodPattern("xxxX")), new DiscSegment(68.0, 8, new NodPattern("xX__")), new DiscSegment(68.0, 31, NodPattern.DOWNBEAT8), new DiscSegment(68.0, 1, NodPattern.NONE), new DiscSegment(68.0, 48, NodPattern.DOWNBEAT8), new DiscSegment(68.0, 1, NodPattern.SLIGHT), new DiscSegment(34.0, 4, NodPattern.SLIGHT), new DiscSegment(68.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.relic", DISC_RELIC_SEGMENTS, 4.05));
        List<DiscSegment> DISC_CREATOR_MUSIC_BOX_SEGMENTS = List.of(new DiscSegment(111.0, 24, new NodPattern("x_____")), new DiscSegment(111.0, 48, new NodPattern("x__x_xx__x__")), new DiscSegment(111.0, 18, new NodPattern("x__")), new DiscSegment(111.0, 7, NodPattern.SLIGHT), new DiscSegment(111.0, 3, new NodPattern("__x")), new DiscSegment(108.0, 3, new NodPattern("__x")), new DiscSegment(100.0, 3, new NodPattern("__x")), new DiscSegment(92.0, 3, new NodPattern("__x")), new DiscSegment(84.0, 3, new NodPattern("__x")), new DiscSegment(68.0, 3, new NodPattern("__x")), new DiscSegment(60.0, 3, new NodPattern("__x")), new DiscSegment(60.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.creator_music_box", DISC_CREATOR_MUSIC_BOX_SEGMENTS, 2.6719999999999997));
        List<DiscSegment> DISC_CREATOR_SEGMENTS = List.of(new DiscSegment(90.0, 1, NodPattern.SLIGHT), new DiscSegment(90.0, 6, new NodPattern("__x")), new DiscSegment(87.0, 3, new NodPattern("__x")), new DiscSegment(84.0, 3, new NodPattern("__x")), new DiscSegment(78.0, 3, new NodPattern("__x")), new DiscSegment(75.703, 5, NodPattern.NONE), new DiscSegment(75.703, 1, NodPattern.SLIGHT), new DiscSegment(162.0, 11, new NodPattern("__x__x__xxx")), new DiscSegment(162.0, 24, new NodPattern("X__")), new DiscSegment(162.0, 45, new NodPattern("X_x")), new DiscSegment(162.0, 21, new NodPattern("X__")), new DiscSegment(162.0, 6, new NodPattern("Xxx")), new DiscSegment(162.0, 24, new NodPattern("X__")), new DiscSegment(162.0, 42, new NodPattern("x__")), new DiscSegment(162.0, 1, NodPattern.NONE), new DiscSegment(162.0, 5, NodPattern.SLIGHT), new DiscSegment(162.0, 48, new NodPattern("X_x")), new DiscSegment(162.0, 21, new NodPattern("Xxx")), new DiscSegment(162.0, 3), new DiscSegment(162.0, 21, new NodPattern("Xxx")), new DiscSegment(162.0, 3), new DiscSegment(162.0, 45, new NodPattern("Xxx")), new DiscSegment(162.0, 3), new DiscSegment(162.0, 21, new NodPattern("Xxx")), new DiscSegment(162.0, 3), new DiscSegment(162.0, 21, new NodPattern("Xxx")), new DiscSegment(162.0, 3), new DiscSegment(162.0, 1), new DiscSegment(162.0, 9, new NodPattern("__X")), new DiscSegment(150.0, 3, new NodPattern("__X")), new DiscSegment(138.0, 3, new NodPattern("__X")), new DiscSegment(123.0, 5, NodPattern.NONE), new DiscSegment(123.0, 1, NodPattern.SLIGHT), new DiscSegment(78.0, 3, new NodPattern("__x")), new DiscSegment(66.0, 3, new NodPattern("__x")), new DiscSegment(60.0, 3, new NodPattern("__x")), new DiscSegment(60.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.creator", DISC_CREATOR_SEGMENTS, 0.05));
        List<DiscSegment> DISC_PRECIPICE_SEGMENTS = List.of(new DiscSegment(136.0, 45, new NodPattern("X_x_x_x_")), new DiscSegment(136.0, 3, NodPattern.SLIGHT), new DiscSegment(136.0, 29), new DiscSegment(544.0, 12, new NodPattern("__X")), new DiscSegment(544.0, 4, new NodPattern("_X")), new DiscSegment(136.0, 59), new DiscSegment(544.0, 12, new NodPattern("_____x")), new DiscSegment(544.0, 7, NodPattern.NONE), new DiscSegment(544.0, 1, NodPattern.SLIGHT), new DiscSegment(136.0, 63, NodPattern.SLIGHT), new DiscSegment(136.0, 24, new NodPattern("X_x_x_x_")), new DiscSegment(136.0, 8, new NodPattern("X_X_xxxx")), new DiscSegment(136.0, 13), new DiscSegment(544.0, 12, new NodPattern("__X")), new DiscSegment(544.0, 4, new NodPattern("_X")), new DiscSegment(136.0, 12), new DiscSegment(544.0, 12, new NodPattern("__X")), new DiscSegment(544.0, 4, new NodPattern("_X")), new DiscSegment(136.0, 95), new DiscSegment(136.0, 32, new NodPattern("x___")), new DiscSegment(136.0, 32, new NodPattern("x_")), new DiscSegment(136.0, 32, new NodPattern("X_x_x_x_")), new DiscSegment(136.0, 28, new NodPattern("Xxxx")), new DiscSegment(136.0, 4, new NodPattern("Xx_x")), new DiscSegment(136.0, 29, new NodPattern("Xxxx")), new DiscSegment(544.0, 12, new NodPattern("__x")), new DiscSegment(544.0, 2, new NodPattern("_x")), new DiscSegment(544.0, 2, new NodPattern("_X")), new DiscSegment(136.0, 120), new DiscSegment(544.0, 24, new NodPattern("__x__x__x__X")), new DiscSegment(544.0, 5, NodPattern.NONE), new DiscSegment(544.0, 1), new DiscSegment(136.0, -1, NodPattern.NONE));
        discManager.addDisc(new Disc("minecraft:music_disc.precipice", DISC_PRECIPICE_SEGMENTS, 0.065));
    }
}

