/*
 * Decompiled with CFR 0.152.
 */
package tk.estecka.clothgamerules;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;
import me.shedaniel.clothconfig2.api.AbstractConfigListEntry;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import me.shedaniel.clothconfig2.gui.entries.TextListEntry;
import me.shedaniel.clothconfig2.impl.builders.AbstractFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.StringFieldBuilder;
import me.shedaniel.clothconfig2.impl.builders.TextDescriptionBuilder;
import net.fabricmc.fabric.api.gamerule.v1.CustomGameRuleCategory;
import net.fabricmc.fabric.api.gamerule.v1.rule.EnumRule;
import net.minecraft.class_1074;
import net.minecraft.class_124;
import net.minecraft.class_1928;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Nullable;
import tk.estecka.clothgamerules.ClothGamerules;
import tk.estecka.clothgamerules.IRuleCategory;
import tk.estecka.clothgamerules.IRuleString;
import tk.estecka.preferredgamerules.IRuleFactory;

public class GamerulesMenuFactory {
    public static final class_2561 DEFAULT_TITLE = class_2561.method_43471((String)"editGamerule.title");
    private static final class_2561 WILDCARD_TITLE = class_2561.method_43471((String)"cloth-gamerules.wildcardTab").method_27692(class_124.field_1054);
    public static final class_2561 MISSING_WIDGET = class_2561.method_43473().method_27692(class_124.field_1061).method_27693("(").method_10852((class_2561)class_2561.method_43471((String)"cloth-gamerules.missing_widget")).method_27693(")");

    public static class_437 CreateScreen(class_437 parent, class_2561 title, final class_1928 rules, final class_1928 resetValues, Consumer<Optional<class_1928>> onClose) {
        ConfigBuilder builder = ConfigBuilder.create();
        final ConfigEntryBuilder entries = builder.entryBuilder();
        final HashMap subs = new HashMap();
        final HashMap vanillaCats = new HashMap();
        builder.setParentScreen(parent);
        builder.setTitle(title);
        builder.setSavingRunnable(() -> onClose.accept(Optional.of(rules)));
        class_1928.method_20744((class_1928.class_4311)new class_1928.class_4311(){

            public <T extends class_1928.class_4315<T>> void method_20762(class_1928.class_4313<T> key, class_1928.class_4314<T> type) {
                IRuleCategory cat = GamerulesMenuFactory.GetCategory(key);
                class_2960 catId = cat.GetId();
                vanillaCats.computeIfAbsent(catId, __ -> key.method_27335());
                CategoryEntries sub = subs.computeIfAbsent(catId, id -> new CategoryEntries(entries, cat));
                AbstractFieldBuilder<?, ?, ?> field = GamerulesMenuFactory.StartRuleField(entries, key, type, rules.method_20746(key), resetValues.method_20746(key));
                AbstractConfigListEntry entry = field != null ? field.build() : GamerulesMenuFactory.StartMissingType(entries, key, type).build();
                sub.entries.add(entry);
                ArrayList<String> searchTags = new ArrayList<String>();
                searchTags.add(key.method_27334());
                searchTags.add(class_1074.method_4662((String)key.method_27334(), (Object[])new Object[0]));
                entry.appendSearchTags(searchTags);
                sub.header.appendSearchTags(searchTags);
            }
        });
        Stream sortedSubs = subs.entrySet().stream().sorted((a, b) -> {
            boolean mB;
            class_2960 idA = (class_2960)a.getKey();
            class_2960 idB = (class_2960)b.getKey();
            boolean mA = ((class_2960)a.getKey()).method_12836().equals("minecraft");
            if (mA != (mB = ((class_2960)b.getKey()).method_12836().equals("minecraft"))) {
                return -Boolean.compare(mA, mB);
            }
            if (mA && mB) {
                return ((class_1928.class_5198)vanillaCats.get(idA)).compareTo((Enum)((class_1928.class_5198)vanillaCats.get(idB)));
            }
            int diff = idA.method_12836().compareTo(idB.method_12836());
            if (diff != 0) {
                return diff;
            }
            return idA.method_12832().compareTo(idB.method_12832());
        });
        HashMap<String, ConfigCategory> tabs = new HashMap<String, ConfigCategory>();
        ConfigCategory wildcard = builder.getOrCreateCategory(WILDCARD_TITLE);
        for (Map.Entry entry : sortedSubs.toList()) {
            class_2960 id = (class_2960)entry.getKey();
            CategoryEntries sub = (CategoryEntries)entry.getValue();
            ConfigCategory tab = tabs.computeIfAbsent(id.method_12836(), ns -> builder.getOrCreateCategory((class_2561)class_2561.method_43470((String)ns)));
            wildcard.addEntry((AbstractConfigListEntry)sub.header);
            tab.addEntry((AbstractConfigListEntry)sub.header);
            sub.entries.forEach(e -> {
                tab.addEntry(e);
                wildcard.addEntry(e);
            });
        }
        builder.setFallbackCategory(wildcard);
        return builder.build();
    }

    public static IRuleCategory GetCategory(class_1928.class_4313<?> key) {
        Optional custom = CustomGameRuleCategory.getCategory(key);
        if (custom.isPresent()) {
            return IRuleCategory.Of((CustomGameRuleCategory)custom.get());
        }
        return IRuleCategory.Of(key.method_27335());
    }

    public static Optional<class_2561[]> CreateTooltip(class_1928.class_4313<?> key, class_1928.class_4314<?> type) {
        ArrayList<class_5250> tooltip = new ArrayList<class_5250>(4);
        String descKey = key.method_27334() + ".description";
        tooltip.add(class_2561.method_43470((String)key.method_20771()).method_27692(class_124.field_1054));
        if (class_1074.method_4663((String)descKey)) {
            tooltip.add(class_2561.method_43471((String)descKey));
        }
        if (ClothGamerules.IS_PREFRULE_INSTALLED) {
            IRuleFactory factory = IRuleFactory.Of(type);
            tooltip.add(class_2561.method_43469((String)"editGamerule.preferred", (Object[])new Object[]{factory.preferredgamerules$CreatePreferredRule().method_20779()}).method_27692(class_124.field_1080));
            tooltip.add(class_2561.method_43469((String)"editGamerule.default", (Object[])new Object[]{factory.preferredgamerules$CreateDefaultRule().method_20779()}).method_27692(class_124.field_1080));
        } else {
            tooltip.add(class_2561.method_43469((String)"editGamerule.default", (Object[])new Object[]{type.method_20773().method_20779()}).method_27692(class_124.field_1080));
        }
        return Optional.of(tooltip.toArray(new class_2561[1]));
    }

    @Nullable
    public static <T extends class_1928.class_4315<T>> AbstractFieldBuilder<?, ?, ?> StartRuleField(ConfigEntryBuilder entryBuilder, class_1928.class_4313<T> key, class_1928.class_4314<T> type, class_1928.class_4315<T> rule, class_1928.class_4315<T> resetValue) {
        StringFieldBuilder field = null;
        String nameKey = key.method_27334();
        class_5250 displayName = class_2561.method_43471((String)nameKey);
        IRuleString validateableRule = IRuleString.Of(rule);
        if (validateableRule != null) {
            field = entryBuilder.startStrField((class_2561)displayName, validateableRule.GetValue()).setSaveConsumer(s -> validateableRule.Validate(nameKey)).setErrorSupplier(validateableRule::ErrorProvider).setDefaultValue(resetValue.method_20779());
        } else if (rule instanceof class_1928.class_4310) {
            class_1928.class_4310 boolRule = (class_1928.class_4310)rule;
            field = entryBuilder.startBooleanToggle((class_2561)displayName, boolRule.method_20753()).setSaveConsumer(b -> boolRule.method_20758(b.booleanValue(), null)).setDefaultValue(((class_1928.class_4310)resetValue).method_20753());
        } else if (rule instanceof EnumRule) {
            EnumRule enumRule = (EnumRule)rule;
            Class enumClass = enumRule.getEnumClass();
            field = entryBuilder.startEnumSelector((class_2561)displayName, enumClass, enumRule.get()).setSaveConsumer(e -> enumRule.set(e, null)).setErrorSupplier(e -> enumRule.supports(e) ? Optional.empty() : Optional.of(class_2561.method_43469((String)"argument.enum.invalid", (Object[])new Object[]{e.toString()}))).setDefaultValue(((EnumRule)resetValue).get());
        }
        if (field != null) {
            field.setTooltipSupplier(() -> GamerulesMenuFactory.CreateTooltip(key, type));
        }
        return field;
    }

    public static TextDescriptionBuilder StartMissingType(ConfigEntryBuilder entryBuilder, class_1928.class_4313<?> key, class_1928.class_4314<?> type) {
        class_5250 text = class_2561.method_43471((String)key.method_27334()).method_27692(class_124.field_1080).method_27693(" ").method_10852(MISSING_WIDGET);
        TextDescriptionBuilder entry = entryBuilder.startTextDescription((class_2561)text);
        entry.setTooltipSupplier(() -> GamerulesMenuFactory.CreateTooltip(key, type));
        return entry;
    }

    static class CategoryEntries {
        public final TextListEntry header;
        public final List<AbstractConfigListEntry<?>> entries = new ArrayList();

        CategoryEntries(ConfigEntryBuilder entryBuilder, IRuleCategory cat) {
            this.header = entryBuilder.startTextDescription(cat.GetTitle()).build();
        }
    }
}

