/*
 * Decompiled with CFR 0.152.
 */
package com.aizistral.nochatreports.common.encryption;

import com.aizistral.nochatreports.common.encryption.CaesarEncryption;
import com.aizistral.nochatreports.common.encryption.Encryption;
import com.aizistral.nochatreports.common.encryption.Encryptor;
import java.security.InvalidKeyException;

public class CaesarEncryptor
extends Encryptor<CaesarEncryption> {
    private static final char PARAGRAPH = '\u00a7';
    private static final char PARAGRAPH_PLACEHOLDER = '\uffef';
    private static final char DELETE = '\u007f';
    private static final char DELETE_PLACEHOLDER = '\ufff0';
    private final int shift;

    protected CaesarEncryptor(int shift) throws InvalidKeyException {
        if (!Encryption.CAESAR.validateKey(String.valueOf(shift))) {
            throw new InvalidKeyException();
        }
        this.shift = shift;
    }

    protected CaesarEncryptor(String key) throws InvalidKeyException {
        this.shift = CaesarEncryptor.fromString(key);
    }

    @Override
    public String encrypt(String message) {
        char[] chars = CaesarEncryptor.ensureUTF8(message).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            chars[i] = (char)(chars[i] + this.shift);
            if (chars[i] == '\u00a7') {
                chars[i] = 65519;
                continue;
            }
            if (chars[i] != '\u007f') continue;
            chars[i] = 65520;
        }
        return new String(chars);
    }

    @Override
    public String decrypt(String message) {
        char[] chars = CaesarEncryptor.ensureUTF8(message).toCharArray();
        for (int i = 0; i < chars.length; ++i) {
            if (chars[i] == '\uffef') {
                chars[i] = 167;
            } else if (chars[i] == '\ufff0') {
                chars[i] = 127;
            }
            chars[i] = (char)(chars[i] - this.shift);
        }
        return new String(chars);
    }

    @Override
    public CaesarEncryption getAlgorithm() {
        return Encryption.CAESAR;
    }

    @Override
    public String getKey() {
        return String.valueOf(this.shift);
    }

    private static int fromString(String key) throws InvalidKeyException {
        if (!Encryption.CAESAR.validateKey(key)) {
            throw new InvalidKeyException(key);
        }
        return Integer.valueOf(key);
    }
}

