/*
 * Decompiled with CFR 0.152.
 */
package cc.abbie.emi_ores.client.config;

import cc.abbie.emi_ores.EmiOres;
import cc.abbie.emi_ores.Platform;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonIOException;
import com.google.gson.JsonSyntaxException;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;

public record EmiOresClientConfig(boolean addBiomesToIndex) {
    public static Codec<EmiOresClientConfig> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.BOOL.fieldOf("add_biomes_to_index").forGetter(EmiOresClientConfig::addBiomesToIndex)).apply((Applicative)instance, EmiOresClientConfig::new));
    private static final EmiOresClientConfig DEFAULT = new EmiOresClientConfig(true);
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    public static EmiOresClientConfig INSTANCE;

    private static File getConfigFile() {
        return Platform.getConfigDir().resolve("emi_ores-client.json").toFile();
    }

    private static EmiOresClientConfig loadInner() {
        EmiOresClientConfig emiOresClientConfig;
        FileReader fileReader = new FileReader(EmiOresClientConfig.getConfigFile());
        try {
            emiOresClientConfig = CODEC.parse((DynamicOps)JsonOps.INSTANCE, (Object)((JsonElement)GSON.fromJson((Reader)fileReader, JsonElement.class))).resultOrPartial().orElse(DEFAULT);
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (JsonIOException | JsonSyntaxException | IOException e) {
                return DEFAULT;
            }
        }
        fileReader.close();
        return emiOresClientConfig;
    }

    public static void load() {
        INSTANCE = EmiOresClientConfig.loadInner();
        EmiOresClientConfig.save();
    }

    public static void save() {
        try (FileWriter fileWriter = new FileWriter(EmiOresClientConfig.getConfigFile());){
            EmiOresClientConfig.getConfigFile().getParentFile().mkdirs();
            JsonElement jsonElement = (JsonElement)CODEC.encodeStart((DynamicOps)JsonOps.INSTANCE, (Object)INSTANCE).getOrThrow();
            GSON.toJson(jsonElement, (Appendable)fileWriter);
        }
        catch (JsonIOException | IOException | IllegalStateException e) {
            EmiOres.LOG.error("Failed to save config", e);
        }
    }
}

