/*
 * Decompiled with CFR 0.152.
 */
package com.teamabode.guarding.core.util;

import com.teamabode.guarding.common.enchantment.BlockedConditionalEffect;
import com.teamabode.guarding.common.enchantment.EnchantmentConsumer;
import com.teamabode.guarding.core.registry.GuardingEnchantmentEffects;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1887;
import net.minecraft.class_3218;
import net.minecraft.class_6880;
import net.minecraft.class_9304;
import net.minecraft.class_9334;
import net.minecraft.class_9699;
import net.minecraft.class_9721;
import org.apache.commons.lang3.mutable.MutableFloat;

public class EnchantmentUtils {
    public static float modifyParryKnockback(class_1657 player, float baseStrength) {
        MutableFloat strength = new MutableFloat(baseStrength);
        EnchantmentUtils.runIterationOnItem(player.method_6030(), (holder, level) -> {
            class_1887 enchantment = (class_1887)holder.comp_349();
            enchantment.method_60506(GuardingEnchantmentEffects.SHIELD_KNOCKBACK, player.method_59922(), level, strength);
        });
        return strength.floatValue();
    }

    public static void runBlockedEffects(class_3218 server, class_1657 player, class_1282 source, boolean performedParry) {
        class_1799 stack = player.method_6030();
        EnchantmentUtils.runIterationOnItem(stack, (holder, level) -> {
            class_1887 enchantment = (class_1887)holder.comp_349();
            class_9699 enchantedItem = new class_9699(stack, EnchantmentUtils.getSlotFromHand(player.method_6058()), (class_1309)player);
            for (BlockedConditionalEffect blockedCondition : enchantment.method_60034(GuardingEnchantmentEffects.SHIELD_BLOCKED)) {
                if (performedParry && blockedCondition.cancelOnParry()) continue;
                EnchantmentUtils.tryEffect(blockedCondition, server, level, enchantedItem, player, source);
            }
        });
    }

    public static void runParriedEffects(class_3218 server, class_1657 player, class_1282 source) {
        class_1799 stack = player.method_6030();
        EnchantmentUtils.runIterationOnItem(stack, (holder, level) -> {
            class_1887 enchantment = (class_1887)holder.comp_349();
            class_9699 enchantedItem = new class_9699(stack, EnchantmentUtils.getSlotFromHand(player.method_6058()), (class_1309)player);
            for (BlockedConditionalEffect targetedCondition : enchantment.method_60034(GuardingEnchantmentEffects.SHIELD_PARRIED)) {
                EnchantmentUtils.tryEffect(targetedCondition, server, level, enchantedItem, player, source);
            }
        });
    }

    public static class_1304 getSlotFromHand(class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return class_1304.field_6173;
        }
        return class_1304.field_6171;
    }

    public static void tryEffect(BlockedConditionalEffect<class_9721> blockedCondition, class_3218 server, int level, class_9699 enchantedItem, class_1657 player, class_1282 source) {
        if (blockedCondition.matches(class_1887.method_60040((class_3218)server, (int)level, (class_1297)player, (class_1282)source))) {
            class_1657 target;
            switch (blockedCondition.affected()) {
                default: {
                    throw new MatchException(null, null);
                }
                case field_51685: {
                    class_1657 class_16572 = player;
                    break;
                }
                case field_51683: {
                    class_1657 class_16572 = source.method_5529();
                    break;
                }
                case field_51684: {
                    class_1657 class_16572 = target = source.method_5526();
                }
            }
            if (target != null) {
                blockedCondition.effect().method_60220(server, level, enchantedItem, (class_1297)target, target.method_19538());
            }
        }
    }

    public static void runIterationOnItem(class_1799 stack, EnchantmentConsumer consumer) {
        class_9304 enchantments = (class_9304)stack.method_57825(class_9334.field_49633, (Object)class_9304.field_49385);
        for (Object2IntMap.Entry entry : enchantments.method_57539()) {
            consumer.accept((class_6880<class_1887>)((class_6880)entry.getKey()), entry.getIntValue());
        }
    }
}

