/*
 * Decompiled with CFR 0.152.
 */
package com.teamabode.guarding.core.util;

import com.teamabode.guarding.GuardingConfig;
import com.teamabode.guarding.core.access.ProjectileAccessor;
import com.teamabode.guarding.core.registry.GuardingParticles;
import com.teamabode.guarding.core.registry.GuardingSounds;
import com.teamabode.guarding.core.registry.GuardingStats;
import com.teamabode.guarding.core.tag.GuardingDamageTypeTags;
import com.teamabode.guarding.core.util.EnchantmentUtils;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_3218;
import net.minecraft.class_3419;

public class ShieldUtils {
    public static void onBlocked(class_1657 user, class_1282 source, float amount) {
        class_1937 class_19372 = user.method_37908();
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 server = (class_3218)class_19372;
        boolean performedParry = ShieldUtils.canPerformParry(user, source);
        if (performedParry) {
            ShieldUtils.parry(server, user, source);
        }
        user.method_7339(GuardingStats.ATTACKS_BLOCKED_BY_SHIELD, 1);
        EnchantmentUtils.runBlockedEffects(server, user, source, performedParry);
    }

    public static void parry(class_3218 server, class_1657 player, class_1282 source) {
        class_1297 class_12972 = source.method_5526();
        if (class_12972 instanceof class_1676) {
            class_1676 projectile = (class_1676)class_12972;
            ShieldUtils.deflectProjectile(player, projectile);
            ShieldUtils.spawnParticle(server, projectile.method_23317(), projectile.method_23318(), projectile.method_23321());
        } else {
            class_12972 = source.method_5526();
            if (class_12972 instanceof class_1309) {
                class_1309 attacker = (class_1309)class_12972;
                ShieldUtils.knockbackAttacker(player, attacker);
                ShieldUtils.spawnParticle(server, (player.method_23317() + attacker.method_23317()) / 2.0, attacker.method_23320(), (player.method_23321() + attacker.method_23321()) / 2.0);
            }
        }
        player.method_7322(GuardingConfig.INSTANCE.exhaustionCost.get().floatValue());
        server.method_45447(null, player.method_24515(), GuardingSounds.ITEM_SHIELD_PARRY, class_3419.field_15248);
        player.method_7339(GuardingStats.ATTACKS_PARRIED_BY_SHIELD, 1);
        EnchantmentUtils.runParriedEffects(server, player, source);
    }

    public static void knockbackAttacker(class_1657 player, class_1309 attacker) {
        float knockbackStrength = ShieldUtils.getKnockbackStrength(player);
        attacker.field_6037 = true;
        attacker.method_6005((double)knockbackStrength, player.method_23317() - attacker.method_23317(), player.method_23321() - attacker.method_23321());
    }

    public static void deflectProjectile(class_1657 player, class_1676 projectile) {
        ((ProjectileAccessor)projectile).setParrier((class_1297)player);
        projectile.method_18799(projectile.method_18798().method_1021(5.0));
        float reverseRot = 170.0f + projectile.method_59922().method_43057() * 20.0f;
        projectile.method_36456(projectile.method_36454() + reverseRot);
        projectile.field_6007 = true;
    }

    public static float getKnockbackStrength(class_1657 player) {
        float baseStrength = GuardingConfig.INSTANCE.knockbackStrength.get().floatValue();
        return EnchantmentUtils.modifyParryKnockback(player, baseStrength);
    }

    public static void spawnParticle(class_3218 server, double x, double y, double z) {
        server.method_14199((class_2394)GuardingParticles.PARRY, x, y, z, 1, 0.0, 0.0, 0.0, 0.0);
    }

    public static boolean canPerformParry(class_1657 player, class_1282 source) {
        return player.method_6048() <= 3 && !source.method_48789(GuardingDamageTypeTags.NO_PARRY);
    }
}

