/*
 * Decompiled with CFR 0.152.
 */
package net.digitalpear.pigsteel.common.blocks;

import java.util.Optional;
import net.digitalpear.pigsteel.init.PigsteelBlocks;
import net.digitalpear.pigsteel.init.tags.PigsteelBlockTags;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3542;
import net.minecraft.class_3620;
import net.minecraft.class_5547;
import net.minecraft.class_5819;

public interface Zombifiable
extends class_5547<ZombificationLevel> {
    public static final float blockInfluence = 0.1f;
    public static final float baseChance = 0.9f;

    default public boolean canZombify(class_1937 world, class_2680 state) {
        return !world.method_8597().comp_644() && PigsteelBlocks.PIGSTEEL_ZOMBIFYING_MAP.containsKey(state.method_26204());
    }

    default public Optional<class_2680> method_54765(class_2680 state, class_3218 world, class_2338 pos, class_5819 random) {
        return this.tryZombify((class_1937)world, state, pos);
    }

    default public Optional<class_2680> tryZombify(class_1937 world, class_2680 state, class_2338 pos) {
        if (!this.canZombify(world, state) || world.method_8409().method_43048(9) >= 2) {
            return Optional.empty();
        }
        float chance = 0.9f;
        if (this.method_33622() == ZombificationLevel.UNAFFECTED) {
            chance -= 0.1f;
        }
        for (class_2338 blockPos : class_2338.method_10097((class_2338)pos.method_10069(-1, -1, -1), (class_2338)pos.method_10069(1, 1, 1))) {
            if (world.method_8320(blockPos).method_26164(PigsteelBlockTags.ZOMBIFICATION_DECELERATION)) {
                chance -= 0.1f;
                continue;
            }
            if (world.method_8320(blockPos).method_26164(PigsteelBlockTags.ZOMBIFICATION_ACCELERATION)) {
                chance += 0.1f;
                continue;
            }
            if (!this.isZombifiablePigsteelBlock(world.method_8320(blockPos))) continue;
            chance -= 0.05f;
        }
        if (world.method_8409().method_43057() < chance) {
            class_2680 degradedState = PigsteelBlocks.PIGSTEEL_ZOMBIFYING_MAP.get(state.method_26204()).method_34725(state);
            world.method_8652(pos, degradedState, 2);
            return Optional.of(degradedState);
        }
        return Optional.empty();
    }

    default public boolean isZombifiablePigsteelBlock(class_2680 state) {
        return state.method_26204() instanceof Zombifiable;
    }

    public static enum ZombificationLevel implements class_3542
    {
        UNAFFECTED("", class_3620.field_16014),
        INFECTED("infected", class_3620.field_15999),
        CORRUPTED("corrupted", class_3620.field_15995),
        ZOMBIFIED("zombified", class_3620.field_16004);

        private String name;
        private class_3620 mapColor;

        private ZombificationLevel(String name, class_3620 mapColor) {
            this.name = name;
            this.mapColor = mapColor;
        }

        public class_3620 getMapColor() {
            return this.mapColor;
        }

        public String method_15434() {
            return this.name;
        }
    }
}

