/*
 * Decompiled with CFR 0.152.
 */
package net.digitalpear.pigsteel.common.datagen;

import java.util.Optional;
import net.digitalpear.pigsteel.Pigsteel;
import net.digitalpear.pigsteel.init.PigsteelBlocks;
import net.digitalpear.pigsteel.init.PigsteelItems;
import net.fabricmc.fabric.api.datagen.v1.FabricDataOutput;
import net.fabricmc.fabric.api.datagen.v1.provider.FabricModelProvider;
import net.minecraft.class_2248;
import net.minecraft.class_2960;
import net.minecraft.class_4910;
import net.minecraft.class_4915;
import net.minecraft.class_4925;
import net.minecraft.class_4935;
import net.minecraft.class_4936;
import net.minecraft.class_4942;
import net.minecraft.class_4943;
import net.minecraft.class_4944;
import net.minecraft.class_4945;
import net.minecraft.class_4946;
import net.minecraft.class_7923;

public class PigsteelModelProvider
extends FabricModelProvider {
    public PigsteelModelProvider(FabricDataOutput output) {
        super(output);
    }

    public void generateBlockStateModels(class_4910 blockStateModelGenerator) {
        blockStateModelGenerator.method_25622(PigsteelBlocks.PORKSLAG, class_4946.field_23038);
        blockStateModelGenerator.method_25641(PigsteelBlocks.PIGSTEEL_CHUNK_BLOCK);
        PigsteelBlocks.refinedPigsteel.getBlockToWaxedMap().forEach((block, waxed) -> {
            blockStateModelGenerator.method_25641(block);
            blockStateModelGenerator.method_25672(block, waxed);
        });
        PigsteelBlocks.pigsteelLanterns.getBlockToWaxedMap().forEach((block, waxed) -> {
            this.createLantern(blockStateModelGenerator, (class_2248)block);
            this.createLantern(blockStateModelGenerator, (class_2248)waxed, (class_2248)block);
        });
        PigsteelBlocks.pigsteelSoulLanterns.getBlockToWaxedMap().forEach((block, waxed) -> {
            this.createLantern(blockStateModelGenerator, (class_2248)block);
            this.createLantern(blockStateModelGenerator, (class_2248)waxed, (class_2248)block);
        });
        for (int i = 0; i < 4; ++i) {
            this.createWaxable(blockStateModelGenerator, PigsteelBlocks.cutPigsteel.getZombifiables().get(i), PigsteelBlocks.cutPigsteel.getWaxed().get(i));
            PigsteelModelProvider.createWaxableSlab(blockStateModelGenerator, PigsteelBlocks.cutPigsteel.getZombifiables().get(i), PigsteelBlocks.cutPigsteelSlabs.getZombifiables().get(i), PigsteelBlocks.cutPigsteelSlabs.getWaxed().get(i));
        }
        PigsteelModelProvider.createWaxableStairs(blockStateModelGenerator, PigsteelBlocks.cutPigsteel.getUnaffectedBlock(), PigsteelBlocks.CUT_PIGSTEEL_STAIRS, PigsteelBlocks.WAXED_CUT_PIGSTEEL_STAIRS);
        PigsteelModelProvider.createWaxableStairs(blockStateModelGenerator, PigsteelBlocks.cutPigsteel.getInfectedBlock(), PigsteelBlocks.INFECTED_CUT_PIGSTEEL_STAIRS, PigsteelBlocks.WAXED_INFECTED_CUT_PIGSTEEL_STAIRS);
        PigsteelModelProvider.createWaxableStairs(blockStateModelGenerator, PigsteelBlocks.cutPigsteel.getCorruptedBlock(), PigsteelBlocks.CORRUPTED_CUT_PIGSTEEL_STAIRS, PigsteelBlocks.WAXED_CORRUPTED_CUT_PIGSTEEL_STAIRS);
        PigsteelModelProvider.createWaxableStairs(blockStateModelGenerator, PigsteelBlocks.cutPigsteel.getZombifiedBlock(), PigsteelBlocks.ZOMBIFIED_CUT_PIGSTEEL_STAIRS, PigsteelBlocks.WAXED_ZOMBIFIED_CUT_PIGSTEEL_STAIRS);
    }

    public void generateItemModels(class_4915 itemModelGenerator) {
        itemModelGenerator.method_25733(PigsteelItems.PIGSTEEL_CHUNK, class_4943.field_22938);
    }

    private static class_4942 block(String parent, class_4945 ... requiredTextureKeys) {
        return new class_4942(Optional.of(Pigsteel.getModId("block/" + parent)), Optional.empty(), requiredTextureKeys);
    }

    public final void createLantern(class_4910 blockStateModelGenerator, class_2248 lantern) {
        class_2960 identifier = PigsteelModelProvider.block("template_pigsteel_lantern", class_4945.field_23010).method_25846(lantern, class_4944.method_25864((class_2248)lantern), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.method_25537(lantern.method_8389());
        blockStateModelGenerator.field_22830.accept(class_4925.method_25770((class_2248)lantern, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier)).method_25775(class_4910.method_25599()));
    }

    public final void createLantern(class_4910 blockStateModelGenerator, class_2248 lantern, class_2248 baseModel) {
        class_2960 identifier = PigsteelModelProvider.getId(baseModel);
        blockStateModelGenerator.method_25538(lantern.method_8389(), PigsteelModelProvider.getItemId(baseModel));
        blockStateModelGenerator.field_22830.accept(class_4925.method_25770((class_2248)lantern, (class_4935)class_4935.method_25824().method_25828(class_4936.field_22887, (Object)identifier)).method_25775(class_4910.method_25599()));
    }

    public final void createWaxable(class_4910 blockStateModelGenerator, class_2248 block, class_2248 waxed) {
        class_2960 model = class_4946.field_23036.method_25923(block, blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)block, (class_2960)model));
        blockStateModelGenerator.field_22830.accept(class_4910.method_25644((class_2248)waxed, (class_2960)model));
        blockStateModelGenerator.method_25623(waxed, model);
    }

    public static void createWaxableStairs(class_4910 blockStateModelGenerator, class_2248 textureBase, class_2248 stairs, class_2248 waxed) {
        PigsteelModelProvider.createStairs(blockStateModelGenerator, textureBase, stairs);
        PigsteelModelProvider.createWaxedStairs(blockStateModelGenerator, stairs, waxed);
    }

    public static void createWaxableSlab(class_4910 blockStateModelGenerator, class_2248 textureBase, class_2248 slab, class_2248 waxed) {
        PigsteelModelProvider.createSlab(blockStateModelGenerator, textureBase, slab);
        PigsteelModelProvider.createWaxedSlab(blockStateModelGenerator, textureBase, slab, waxed);
    }

    public static void createStairs(class_4910 blockStateModelGenerator, class_2248 textureBase, class_2248 stairs) {
        class_2960 STAIRS = class_4943.field_22912.method_25846(stairs, class_4944.method_25864((class_2248)textureBase), blockStateModelGenerator.field_22831);
        class_2960 INNER_STAIRS = class_4943.field_22913.method_25846(stairs, class_4944.method_25864((class_2248)textureBase), blockStateModelGenerator.field_22831);
        class_2960 OUTER_STAIRS = class_4943.field_22914.method_25846(stairs, class_4944.method_25864((class_2248)textureBase), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25646((class_2248)stairs, (class_2960)INNER_STAIRS, (class_2960)STAIRS, (class_2960)OUTER_STAIRS));
    }

    public static void createWaxedStairs(class_4910 blockStateModelGenerator, class_2248 stairs, class_2248 waxed) {
        class_2960 STAIRS = PigsteelModelProvider.getId(stairs);
        class_2960 INNER_STAIRS = PigsteelModelProvider.getId(stairs, "_inner");
        class_2960 OUTER_STAIRS = PigsteelModelProvider.getId(stairs, "_outer");
        blockStateModelGenerator.field_22830.accept(class_4910.method_25646((class_2248)waxed, (class_2960)INNER_STAIRS, (class_2960)STAIRS, (class_2960)OUTER_STAIRS));
        blockStateModelGenerator.method_25623(waxed, STAIRS);
    }

    public static void createSlab(class_4910 blockStateModelGenerator, class_2248 textureBase, class_2248 slab) {
        class_2960 SLAB = class_4943.field_22909.method_25846(slab, class_4944.method_25864((class_2248)textureBase), blockStateModelGenerator.field_22831);
        class_2960 SLAB_TOP = class_4943.field_22910.method_25846(slab, class_4944.method_25864((class_2248)textureBase), blockStateModelGenerator.field_22831);
        blockStateModelGenerator.field_22830.accept(class_4910.method_25668((class_2248)slab, (class_2960)SLAB, (class_2960)SLAB_TOP, (class_2960)PigsteelModelProvider.getId(textureBase)));
    }

    public static void createWaxedSlab(class_4910 blockStateModelGenerator, class_2248 textureBase, class_2248 slab, class_2248 waxed) {
        class_2960 SLAB = PigsteelModelProvider.getId(slab);
        class_2960 SLAB_TOP = PigsteelModelProvider.getId(slab, "_top");
        blockStateModelGenerator.field_22830.accept(class_4910.method_25668((class_2248)waxed, (class_2960)SLAB, (class_2960)SLAB_TOP, (class_2960)PigsteelModelProvider.getId(textureBase)));
        blockStateModelGenerator.method_25623(waxed, SLAB);
    }

    public static class_2960 getItemId(class_2248 block) {
        class_2960 identifier = class_7923.field_41175.method_10221((Object)block);
        return identifier.method_45138("item/");
    }

    public static class_2960 getId(class_2248 block) {
        class_2960 identifier = class_7923.field_41175.method_10221((Object)block);
        return identifier.method_45138("block/");
    }

    public static class_2960 getId(class_2248 block, String suffix) {
        class_2960 identifier = class_7923.field_41175.method_10221((Object)block);
        identifier = identifier.method_48331(suffix);
        return identifier.method_45138("block/");
    }

    public static class_2960 getId(String prefix, class_2248 block) {
        class_2960 identifier = class_7923.field_41175.method_10221((Object)block);
        identifier = identifier.method_45138(prefix);
        return identifier.method_45138("block/");
    }
}

