/*
 * Decompiled with CFR 0.152.
 */
package net.digitalpear.pigsteel.init.data;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import net.digitalpear.pigsteel.Pigsteel;
import net.digitalpear.pigsteel.common.blocks.Zombifiable;
import net.digitalpear.pigsteel.init.PigsteelBlocks;
import net.fabricmc.fabric.api.itemgroup.v1.FabricItemGroupEntries;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.minecraft.class_1747;
import net.minecraft.class_1761;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2960;
import net.minecraft.class_3620;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_7923;

public class ZombifiableBlockRegistry {
    private Class<? extends class_2248> baseBlockClass;
    private Class<? extends class_2248> waxedBlockClass;
    private String baseName;
    private class_4970.class_2251 settings = class_4970.class_2251.method_9630((class_4970)class_2246.field_10085).method_9626(class_2498.field_22150);
    private class_2248 unaffectedBlock;
    private class_2248 infectedBlock;
    private class_2248 corruptedBlock;
    private class_2248 zombifiedBlock;
    private class_2248 waxedUnaffectedBlock;
    private class_2248 waxedInfectedBlock;
    private class_2248 waxedCorruptedBlock;
    private class_2248 waxedZombifiedBlock;

    public ZombifiableBlockRegistry(String baseName, Class<? extends class_2248> baseBlockClass, Class<? extends class_2248> waxedBlockClass, class_4970.class_2251 settings) {
        this.settings = settings;
        this.defineBlocks(baseName, baseBlockClass, waxedBlockClass);
    }

    public ZombifiableBlockRegistry(String baseName, Class<? extends class_2248> baseBlockClass, Class<? extends class_2248> waxedBlockClass) {
        this.defineBlocks(baseName, baseBlockClass, waxedBlockClass);
        this.mapWaxingAndAxing();
    }

    private void defineBlocks(String baseName, Class<? extends class_2248> baseBlockClass, Class<? extends class_2248> waxedBlockClass) {
        this.baseName = baseName;
        this.baseBlockClass = baseBlockClass;
        this.waxedBlockClass = waxedBlockClass;
        this.unaffectedBlock = this.registerBlock(Zombifiable.ZombificationLevel.UNAFFECTED);
        this.infectedBlock = this.registerBlock(Zombifiable.ZombificationLevel.INFECTED);
        this.corruptedBlock = this.registerBlock(Zombifiable.ZombificationLevel.CORRUPTED);
        this.zombifiedBlock = this.registerBlock(Zombifiable.ZombificationLevel.ZOMBIFIED);
        this.waxedUnaffectedBlock = this.registerBlock(Zombifiable.ZombificationLevel.UNAFFECTED, true);
        this.waxedInfectedBlock = this.registerBlock(Zombifiable.ZombificationLevel.INFECTED, true);
        this.waxedCorruptedBlock = this.registerBlock(Zombifiable.ZombificationLevel.CORRUPTED, true);
        this.waxedZombifiedBlock = this.registerBlock(Zombifiable.ZombificationLevel.ZOMBIFIED, true);
    }

    private class_2248 registerBlock(Zombifiable.ZombificationLevel level) {
        return this.registerBlock(level, false);
    }

    private class_2248 registerBlock(Zombifiable.ZombificationLevel level, boolean waxed) {
        class_2960 blockName = level.equals((Object)Zombifiable.ZombificationLevel.UNAFFECTED) ? Pigsteel.getModId(this.baseName) : Pigsteel.getModId(level.method_15434() + "_" + this.baseName);
        if (waxed) {
            blockName = blockName.method_45138("waxed_");
        }
        class_2248 block = this.createBlock(level.getMapColor(), waxed);
        class_2378.method_10230((class_2378)class_7923.field_41178, (class_2960)blockName, (Object)new class_1747(block, new class_1792.class_1793().method_24359()));
        return (class_2248)class_2378.method_10230((class_2378)class_7923.field_41175, (class_2960)blockName, (Object)block);
    }

    private class_2248 createBlock(class_3620 mapColor, boolean waxed) {
        Class<? extends class_2248> blockClass = waxed ? this.baseBlockClass : this.waxedBlockClass;
        try {
            if (waxed) {
                return blockClass.getConstructor(class_4970.class_2251.class).newInstance(this.settings.method_31710(mapColor));
            }
            return blockClass.getConstructor(class_4970.class_2251.class).newInstance(this.settings.method_31710(mapColor).method_9640());
        }
        catch (Exception e) {
            Pigsteel.LOGGER.error("Block settings for " + this.getBaseName() + " could not be registered.");
            e.printStackTrace();
            return null;
        }
    }

    public class_2248 getUnaffectedBlock() {
        return this.unaffectedBlock;
    }

    public class_2248 getInfectedBlock() {
        return this.infectedBlock;
    }

    public class_2248 getCorruptedBlock() {
        return this.corruptedBlock;
    }

    public class_2248 getZombifiedBlock() {
        return this.zombifiedBlock;
    }

    public String getBaseName() {
        return this.baseName;
    }

    public class_2248 getWaxedUnaffectedBlock() {
        return this.waxedUnaffectedBlock;
    }

    public class_2248 getWaxedInfectedBlock() {
        return this.waxedInfectedBlock;
    }

    public class_2248 getWaxedCorruptedBlock() {
        return this.waxedCorruptedBlock;
    }

    public class_2248 getWaxedZombifiedBlock() {
        return this.waxedZombifiedBlock;
    }

    public Map<class_2248, class_2248> getBlockToWaxedMap() {
        HashMap<class_2248, class_2248> map = new HashMap<class_2248, class_2248>();
        map.put(this.getUnaffectedBlock(), this.getWaxedUnaffectedBlock());
        map.put(this.getInfectedBlock(), this.getWaxedInfectedBlock());
        map.put(this.getCorruptedBlock(), this.getWaxedCorruptedBlock());
        map.put(this.getZombifiedBlock(), this.getWaxedZombifiedBlock());
        return map;
    }

    public List<class_2248> getZombifiables() {
        return List.of(this.unaffectedBlock, this.infectedBlock, this.corruptedBlock, this.zombifiedBlock);
    }

    public List<class_2248> getWaxed() {
        return List.of(this.waxedUnaffectedBlock, this.waxedInfectedBlock, this.waxedCorruptedBlock, this.waxedZombifiedBlock);
    }

    public List<class_2248> getAllBlocks() {
        return List.of(this.unaffectedBlock, this.infectedBlock, this.corruptedBlock, this.zombifiedBlock, this.waxedUnaffectedBlock, this.waxedInfectedBlock, this.waxedCorruptedBlock, this.waxedZombifiedBlock);
    }

    public void addToItemGroup(class_5321<class_1761> itemGroup) {
        ItemGroupEvents.modifyEntriesEvent(itemGroup).register(entries -> this.getAllBlocks().forEach(arg_0 -> ((FabricItemGroupEntries)entries).method_45421(arg_0)));
    }

    public void addToItemGroup(class_5321<class_1761> itemGroup, class_1792 afterItem) {
        ItemGroupEvents.modifyEntriesEvent(itemGroup).register(entries -> {
            List list = this.getAllBlocks().stream().map(class_1799::new).collect(Collectors.toList());
            entries.addAfter((class_1935)afterItem, list);
        });
    }

    private void mapWaxingAndAxing() {
        PigsteelBlocks.PIGSTEEL_WAXING_MAP.putAll(this.getBlockToWaxedMap());
        PigsteelBlocks.PIGSTEEL_ZOMBIFYING_MAP.put(this.getUnaffectedBlock(), this.getInfectedBlock());
        PigsteelBlocks.PIGSTEEL_ZOMBIFYING_MAP.put(this.getInfectedBlock(), this.getCorruptedBlock());
        PigsteelBlocks.PIGSTEEL_ZOMBIFYING_MAP.put(this.getCorruptedBlock(), this.getZombifiedBlock());
    }
}

