/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.client;

import fzzyhmstrs.emi_loot.EMILoot;
import fzzyhmstrs.emi_loot.client.ClientArchaeologyLootTable;
import fzzyhmstrs.emi_loot.client.ClientBlockLootTable;
import fzzyhmstrs.emi_loot.client.ClientChestLootTable;
import fzzyhmstrs.emi_loot.client.ClientGameplayLootTable;
import fzzyhmstrs.emi_loot.client.ClientMobLootTable;
import fzzyhmstrs.emi_loot.client.LootReceiver;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.class_2540;

public class ClientLootTables {
    public static final ClientLootTables INSTANCE = new ClientLootTables();
    private final List<LootReceiver> loots = new LinkedList<LootReceiver>();

    public List<LootReceiver> getLoots() {
        return this.loots;
    }

    public void clearLoots() {
        this.loots.clear();
    }

    void receiveChestSender(class_2540 buf) {
        try {
            LootReceiver table = ClientChestLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.config.isDebug(EMILoot.Type.CHEST)) {
                EMILoot.LOGGER.info("received chest {}", (Object)table.getId());
            }
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while receiving Chest Loot Packet");
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    void receiveBlockSender(class_2540 buf) {
        try {
            LootReceiver table = ClientBlockLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.config.isDebug(EMILoot.Type.BLOCK)) {
                EMILoot.LOGGER.info("received block {}", (Object)table.getId());
            }
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while receiving Block Loot Packet");
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    void receiveMobSender(class_2540 buf) {
        try {
            LootReceiver table = ClientMobLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.config.isDebug(EMILoot.Type.MOB)) {
                EMILoot.LOGGER.info("received mob {}", (Object)table.getId());
            }
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while receiving Mob Loot Packet");
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    void receiveGameplaySender(class_2540 buf) {
        try {
            LootReceiver table = ClientGameplayLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.config.isDebug(EMILoot.Type.GAMEPLAY)) {
                EMILoot.LOGGER.info("received gameplay loot: {}", (Object)table.getId());
            }
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while receiving Gameplay Loot Packet");
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }

    void receiveArchaeologySender(class_2540 buf) {
        try {
            LootReceiver table = ClientArchaeologyLootTable.INSTANCE.fromBuf(buf);
            this.loots.add(table);
            if (EMILoot.config.isDebug(EMILoot.Type.ARCHAEOLOGY)) {
                EMILoot.LOGGER.info("received archaeology loot: {}", (Object)table.getId());
            }
        }
        catch (Throwable e) {
            EMILoot.LOGGER.error("Critical error encountered while receiving Archaeology Loot Packet");
            EMILoot.LOGGER.error("Thrown Error: ", e);
        }
    }
}

