/*
 * Decompiled with CFR 0.152.
 */
package fzzyhmstrs.emi_loot.server;

import fzzyhmstrs.emi_loot.networking.ArchaeologyLootPayload;
import fzzyhmstrs.emi_loot.server.ArchaeologyLootPoolBuilder;
import fzzyhmstrs.emi_loot.server.LootSender;
import io.netty.buffer.Unpooled;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import me.fzzyhmstrs.fzzy_config.api.ConfigApi;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_8710;

public class ArchaeologyLootTableSender
implements LootSender<ArchaeologyLootPoolBuilder> {
    private final String idToSend;
    final List<ArchaeologyLootPoolBuilder> builderList = new LinkedList<ArchaeologyLootPoolBuilder>();
    HashMap<class_1799, Float> floatMap = new HashMap();

    public ArchaeologyLootTableSender(class_2960 id) {
        this.idToSend = LootSender.getIdToSend(id);
    }

    @Override
    public String getId() {
        return this.idToSend;
    }

    @Override
    public void send(class_3222 player) {
        if (!ConfigApi.INSTANCE.network().canSend(ArchaeologyLootPayload.TYPE.comp_2242(), (class_1657)player)) {
            return;
        }
        class_2540 buf = new class_2540(Unpooled.buffer());
        buf.method_10814(this.idToSend);
        buf.method_52998(this.floatMap.size());
        this.floatMap.forEach((item, floatWeight) -> {
            this.writeItemStack(buf, (class_1799)item, (class_1937)player.method_51469());
            buf.method_52941(floatWeight.floatValue());
        });
        ConfigApi.INSTANCE.network().send((class_8710)new ArchaeologyLootPayload(buf), (class_1657)player);
    }

    @Override
    public void addBuilder(ArchaeologyLootPoolBuilder builder) {
        this.builderList.add(builder);
    }

    @Override
    public List<ArchaeologyLootPoolBuilder> getBuilders() {
        return this.builderList;
    }

    @Override
    public void build() {
        this.builderList.forEach(builder -> {
            builder.build();
            builder.builtMap.forEach((item, weight) -> {
                if (this.floatMap.containsKey(item)) {
                    float oldWeight = this.floatMap.getOrDefault(item, Float.valueOf(0.0f)).floatValue();
                    this.floatMap.put((class_1799)item, Float.valueOf(oldWeight + weight.floatValue()));
                } else {
                    this.floatMap.put((class_1799)item, (Float)weight);
                }
            });
        });
    }
}

