/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import folk.sisby.kaleido.api.WrappedConfig;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.Comment;
import folk.sisby.kaleido.lib.quiltconfig.api.annotations.IntegerRange;
import folk.sisby.kaleido.lib.quiltconfig.api.values.ValueMap;
import folk.sisby.kaleido.lib.quiltconfig.impl.Comments;
import java.util.Map;

public class AntiqueAtlasConfig
extends WrappedConfig {
    @Comments(value={@Comment(value={"Whether to display the map in full-screen"}), @Comment(value={"The background is slightly less stylish, but more tiles are shown at once"})})
    public boolean fullscreen = true;
    @Comment(value={"Whether to keep scale after closing the map"})
    public boolean keepZoom = false;
    @Comment(value={"Whether to keep offset after closing the map"})
    public boolean keepOffset = false;
    @Comment(value={"How to depict player death locations."})
    public GraveStyle graveStyle = GraveStyle.EUPHEMISMS;
    @Comments(value={@Comment(value={"The maximum number of chunks to represent as a tile, as a power of 2"}), @Comment(value={"Effectively the 'minimum zoom'"}), @Comment(value={"0: 1x1 chunk = 1 tile | 6: 64x64 chunks = 1 tile"})})
    @IntegerRange(min=0L, max=6L)
    public int maxTileChunks = 5;
    @Comments(value={@Comment(value={"The maximum size to render a tile at, as a power of 2 multiplier"}), @Comment(value={"Effectively the 'maximum zoom'"}), @Comment(value={"0: 1 tile = 16x16 | 3: 1 tile = 128x128"})})
    @IntegerRange(min=0L, max=3L)
    public int maxTilePixels = 1;
    @Comments(value={@Comment(value={"The effective GUI scale for tiles and markers - independent of the overall GUI scale."}), @Comment(value={"0 will match your GUI scale - pixels will be the same size as the background & buttons"}), @Comment(value={"-1 will use half your GUI scale, rounding up."}), @Comment(value={"-2 will use half your GUI scale, rounding down."})})
    @IntegerRange(min=-2L, max=10L)
    public int mapScale = 0;
    @Comment(value={"The maximum number of chunks to load onto the map per tick after entering a world"})
    public int chunkTickLimit = 100;
    @Comment(value={"How to handle biomes that aren't in any minecraft, conventional, or forge biome tags"})
    public FallbackHandling fallbackFailHandling = FallbackHandling.MISSING;
    @Comment(value={"Whether to show debug information about hovered tiles and markers"})
    public boolean debugRender = false;
    public Map<String, Boolean> structureMarkers = ValueMap.builder((Object)true).put("minecraft:type/end_city", (Object)false).build();

    public static enum GraveStyle {
        CAUSE,
        GRAVE,
        ITEMS,
        DIED,
        EUPHEMISMS;

    }

    public static enum FallbackHandling {
        TEST,
        MISSING,
        CRASH;

    }
}

