/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import com.mojang.blaze3d.systems.RenderSystem;
import folk.sisby.antique_atlas.AntiqueAtlas;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_3532;
import org.joml.Vector2d;

public record MarkerTexture(class_2960 id, class_2960 accentId, int offsetX, int offsetY, int textureWidth, int textureHeight, int mipLevels, int nearClip, int farClip) {
    public static final MarkerTexture DEFAULT = MarkerTexture.centered(AntiqueAtlas.id("custom/point"), 32, 32, 0, 1, Integer.MAX_VALUE, true);

    private static class_2960 idToTexture(class_2960 id) {
        return id.method_45138("textures/atlas/marker/").method_48331(".png");
    }

    public static MarkerTexture ofId(class_2960 id, int offsetX, int offsetY, int width, int height, int mipLevels, int nearClip, int farClip, boolean accent) {
        return new MarkerTexture(MarkerTexture.idToTexture(id), accent ? MarkerTexture.idToTexture(id.method_48331("_accent")) : null, offsetX, offsetY, width, height, mipLevels, nearClip, farClip);
    }

    public static MarkerTexture centered(class_2960 id, int width, int height, int mipLevels, int nearClip, int farClip, boolean accent) {
        return MarkerTexture.ofId(id, -width / 2, -height / 2, width, height, mipLevels, nearClip, farClip, accent);
    }

    public class_2960 keyId() {
        return class_2960.method_60655((String)this.id.method_12836(), (String)this.id.method_12832().substring("textures/atlas/marker/".length(), this.id.method_12832().length() - 4));
    }

    public String displayId() {
        return this.id.method_12836().equals("antique_atlas") ? this.keyId().method_12832() : this.keyId().toString();
    }

    public int fullTextureWidth() {
        int width = this.textureWidth;
        for (int i = 0; i < this.mipLevels; ++i) {
            width += this.textureWidth >> i + 1;
        }
        return width;
    }

    public int getU(int mipLevel) {
        int u = 0;
        for (int currentMipLevel = mipLevel - 1; currentMipLevel >= 0; --currentMipLevel) {
            u += this.textureWidth / (1 << currentMipLevel);
        }
        return u;
    }

    public Vector2d getCenter(int tileChunks) {
        int mipLevel = class_3532.method_15340((int)class_3532.method_15342((int)tileChunks), (int)0, (int)this.mipLevels);
        return new Vector2d(((double)this.offsetX + (double)this.textureWidth / 2.0) / (double)(1 << mipLevel), ((double)this.offsetY + (double)this.textureHeight / 2.0) / (double)(1 << mipLevel));
    }

    public double getSquaredSize(int tileChunks) {
        int mipLevel = class_3532.method_15340((int)class_3532.method_15342((int)tileChunks), (int)0, (int)this.mipLevels);
        return (double)(this.textureWidth * this.textureHeight) / (double)(1 << mipLevel);
    }

    public void drawIcon(class_332 context, int x, int y, float[] accent) {
        context.method_25290(this.id, x, y, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.fullTextureWidth(), this.textureHeight);
        if (this.accentId != null && accent != null) {
            RenderSystem.setShaderColor((float)accent[0], (float)accent[1], (float)accent[2], (float)1.0f);
            context.method_25290(this.accentId, x, y, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.fullTextureWidth(), this.textureHeight);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
    }

    public void draw(class_332 context, double markerX, double markerY, float markerScale, int tileChunks, float[] accent, float tint, float alpha) {
        context.method_51448().method_22903();
        context.method_51448().method_22904(markerX, markerY, 0.0);
        context.method_51448().method_22905(markerScale, markerScale, 1.0f);
        if (tileChunks > 1 && this.mipLevels > 0) {
            int mipLevel = class_3532.method_15340((int)class_3532.method_15342((int)tileChunks), (int)0, (int)this.mipLevels);
            context.method_25290(this.id, this.offsetX / (1 << mipLevel), this.offsetY / (1 << mipLevel), (float)this.getU(mipLevel), 0.0f, this.textureWidth / (1 << mipLevel), this.textureHeight / (1 << mipLevel), this.fullTextureWidth(), this.textureHeight);
            if (this.accentId != null && accent != null) {
                RenderSystem.setShaderColor((float)(tint * accent[0]), (float)(tint * accent[1]), (float)(tint * accent[2]), (float)alpha);
                context.method_25290(this.accentId, this.offsetX / (1 << mipLevel), this.offsetY / (1 << mipLevel), (float)this.getU(mipLevel), 0.0f, this.textureWidth / (1 << mipLevel), this.textureHeight / (1 << mipLevel), this.fullTextureWidth(), this.textureHeight);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        } else {
            context.method_25290(this.id, this.offsetX, this.offsetY, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.fullTextureWidth(), this.textureHeight);
            if (this.accentId != null && accent != null) {
                RenderSystem.setShaderColor((float)(tint * accent[0]), (float)(tint * accent[1]), (float)(tint * accent[2]), (float)alpha);
                context.method_25290(this.accentId, this.offsetX, this.offsetY, 0.0f, 0.0f, this.textureWidth, this.textureHeight, this.fullTextureWidth(), this.textureHeight);
                RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
        context.method_51448().method_22909();
    }
}

