/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.TileTexture;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2960;
import net.minecraft.class_3341;
import net.minecraft.class_3532;
import net.minecraft.class_3780;

public record StructureTileProvider(class_2960 id, int priority, Map<ChunkMatcher, List<TileTexture>> matchers) {
    public static final BiMap<class_2960, ChunkMatcher> CHUNK_MATCHERS = HashBiMap.create();

    public StructureTileProvider(class_2960 id, int priority, List<TileTexture> textures) {
        this(id, priority, Map.of(ChunkMatcher::center, textures));
    }

    public StructureTileProvider(class_2960 id, int priority, ChunkMatcher matcher, List<TileTexture> textures) {
        this(id, priority, Map.of(matcher, textures));
    }

    public static ChunkMatcher getChunkMatcher(class_2960 id) {
        return (ChunkMatcher)CHUNK_MATCHERS.get((Object)id);
    }

    private Map<class_1923, TileTexture> getTextures(Function<ChunkMatcher, Collection<class_1923>> matcherFunction, Map<class_1923, String> tilePredicates) {
        HashMap<class_1923, TileTexture> outMap = new HashMap<class_1923, TileTexture>();
        this.matchers.forEach((matcher, textures) -> {
            for (class_1923 pos : (Collection)matcherFunction.apply((ChunkMatcher)matcher)) {
                tilePredicates.put(pos, Objects.toString(CHUNK_MATCHERS.inverse().get(matcher), null));
                int variation = (int)(class_3532.method_15371((int)pos.field_9181, (int)pos.field_9180, (int)(pos.field_9181 * pos.field_9180)) & Integer.MAX_VALUE);
                outMap.put(pos, (TileTexture)textures.get(variation % textures.size()));
            }
        });
        return outMap;
    }

    public Map<class_1923, TileTexture> getTextures(class_1937 world, class_3341 box, Map<class_1923, String> tilePredicates) {
        return this.getTextures(matcher -> matcher.matches(world, box), tilePredicates);
    }

    public Map<class_1923, TileTexture> getTextures(class_1937 world, class_3341 box, List<class_3780> junctions, Map<class_1923, String> tilePredicates) {
        return this.getTextures(matcher -> matcher.matches(world, box, junctions), tilePredicates);
    }

    public Set<TileTexture> allTextures() {
        HashSet<TileTexture> outSet = new HashSet<TileTexture>();
        this.matchers.values().forEach(outSet::addAll);
        return outSet;
    }

    static {
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("center"), ChunkMatcher::center);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("center_above_ground"), ChunkMatcher::aboveGround);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("center_top_above_ground"), ChunkMatcher::topAboveGround);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("center_horizontal"), ChunkMatcher::centerIfHorizontal);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("center_vertical"), ChunkMatcher::centerIfVertical);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("bridge_horizontal"), ChunkMatcher::bridgeHorizontal);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("bridge_vertical"), ChunkMatcher::bridgeVertical);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("path_straight_horizontal"), ChunkJunctionMatcher::straightHorizontal);
        CHUNK_MATCHERS.put((Object)AntiqueAtlas.id("path_straight_vertical"), ChunkJunctionMatcher::straightVertical);
    }

    public static interface ChunkMatcher {
        public Collection<class_1923> matches(class_1937 var1, class_3341 var2);

        default public Collection<class_1923> matches(class_1937 world, class_3341 box, List<class_3780> junctions) {
            return this.matches(world, box);
        }

        public static Collection<class_1923> center(class_1937 world, class_3341 box) {
            return Collections.singleton(new class_1923(box.method_22874()));
        }

        public static Collection<class_1923> topAboveGround(class_1937 world, class_3341 box) {
            if (world.method_8615() <= box.method_35419()) {
                return Collections.singleton(new class_1923(box.method_22874()));
            }
            return Collections.emptyList();
        }

        public static Collection<class_1923> aboveGround(class_1937 world, class_3341 box) {
            class_2338 center = new class_2338((class_2382)box.method_22874());
            if (world.method_8615() - 4 <= center.method_10264()) {
                return Collections.singleton(new class_1923(center));
            }
            return Collections.emptyList();
        }

        public static Collection<class_1923> bridgeHorizontal(class_1937 world, class_3341 box) {
            HashSet<class_1923> matches = new HashSet<class_1923>();
            if (box.method_35414() > 16) {
                int chunkZ = box.method_22874().method_10260() >> 4;
                for (int x = box.method_35415(); x < box.method_35418(); x += 16) {
                    matches.add(new class_1923(x >> 4, chunkZ));
                }
            }
            return matches;
        }

        public static Collection<class_1923> bridgeVertical(class_1937 world, class_3341 box) {
            HashSet<class_1923> matches = new HashSet<class_1923>();
            if (box.method_14663() > 16) {
                int chunkX = box.method_22874().method_10263() >> 4;
                for (int z = box.method_35417(); z < box.method_35420(); z += 16) {
                    matches.add(new class_1923(chunkX, z >> 4));
                }
            }
            return matches;
        }

        public static Collection<class_1923> centerIfHorizontal(class_1937 world, class_3341 box) {
            if (box.method_35414() > box.method_14663()) {
                return Collections.singleton(new class_1923(box.method_22874()));
            }
            return Collections.emptySet();
        }

        public static Collection<class_1923> centerIfVertical(class_1937 world, class_3341 box) {
            if (box.method_14663() > box.method_35414()) {
                return Collections.singleton(new class_1923(box.method_22874()));
            }
            return Collections.emptySet();
        }
    }

    public static interface ChunkJunctionMatcher
    extends ChunkMatcher {
        @Override
        default public Collection<class_1923> matches(class_1937 world, class_3341 box) {
            return this.matches(world, box, List.of());
        }

        @Override
        public Collection<class_1923> matches(class_1937 var1, class_3341 var2, List<class_3780> var3);

        public static Collection<class_1923> straightHorizontal(class_1937 world, class_3341 box, List<class_3780> junctions) {
            if (junctions.size() == 2 && (junctions.get(0).method_16609() == junctions.get(1).method_16609() || junctions.get(0).method_16610() != junctions.get(1).method_16610())) {
                return List.of(new class_1923(box.method_22874()));
            }
            return List.of();
        }

        public static Collection<class_1923> straightVertical(class_1937 world, class_3341 box, List<class_3780> junctions) {
            if (junctions.size() == 2 && (junctions.get(0).method_16610() == junctions.get(1).method_16610() || junctions.get(0).method_16609() != junctions.get(1).method_16609())) {
                return List.of(new class_1923(new class_2338((junctions.get(0).method_16610() + junctions.get(1).method_16610()) / 2, 0, (junctions.get(0).method_16609() + junctions.get(1).method_16609()) / 2)));
            }
            return List.of();
        }
    }
}

