/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import folk.sisby.antique_atlas.FeatureTiles;
import folk.sisby.antique_atlas.TerrainTileProvider;
import folk.sisby.antique_atlas.TileElevation;
import folk.sisby.antique_atlas.reloader.BiomeTileProviders;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.WorldTerrainSummary;
import folk.sisby.surveyor.util.RegistryPalette;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.objects.Reference2BooleanArrayMap;
import it.unimi.dsi.fastutil.objects.Reference2IntArrayMap;
import java.util.List;
import java.util.Map;
import net.fabricmc.fabric.api.tag.convention.v1.ConventionalBiomeTags;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2359;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import org.jetbrains.annotations.Nullable;

public class TerrainTiling {
    public static final int EMPTY_PRIORITY = 16;
    public static final int RAVINE_PRIORITY = 12;
    public static final int LAVA_PRIORITY = 6;
    public static final int WATER_PRIORITY = 4;
    public static final int ICE_PRIORITY = 3;
    public static final int BEACH_PRIORITY = 3;
    public static final List<class_2960> CUSTOM_TILES = List.of(FeatureTiles.BEDROCK_ROOF, FeatureTiles.EMPTY, FeatureTiles.END_VOID, FeatureTiles.WATER, FeatureTiles.ICE, FeatureTiles.TILE_RAVINE, FeatureTiles.SWAMP_WATER, FeatureTiles.TILE_LAVA, FeatureTiles.TILE_LAVA_SHORE);
    public static final int NETHER_SCAN_HEIGHT = 50;
    public static final Map<class_1959, Integer> priorityCache = new Reference2IntArrayMap();
    public static final Map<class_1959, Boolean> swampCache = new Reference2BooleanArrayMap();

    protected static int priorityForBiome(class_2378<class_1959> biomeRegistry, class_1959 biome) {
        return priorityCache.computeIfAbsent(biome, b -> {
            class_6880 biomeEntry = biomeRegistry.method_47983((Object)biome);
            if (biomeEntry.method_40220(class_6908.field_36510)) {
                return 3;
            }
            if (biomeEntry.method_40220(class_6908.field_36518)) {
                return 2;
            }
            return 1;
        });
    }

    protected static boolean isSwamp(class_2378<class_1959> biomeRegistry, class_1959 biome) {
        return swampCache.computeIfAbsent(biome, b -> biomeRegistry.method_47983(b).method_40220(ConventionalBiomeTags.SWAMP));
    }

    protected static Pair<TerrainTileProvider, TileElevation> frequencyToTexture(int[][] possibleTiles, class_2378<class_1959> biomeRegistry, class_2359<class_1959> biomePalette) {
        class_2960 providerId;
        int elevationOrdinal = -1;
        int biomeIndex = -1;
        int bestFrequency = 0;
        for (int i = 0; i < possibleTiles.length; ++i) {
            for (int j = 0; j < possibleTiles[i].length; ++j) {
                if (possibleTiles[i][j] <= bestFrequency) continue;
                elevationOrdinal = i;
                biomeIndex = j;
                bestFrequency = possibleTiles[i][j];
            }
        }
        if (bestFrequency == 0) {
            return null;
        }
        int customTileIndex = biomeIndex - possibleTiles[0].length + CUSTOM_TILES.size();
        class_2960 class_29602 = providerId = customTileIndex >= 0 ? CUSTOM_TILES.get(customTileIndex) : biomeRegistry.method_10221((Object)((class_1959)biomePalette.method_10200(biomeIndex)));
        if (providerId == null) {
            throw new RuntimeException(customTileIndex >= 0 ? "Custom tile index %s was out of bounds for size %s!".formatted(customTileIndex, CUSTOM_TILES.size()) : "Biome ID was null at index %s and instance %S!".formatted(biomeIndex, biomePalette.method_10200(biomeIndex)));
        }
        return Pair.of((Object)BiomeTileProviders.getInstance().getTileProvider(providerId), elevationOrdinal == TileElevation.values().length ? null : TileElevation.values()[elevationOrdinal]);
    }

    public static Pair<TerrainTileProvider, TileElevation> terrainToTile(class_1937 world, class_1923 pos) {
        int defaultTile = CUSTOM_TILES.indexOf(world.method_8597().comp_643() ? FeatureTiles.BEDROCK_ROOF : (world.method_27983() == class_1937.field_25181 ? FeatureTiles.END_VOID : FeatureTiles.EMPTY));
        boolean checkRavines = world.method_27983() == class_1937.field_25179;
        int worldHeight = world.method_31600();
        WorldTerrainSummary terrain = WorldSummary.of((class_1937)world).terrain();
        if (terrain == null) {
            return null;
        }
        ChunkSummary chunk = terrain.get(pos);
        if (chunk == null) {
            return null;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LayerSummary.Raw summary = chunk.toSingleLayer(null, null, world.method_31600());
        RegistryPalette.ValueView biomePalette = terrain.getBiomePalette(pos);
        RegistryPalette.ValueView blockPalette = terrain.getBlockPalette(pos);
        class_2378 biomeRegistry = biomePalette.registry();
        if (summary == null) {
            return Pair.of((Object)BiomeTileProviders.getInstance().getTileProvider(CUSTOM_TILES.get(defaultTile)), null);
        }
        int elevationSize = TileElevation.values().length;
        int elevationCount = elevationSize + 1;
        int biomeCount = biomePalette.method_10204();
        int baseTileCount = biomeCount + CUSTOM_TILES.size();
        int[][] possibleTiles = new int[elevationCount][baseTileCount];
        for (int i = 0; i < summary.depths().length; ++i) {
            if (!summary.exists().get(i)) {
                int[] nArray = possibleTiles[elevationSize];
                int n = defaultTile;
                nArray[n] = nArray[n] + 16;
                continue;
            }
            int height = worldHeight - summary.depths()[i] + summary.waterDepths()[i];
            class_2248 block = (class_2248)blockPalette.method_10200(summary.blocks()[i]);
            class_1959 biome = (class_1959)biomePalette.method_10200(summary.biomes()[i]);
            if (checkRavines && height - world.method_8615() < -7) {
                int[] nArray = possibleTiles[elevationSize];
                int n = biomeCount + CUSTOM_TILES.indexOf(FeatureTiles.TILE_RAVINE);
                nArray[n] = nArray[n] + 12;
            } else if (summary.waterDepths()[i] > 0) {
                int[] nArray = possibleTiles[elevationSize];
                int n = biomeCount + CUSTOM_TILES.indexOf(TerrainTiling.isSwamp((class_2378<class_1959>)biomeRegistry, biome) ? FeatureTiles.SWAMP_WATER : FeatureTiles.WATER);
                nArray[n] = nArray[n] + 4;
            } else if (block == class_2246.field_10295) {
                int[] nArray = possibleTiles[elevationSize];
                int n = biomeCount + CUSTOM_TILES.indexOf(FeatureTiles.ICE);
                nArray[n] = nArray[n] + 3;
            } else if (block == class_2246.field_10164) {
                int[] nArray = possibleTiles[elevationSize];
                int n = biomeCount + CUSTOM_TILES.indexOf(FeatureTiles.TILE_LAVA);
                nArray[n] = nArray[n] + 6;
            }
            int[] nArray = possibleTiles[TileElevation.fromBlocksAboveSea(height - world.method_8615()).ordinal()];
            int n = summary.biomes()[i];
            nArray[n] = nArray[n] + TerrainTiling.priorityForBiome((class_2378<class_1959>)biomeRegistry, biome);
        }
        return TerrainTiling.frequencyToTexture(possibleTiles, (class_2378<class_1959>)biomeRegistry, (class_2359<class_1959>)biomePalette);
    }

    public static Pair<TerrainTileProvider, TileElevation> terrainToTileNether(class_1937 world, class_1923 pos) {
        int defaultTile = CUSTOM_TILES.indexOf(world.method_8597().comp_643() ? FeatureTiles.BEDROCK_ROOF : (world.method_27983() == class_1937.field_25181 ? FeatureTiles.END_VOID : FeatureTiles.EMPTY));
        WorldTerrainSummary terrain = WorldSummary.of((class_1937)world).terrain();
        if (terrain == null) {
            return null;
        }
        ChunkSummary chunk = terrain.get(pos);
        if (chunk == null) {
            return null;
        }
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LayerSummary.Raw lowSummary = chunk.toSingleLayer(null, Integer.valueOf(50), world.method_31600());
        // Could not load outer class - annotation placement on inner may be incorrect
         @Nullable LayerSummary.Raw fullSummary = chunk.toSingleLayer(null, Integer.valueOf(world.method_31607() + world.method_8597().comp_653() - 1), world.method_31600());
        RegistryPalette.ValueView biomePalette = terrain.getBiomePalette(pos);
        RegistryPalette.ValueView blockPalette = terrain.getBlockPalette(pos);
        class_2378 biomeRegistry = biomePalette.registry();
        int elevationSize = TileElevation.values().length;
        int elevationCount = elevationSize + 1;
        int biomeCount = biomePalette.method_10204();
        int baseTileCount = biomeCount + CUSTOM_TILES.size();
        int[][] possibleTiles = new int[elevationCount][baseTileCount];
        if (fullSummary == null) {
            return Pair.of((Object)BiomeTileProviders.getInstance().getTileProvider(CUSTOM_TILES.get(defaultTile)), null);
        }
        int SEA_DEPTH = world.method_31600() - 31;
        if (lowSummary == null) {
            for (int i = 0; i < fullSummary.depths().length; ++i) {
                if (!fullSummary.exists().get(i)) {
                    int[] nArray = possibleTiles[elevationSize];
                    int n = defaultTile;
                    nArray[n] = nArray[n] + 16;
                    continue;
                }
                class_1959 biome = (class_1959)biomePalette.method_10200(fullSummary.biomes()[i]);
                int[] nArray = possibleTiles[elevationSize];
                int n = fullSummary.biomes()[i];
                nArray[n] = nArray[n] + TerrainTiling.priorityForBiome((class_2378<class_1959>)biomeRegistry, biome);
            }
        } else {
            for (int i = 0; i < lowSummary.depths().length; ++i) {
                if (!lowSummary.exists().get(i) || lowSummary.depths()[i] > SEA_DEPTH) {
                    class_1959 biome = (class_1959)biomePalette.method_10200(fullSummary.biomes()[i]);
                    int[] nArray = possibleTiles[elevationSize];
                    int n = fullSummary.biomes()[i];
                    nArray[n] = nArray[n] + TerrainTiling.priorityForBiome((class_2378<class_1959>)biomeRegistry, biome);
                    continue;
                }
                class_2248 block = (class_2248)blockPalette.method_10200(lowSummary.blocks()[i]);
                if (block == class_2246.field_10164) {
                    int[] nArray = possibleTiles[elevationSize];
                    int n = biomeCount + CUSTOM_TILES.indexOf(FeatureTiles.TILE_LAVA);
                    nArray[n] = nArray[n] + 6;
                    continue;
                }
                int[] nArray = possibleTiles[elevationSize];
                int n = biomeCount + CUSTOM_TILES.indexOf(FeatureTiles.TILE_LAVA_SHORE);
                nArray[n] = nArray[n] + 3;
            }
        }
        return TerrainTiling.frequencyToTexture(possibleTiles, (class_2378<class_1959>)biomeRegistry, (class_2359<class_1959>)biomePalette);
    }
}

