/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas;

import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.AntiqueAtlasConfig;
import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_2960;

public final class TileTexture {
    public static final TileTexture DEFAULT = TileTexture.empty(AntiqueAtlas.id(AntiqueAtlas.CONFIG.fallbackFailHandling == AntiqueAtlasConfig.FallbackHandling.TEST ? "test" : "missing"), false);
    private final class_2960 id;
    private final boolean innerBorder;
    private final Set<TileTexture> tilesTo;
    private final Set<TileTexture> tilesToHorizontal;
    private final Set<TileTexture> tilesToVertical;

    public static TileTexture empty(class_2960 id, boolean innerBorder) {
        return new TileTexture(class_2960.method_60655((String)id.method_12836(), (String)"textures/atlas/tile/%s.png".formatted(id.method_12832())), innerBorder, (Set<TileTexture>)new ReferenceOpenHashSet(), (Set<TileTexture>)new ReferenceOpenHashSet(), (Set<TileTexture>)new ReferenceOpenHashSet());
    }

    public TileTexture(class_2960 id, boolean innerBorder, Set<TileTexture> tilesTo, Set<TileTexture> tilesToHorizontal, Set<TileTexture> tilesToVertical) {
        this.id = id;
        this.innerBorder = innerBorder;
        this.tilesTo = tilesTo;
        this.tilesToHorizontal = tilesToHorizontal;
        this.tilesToVertical = tilesToVertical;
    }

    public String displayId() {
        String trimmedPath = this.id.method_12832().substring("textures/atlas/tile/".length(), this.id.method_12832().length() - 4);
        return this.id.method_12836().equals("antique_atlas") ? trimmedPath : class_2960.method_60655((String)this.id.method_12836(), (String)trimmedPath).toString();
    }

    public boolean tiles(TileTexture other) {
        return this == other || this.innerBorder ^ (this.tilesTo.contains(other) || this.tilesToHorizontal.contains(other) || this.tilesToVertical.contains(other));
    }

    public boolean tilesHorizontally(TileTexture other) {
        return this == other || this.innerBorder ^ (this.tilesTo.contains(other) || this.tilesToHorizontal.contains(other));
    }

    public boolean tilesVertically(TileTexture other) {
        return this == other || this.innerBorder ^ (this.tilesTo.contains(other) || this.tilesToVertical.contains(other));
    }

    public class_2960 id() {
        return this.id;
    }

    public record Builder(class_2960 id, boolean innerBorder, Set<class_2960> tilesTo, Set<class_2960> tilesToHorizontal, Set<class_2960> tilesToVertical) {
        public TileTexture build(Map<class_2960, TileTexture> emptyTextures) {
            TileTexture emptyTexture = emptyTextures.get(this.id);
            if (!this.tilesTo.isEmpty()) {
                emptyTexture.tilesTo.addAll(this.tilesTo.stream().map(emptyTextures::get).collect(Collectors.toSet()));
            }
            if (!this.tilesToHorizontal.isEmpty()) {
                emptyTexture.tilesToHorizontal.addAll(this.tilesToHorizontal.stream().map(emptyTextures::get).collect(Collectors.toSet()));
            }
            if (!this.tilesToVertical.isEmpty()) {
                emptyTexture.tilesToVertical.addAll(this.tilesToVertical.stream().map(emptyTextures::get).collect(Collectors.toSet()));
            }
            return emptyTexture;
        }
    }
}

