/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.gui;

import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.gui.AtlasScreen;
import folk.sisby.antique_atlas.gui.BookmarkButton;
import folk.sisby.antique_atlas.gui.MarkerPreviewButton;
import folk.sisby.antique_atlas.gui.TexturePreviewButton;
import folk.sisby.antique_atlas.gui.core.Component;
import folk.sisby.antique_atlas.gui.core.ScrollBoxComponent;
import folk.sisby.antique_atlas.gui.core.ToggleButtonRadioGroup;
import folk.sisby.antique_atlas.reloader.MarkerTextures;
import folk.sisby.antique_atlas.util.ColorUtil;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_746;

public class MarkerModal
extends Component {
    private class_1937 world;
    private int markerX;
    private int markerZ;
    MarkerTexture selectedTexture = MarkerTexture.DEFAULT;
    class_1767 selectedColor = class_1767.field_7952;
    private static final int BUTTON_WIDTH = 80;
    private static final int BUTTON_SPACING = 8;
    private static final int TYPE_SPACING = 1;
    private class_4185 btnDone;
    private class_4185 btnCancel;
    private class_342 textField;
    private ScrollBoxComponent textureScrollBox;
    private ToggleButtonRadioGroup<TexturePreviewButton<MarkerTexture>> textureRadioGroup;
    private ScrollBoxComponent colorScrollBox;
    private ToggleButtonRadioGroup<TexturePreviewButton<class_1767>> colorRadioGroup;
    private final List<IMarkerTypeSelectListener> markerListeners = new ArrayList<IMarkerTypeSelectListener>();

    MarkerModal() {
    }

    void setMarkerData(class_1937 world, int markerX, int markerZ) {
        this.world = world;
        this.markerX = markerX;
        this.markerZ = markerZ;
    }

    void addMarkerListener(IMarkerTypeSelectListener listener) {
        this.markerListeners.add(listener);
    }

    @Override
    public void method_25426() {
        super.method_25426();
        this.btnDone = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.done"), button -> {
            ((AtlasScreen)class_310.method_1551().field_1755).getworldAtlasData().placeCustomMarker(this.world, this.selectedTexture, this.selectedColor, class_2561.method_43470((String)this.textField.method_1882()), new class_2338(this.markerX, 0, this.markerZ));
            ((AtlasScreen)class_310.method_1551().field_1755).updateBookmarkerList();
            class_746 player = class_310.method_1551().field_1724;
            this.world.method_8396((class_1657)player, player.method_24515(), class_3417.field_20671, class_3419.field_15256, 1.0f, 1.0f);
            this.closeChild();
        }).method_46434(this.field_22789 / 2 - 80 - 4, this.field_22790 / 2 + 70, 80, 20).method_46431();
        this.method_37063((class_364)this.btnDone);
        this.btnCancel = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.cancel"), button -> this.closeChild()).method_46434(this.field_22789 / 2 + 4, this.field_22790 / 2 + 70, 80, 20).method_46431();
        this.method_37063((class_364)this.btnCancel);
        this.textField = new class_342(class_310.method_1551().field_1772, (this.field_22789 - 200) / 2, this.field_22790 / 2 - 65, 200, 20, (class_2561)class_2561.method_43471((String)"gui.antique_atlas.marker.label"));
        this.textField.method_1888(true);
        this.textField.method_1856(true);
        this.textField.method_25365(true);
        this.textField.method_47404((class_2561)class_2561.method_43471((String)"gui.antique_atlas.marker.label"));
        this.textureScrollBox = new ScrollBoxComponent(false, 35);
        this.addChild(this.textureScrollBox);
        int typeCount = (int)MarkerTextures.getInstance().asMap().values().stream().filter(t -> t.keyId().method_12832().startsWith("custom/")).count();
        int typesOnScreen = Math.min(typeCount, 7);
        int typeScrollWidth = typesOnScreen * 35 - 1;
        this.textureScrollBox.getViewport().setSize(typeScrollWidth, 35);
        this.textureScrollBox.setGuiCoords((this.field_22789 - typeScrollWidth) / 2, this.field_22790 / 2 - 35);
        this.textureRadioGroup = new ToggleButtonRadioGroup();
        this.textureRadioGroup.addListener(button -> {
            this.selectedTexture = (MarkerTexture)button.getValue();
            for (IMarkerTypeSelectListener listener : this.markerListeners) {
                listener.onSelectMarkerType((MarkerTexture)button.getValue());
            }
        });
        int contentX = 0;
        for (MarkerTexture texture : MarkerTextures.getInstance().asMap().values()) {
            if (!texture.keyId().method_12832().startsWith("custom/")) continue;
            if (this.selectedTexture == MarkerTexture.DEFAULT) {
                this.selectedTexture = texture;
            }
            MarkerPreviewButton markerGui = new MarkerPreviewButton(texture, ColorUtil.getColorFromArgb(this.selectedColor.method_7787()));
            this.textureRadioGroup.addButton(markerGui);
            if (this.selectedTexture.equals(texture)) {
                this.textureRadioGroup.setSelectedButton(markerGui);
            }
            this.textureScrollBox.getViewport().addContent(markerGui).setRelativeX(contentX);
            contentX += 35;
        }
        this.colorScrollBox = new ScrollBoxComponent(false, 35);
        this.addChild(this.colorScrollBox);
        int colorsOnScreen = Math.min(class_1767.values().length, 7);
        int colorScrollWidth = colorsOnScreen * 35 - 1;
        this.colorScrollBox.getViewport().setSize(colorScrollWidth, 35);
        this.colorScrollBox.setGuiCoords((this.field_22789 - colorScrollWidth) / 2, this.field_22790 / 2 + 10);
        this.colorRadioGroup = new ToggleButtonRadioGroup();
        this.colorRadioGroup.addListener(button -> {
            this.selectedColor = (class_1767)button.getValue();
            for (TexturePreviewButton<MarkerTexture> preview : this.textureRadioGroup) {
                preview.reTint(ColorUtil.getColorFromArgb(this.selectedColor.method_7787()));
            }
        });
        int colorContentX = 0;
        for (class_1767 color : class_1767.values()) {
            TexturePreviewButton<class_1767> colorGui = new TexturePreviewButton<class_1767>(color, BookmarkButton.TEXTURE_LEFT, 24, 18, 18, ColorUtil.getColorFromArgb(color.method_7787()));
            this.colorRadioGroup.addButton(colorGui);
            if (this.selectedColor.equals((Object)color)) {
                this.colorRadioGroup.setSelectedButton(colorGui);
            }
            this.colorScrollBox.getViewport().addContent(colorGui).setRelativeX(colorContentX);
            colorContentX += 35;
        }
    }

    @Override
    public void closeChild() {
        super.closeChild();
        if (this.textureScrollBox != null) {
            this.textureScrollBox.closeChild();
        }
        if (this.colorScrollBox != null) {
            this.colorScrollBox.closeChild();
        }
    }

    @Override
    public boolean method_25402(double mouseX, double mouseY, int button) {
        return super.method_25402(mouseX, mouseY, button) || this.textField.method_25402(mouseX, mouseY, button);
    }

    @Override
    public boolean method_25404(int aa, int bb, int cc) {
        return super.method_25404(aa, bb, cc) || this.textField.method_25404(aa, bb, cc);
    }

    @Override
    public boolean method_25400(char aa, int bb) {
        return super.method_25400(aa, bb) || this.textField.method_25400(aa, bb);
    }

    @Override
    public void method_25394(class_332 context, int mouseX, int mouseY, float partialTick) {
        this.method_25420(context, mouseX, mouseY, partialTick);
        this.drawCentered(context, (class_2561)class_2561.method_43471((String)"gui.antique_atlas.marker.label"), this.field_22790 / 2 - 80, 0xDDDDDD, true);
        this.btnCancel.method_25394(context, mouseX, mouseY, partialTick);
        this.btnDone.method_25394(context, mouseX, mouseY, partialTick);
        this.textField.method_25394(context, mouseX, mouseY, partialTick);
        context.method_25296(this.textureScrollBox.getGuiX() + 1, this.textureScrollBox.getGuiY() + 1, this.textureScrollBox.getGuiX() + this.textureScrollBox.getWidth(), this.textureScrollBox.getGuiY() + this.textureScrollBox.getHeight(), -2012213232, -1727000560);
        context.method_25296(this.colorScrollBox.getGuiX() + 1, this.colorScrollBox.getGuiY() + 1, this.colorScrollBox.getGuiX() + this.colorScrollBox.getWidth(), this.colorScrollBox.getGuiY() + this.colorScrollBox.getHeight(), -2012213232, -1727000560);
        super.method_25394(context, mouseX, mouseY, partialTick);
    }

    static interface IMarkerTypeSelectListener {
        public void onSelectMarkerType(MarkerTexture var1);
    }
}

