/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.reloader;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.MarkerTexture;
import folk.sisby.antique_atlas.util.CodecUtil;
import folk.sisby.surveyor.landmark.LandmarkType;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7368;

public class MarkerTextures
extends class_4080<Map<class_2960, MarkerTextureMeta>>
implements IdentifiableResourceReloadListener {
    private static final MarkerTextures INSTANCE = new MarkerTextures();
    public static final class_2960 ID = AntiqueAtlas.id("marker_textures");
    private final Map<class_2960, MarkerTexture> textures = new HashMap<class_2960, MarkerTexture>();

    public static MarkerTextures getInstance() {
        return INSTANCE;
    }

    public MarkerTexture get(class_2960 id) {
        return this.textures.get(id);
    }

    public MarkerTexture getOrDefault(class_2960 id) {
        return this.getOrDefault(id, MarkerTexture.DEFAULT);
    }

    public MarkerTexture getOrDefault(class_2960 id, MarkerTexture defaultTexture) {
        return this.textures.getOrDefault(id, defaultTexture);
    }

    public MarkerTexture getLandmarkType(LandmarkType<?> type) {
        return this.getOrDefault(class_2960.method_60655((String)type.id().method_12836(), (String)("landmark/type/" + type.id().method_12832())));
    }

    public MarkerTexture getLandmarkType(LandmarkType<?> type, String variant) {
        return this.getOrDefault(class_2960.method_60655((String)type.id().method_12836(), (String)("landmark/type/" + type.id().method_12832() + (String)(variant == null ? "" : "/" + variant))));
    }

    public Map<class_2960, MarkerTexture> asMap() {
        return new HashMap<class_2960, MarkerTexture>(this.textures);
    }

    protected Map<class_2960, MarkerTextureMeta> prepare(class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, MarkerTextureMeta> textureMeta = new HashMap<class_2960, MarkerTextureMeta>();
        for (Map.Entry e : manager.method_14488("textures/atlas/marker", id -> id.method_12832().endsWith(".png")).entrySet()) {
            class_2960 id2 = class_2960.method_60655((String)((class_2960)e.getKey()).method_12836(), (String)((class_2960)e.getKey()).method_12832().substring("textures/atlas/marker/".length(), ((class_2960)e.getKey()).method_12832().length() - ".png".length()));
            try {
                class_7368 metadata = ((class_3298)e.getValue()).method_14481();
                textureMeta.put(id2, metadata.method_43041(MarkerTextureMeta.METADATA).orElse(MarkerTextureMeta.DEFAULT));
            }
            catch (IOException ex) {
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Failed to access marker texture metadata for {}", e.getKey(), (Object)ex);
                textureMeta.put(id2, MarkerTextureMeta.DEFAULT);
            }
        }
        return textureMeta;
    }

    protected void apply(Map<class_2960, MarkerTextureMeta> prepared, class_3300 manager, class_3695 profiler) {
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Reloading Marker Textures...");
        this.textures.clear();
        prepared.forEach((id, meta) -> {
            if (id.method_12832().endsWith("_accent")) {
                class_2960 mainId = id.method_45134(s -> s.substring(0, s.length() - "_accent".length()));
                MarkerTextureMeta main = (MarkerTextureMeta)prepared.get(mainId);
                if (main != null) {
                    this.textures.put(mainId, main.build(mainId, true));
                } else {
                    AntiqueAtlas.LOGGER.error("[Antique Atlas] Marker accent {} has no main texture! Discarding.", id);
                }
            }
        });
        prepared.forEach((id, meta) -> {
            if (!this.textures.containsKey(id) && !id.method_12832().endsWith("_accent")) {
                this.textures.put((class_2960)id, meta.build((class_2960)id, false));
            }
        });
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public record MarkerTextureMeta(Optional<Integer> textureWidth, Optional<Integer> textureHeight, Optional<Integer> mipLevels, Optional<Integer> offsetX, Optional<Integer> offsetY, Optional<Integer> nearClip, Optional<Integer> farClip) {
        public static final MarkerTextureMeta DEFAULT = new MarkerTextureMeta(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
        public static final Codec<MarkerTextureMeta> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.INT.optionalFieldOf("textureWidth").forGetter(MarkerTextureMeta::textureWidth), (App)Codec.INT.optionalFieldOf("textureHeight").forGetter(MarkerTextureMeta::textureHeight), (App)Codec.INT.optionalFieldOf("mipLevels").forGetter(MarkerTextureMeta::mipLevels), (App)Codec.INT.optionalFieldOf("offsetX").forGetter(MarkerTextureMeta::offsetX), (App)Codec.INT.optionalFieldOf("offsetY").forGetter(MarkerTextureMeta::offsetY), (App)Codec.INT.optionalFieldOf("nearClip").forGetter(MarkerTextureMeta::nearClip), (App)Codec.INT.optionalFieldOf("farClip").forGetter(MarkerTextureMeta::farClip)).apply((Applicative)instance, MarkerTextureMeta::new));
        public static final class_3270<MarkerTextureMeta> METADATA = new CodecUtil.CodecResourceMetadataSerializer<MarkerTextureMeta>(CODEC, AntiqueAtlas.id("marker"));

        public MarkerTexture build(class_2960 id, boolean accent) {
            int textureWidth = this.textureWidth.orElse(32);
            int textureHeight = this.textureHeight.orElse(32);
            int mipLevels = this.mipLevels.orElse(0);
            int offsetX = this.offsetX.orElse(-textureWidth / 2);
            int offsetY = this.offsetY.orElse(-textureHeight / 2);
            int nearClip = this.nearClip.orElse(1);
            int farClip = this.farClip.orElse(Integer.MAX_VALUE);
            return MarkerTexture.ofId(id, offsetX, offsetY, textureWidth, textureHeight, mipLevels, nearClip, farClip, accent);
        }
    }
}

