/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.reloader;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import folk.sisby.antique_atlas.AntiqueAtlas;
import folk.sisby.antique_atlas.TileTexture;
import folk.sisby.antique_atlas.util.CodecUtil;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_5699;
import net.minecraft.class_7368;

public class TileTextures
extends class_4080<Map<class_2960, TileTextureMeta>>
implements IdentifiableResourceReloadListener {
    private static final TileTextures INSTANCE = new TileTextures();
    public static final class_2960 ID = AntiqueAtlas.id("tile_textures");
    private final Map<class_2960, TileTexture> textures = new HashMap<class_2960, TileTexture>();

    public static TileTextures getInstance() {
        return INSTANCE;
    }

    public Map<class_2960, TileTexture> getTextures() {
        return this.textures;
    }

    protected Map<class_2960, TileTextureMeta> prepare(class_3300 manager, class_3695 profiler) {
        HashMap<class_2960, TileTextureMeta> textureMeta = new HashMap<class_2960, TileTextureMeta>();
        for (Map.Entry e : manager.method_14488("textures/atlas/tile", id -> id.method_12832().endsWith(".png")).entrySet()) {
            class_2960 id2 = class_2960.method_60655((String)((class_2960)e.getKey()).method_12836(), (String)((class_2960)e.getKey()).method_12832().substring("textures/atlas/tile/".length(), ((class_2960)e.getKey()).method_12832().length() - ".png".length()));
            try {
                class_7368 metadata = ((class_3298)e.getValue()).method_14481();
                metadata.method_43041(TileTextureMeta.METADATA).ifPresentOrElse(meta -> textureMeta.put(id2, (TileTextureMeta)meta), () -> {
                    AntiqueAtlas.LOGGER.info("[Antique Atlas] Metadata not present for {} - using defaults.", e.getKey());
                    textureMeta.put(id2, TileTextureMeta.DEFAULT);
                });
            }
            catch (IOException ex) {
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Failed to access tile texture metadata for {}", e.getKey(), (Object)ex);
                textureMeta.put(id2, TileTextureMeta.DEFAULT);
            }
        }
        return textureMeta;
    }

    protected void apply(Map<class_2960, TileTextureMeta> prepared, class_3300 manager, class_3695 profiler) {
        AntiqueAtlas.LOGGER.info("[Antique Atlas] Reloading Tile Textures...");
        prepared.forEach((id, meta) -> meta.warnMissing((class_2960)id, prepared.keySet()));
        HashMap invalidParents = new HashMap();
        prepared.forEach((id, meta) -> {
            if (meta.parent.isPresent() && !prepared.containsKey(meta.parent.orElseThrow())) {
                invalidParents.put(id, meta.parent.orElseThrow());
                AntiqueAtlas.LOGGER.error("[Antique Atlas] Failed to reload a tile texture! {} had invalid parent {}", id, meta.parent);
            }
        });
        invalidParents.keySet().forEach(prepared::remove);
        prepared.forEach((id, meta) -> {
            Optional<TileTextureMeta> parent = meta.parent.map(prepared::get);
            while (parent.isPresent()) {
                meta.inheritFromAncestor(parent.orElseThrow());
                parent = parent.orElseThrow().parent.map(prepared::get);
            }
        });
        HashMap textureTags = new HashMap();
        prepared.forEach((id, meta) -> meta.tags.forEach(tag -> textureTags.computeIfAbsent(tag, t -> new HashSet()).add(id)));
        prepared.forEach((id, meta) -> meta.substituteTags((class_2960)id, textureTags));
        prepared.forEach((id, meta) -> meta.applyTilesToThis((class_2960)id, prepared));
        HashMap<class_2960, TileTexture.Builder> textureBuilders = new HashMap<class_2960, TileTexture.Builder>();
        prepared.forEach((id, meta) -> textureBuilders.put((class_2960)id, meta.toBuilder((class_2960)id)));
        this.textures.clear();
        textureBuilders.forEach((id, builder) -> this.textures.put((class_2960)id, TileTexture.empty(id, builder.innerBorder())));
        textureBuilders.forEach((id, builder) -> builder.build(this.textures));
    }

    public class_2960 getFabricId() {
        return ID;
    }

    public static final class TileTextureMeta {
        public static final TileTextureMeta DEFAULT = new TileTextureMeta(Optional.empty(), Optional.empty(), Set.of(), Set.of(), Set.of(), Set.of(), Set.of(), Set.of(), Set.of());
        public static final Codec<TileTextureMeta> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.optionalFieldOf("parent").forGetter(TileTextureMeta::parent), (App)CodecUtil.ofEnum(BorderType.class).optionalFieldOf("borderType").forGetter(TileTextureMeta::borderType), (App)CodecUtil.set(class_2960.field_25139).fieldOf("tags").orElseGet(HashSet::new).forGetter(TileTextureMeta::tags), (App)CodecUtil.set(class_5699.field_39274).fieldOf("tilesTo").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesTo), (App)CodecUtil.set(class_5699.field_39274).fieldOf("tilesToHorizontal").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesToHorizontal), (App)CodecUtil.set(class_5699.field_39274).fieldOf("tilesToVertical").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesToVertical), (App)CodecUtil.set(class_5699.field_39274).fieldOf("tilesToThis").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesToThis), (App)CodecUtil.set(class_5699.field_39274).fieldOf("tilesToThisHorizontal").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesToThisHorizontal), (App)CodecUtil.set(class_5699.field_39274).fieldOf("tilesToThisVertical").orElseGet(HashSet::new).forGetter(TileTextureMeta::tilesToThisVertical)).apply((Applicative)instance, TileTextureMeta::new));
        public static final class_3270<TileTextureMeta> METADATA = new CodecUtil.CodecResourceMetadataSerializer<TileTextureMeta>(CODEC, AntiqueAtlas.id("tiling"));
        private final Optional<class_2960> parent;
        private Optional<BorderType> borderType;
        private final Set<class_2960> tags;
        private final Set<class_5699.class_7476> tilesTo;
        private final Set<class_5699.class_7476> tilesToHorizontal;
        private final Set<class_5699.class_7476> tilesToVertical;
        private final Set<class_5699.class_7476> tilesToThis;
        private final Set<class_5699.class_7476> tilesToThisHorizontal;
        private final Set<class_5699.class_7476> tilesToThisVertical;

        public TileTextureMeta(Optional<class_2960> parent, Optional<BorderType> borderType, Set<class_2960> tags, Set<class_5699.class_7476> tilesTo, Set<class_5699.class_7476> tilesToHorizontal, Set<class_5699.class_7476> tilesToVertical, Set<class_5699.class_7476> tilesToThis, Set<class_5699.class_7476> tilesToThisHorizontal, Set<class_5699.class_7476> tilesToThisVertical) {
            this.parent = parent;
            this.borderType = borderType;
            this.tags = tags;
            this.tilesTo = tilesTo;
            this.tilesToHorizontal = tilesToHorizontal;
            this.tilesToVertical = tilesToVertical;
            this.tilesToThis = tilesToThis;
            this.tilesToThisHorizontal = tilesToThisHorizontal;
            this.tilesToThisVertical = tilesToThisVertical;
        }

        public void warnMissing(class_2960 thisId, Set<class_2960> identifiers) {
            for (Set<class_5699.class_7476> entrySet : List.of(this.tilesTo, this.tilesToHorizontal, this.tilesToVertical, this.tilesToThis, this.tilesToThisHorizontal, this.tilesToThisVertical)) {
                for (class_5699.class_7476 entry : entrySet) {
                    if (entry.comp_814() || identifiers.contains(entry.comp_813())) continue;
                    AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} references texture {}, which is missing!", (Object)thisId, (Object)entry.comp_813());
                }
            }
        }

        void inheritFromAncestor(TileTextureMeta other) {
            if (other.borderType.isPresent()) {
                this.borderType = other.borderType;
            }
            this.tags.addAll(other.tags);
            this.tilesTo.addAll(other.tilesTo);
            this.tilesToHorizontal.addAll(other.tilesToHorizontal);
            this.tilesToVertical.addAll(other.tilesToVertical);
            this.tilesToThis.addAll(other.tilesToThis);
            this.tilesToThisHorizontal.addAll(other.tilesToThisHorizontal);
            this.tilesToThisVertical.addAll(other.tilesToThisVertical);
        }

        void substituteTags(class_2960 thisId, Map<class_2960, Set<class_2960>> tags) {
            for (Set<class_5699.class_7476> entrySet : List.of(this.tilesTo, this.tilesToHorizontal, this.tilesToVertical, this.tilesToThis, this.tilesToThisHorizontal, this.tilesToThisVertical)) {
                HashSet<class_5699.class_7476> entryTags = new HashSet<class_5699.class_7476>();
                for (class_5699.class_7476 entry : entrySet) {
                    if (!entry.comp_814()) continue;
                    entryTags.add(entry);
                }
                if (!entryTags.isEmpty()) {
                    entrySet.removeAll(entryTags);
                }
                for (class_5699.class_7476 entry : entryTags) {
                    Set resolvedIds = tags.getOrDefault(entry.comp_813(), Set.of());
                    if (resolvedIds.isEmpty()) {
                        AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} references tag {}, which is empty", (Object)thisId, (Object)entry.comp_813());
                        continue;
                    }
                    entrySet.addAll(resolvedIds.stream().map(id -> new class_5699.class_7476(id, false)).toList());
                }
            }
        }

        void applyTilesToThis(class_2960 thisId, Map<class_2960, TileTextureMeta> map) {
            for (class_5699.class_7476 entryId : this.tilesToThis) {
                if (entryId.comp_814()) {
                    throw new IllegalStateException("tags must be resolved to apply tilesToThis!");
                }
                if (map.containsKey(entryId.comp_813())) {
                    map.get((Object)entryId.comp_813()).tilesTo.add(new class_5699.class_7476(thisId, false));
                    continue;
                }
                AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} references texture {}, which is missing", (Object)thisId, (Object)entryId.comp_813());
            }
            for (class_5699.class_7476 entryId : this.tilesToThisHorizontal) {
                if (entryId.comp_814()) {
                    throw new IllegalStateException("tags must be resolved to apply tilesToThis!");
                }
                if (map.containsKey(entryId.comp_813())) {
                    map.get((Object)entryId.comp_813()).tilesToHorizontal.add(new class_5699.class_7476(thisId, false));
                    continue;
                }
                AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} references texture {}, which is missing", (Object)thisId, (Object)entryId.comp_813());
            }
            for (class_5699.class_7476 entryId : this.tilesToThisVertical) {
                if (entryId.comp_814()) {
                    throw new IllegalStateException("tags must be resolved to apply tilesToThis!");
                }
                if (map.containsKey(entryId.comp_813())) {
                    map.get((Object)entryId.comp_813()).tilesToVertical.add(new class_5699.class_7476(thisId, false));
                    continue;
                }
                AntiqueAtlas.LOGGER.warn("[Antique Atlas] Tile texture {} references texture {}, which is missing", (Object)thisId, (Object)entryId.comp_813());
            }
        }

        public TileTexture.Builder toBuilder(class_2960 thisId) {
            return new TileTexture.Builder(thisId, this.borderType.orElse(BorderType.OUTER) == BorderType.INNER, this.tilesTo.stream().map(class_5699.class_7476::comp_813).collect(Collectors.toSet()), this.tilesToHorizontal.stream().map(class_5699.class_7476::comp_813).collect(Collectors.toSet()), this.tilesToVertical.stream().map(class_5699.class_7476::comp_813).collect(Collectors.toSet()));
        }

        public Optional<class_2960> parent() {
            return this.parent;
        }

        public Optional<BorderType> borderType() {
            return this.borderType;
        }

        public Set<class_2960> tags() {
            return this.tags;
        }

        public Set<class_5699.class_7476> tilesTo() {
            return this.tilesTo;
        }

        public Set<class_5699.class_7476> tilesToHorizontal() {
            return this.tilesToHorizontal;
        }

        public Set<class_5699.class_7476> tilesToVertical() {
            return this.tilesToVertical;
        }

        public Set<class_5699.class_7476> tilesToThis() {
            return this.tilesToThis;
        }

        public Set<class_5699.class_7476> tilesToThisHorizontal() {
            return this.tilesToThisHorizontal;
        }

        public Set<class_5699.class_7476> tilesToThisVertical() {
            return this.tilesToThisVertical;
        }

        public static enum BorderType {
            OUTER,
            INNER;

        }
    }
}

