/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.antique_atlas.util;

import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import net.minecraft.class_2960;
import net.minecraft.class_3270;
import org.jetbrains.annotations.NotNull;

public class CodecUtil {
    public static <T> Codec<Set<T>> set(Codec<T> codec) {
        return codec.listOf().xmap(HashSet::new, ArrayList::new);
    }

    public static <T extends Enum<T>> Codec<T> ofEnum(Class<T> enumClass) {
        return Codec.STRING.flatXmap(id -> {
            try {
                return DataResult.success(Enum.valueOf(enumClass, id.toUpperCase(Locale.ROOT)));
            }
            catch (Exception e) {
                return DataResult.error(() -> "Unknown type: " + id);
            }
        }, value -> DataResult.success((Object)value.name()));
    }

    public record CodecResourceMetadataSerializer<T>(Codec<T> codec, class_2960 id) implements class_3270<T>
    {
        @NotNull
        public String method_14420() {
            return this.id.toString();
        }

        @NotNull
        public T method_14421(JsonObject json) {
            DataResult result = this.codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)json);
            if (result.error().isPresent()) {
                throw new IllegalStateException("Failed to parse " + String.valueOf(this.id) + " metadata section: " + String.valueOf(result.error().get()));
            }
            if (result.result().isEmpty()) {
                throw new IllegalStateException("Failed to parse " + String.valueOf(this.id) + " metadata section: Empty result");
            }
            return result.result().get();
        }
    }
}

