/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.misc;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Reference2IntMap;
import it.unimi.dsi.fastutil.objects.Reference2IntOpenHashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.misc.CodecMapRegistry;
import net.minecraft.class_2359;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_8703;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class MapRegistry<T>
implements class_2359<T>,
Codec<T> {
    private final class_9139<class_2540, T> streamCodec;
    private final String name;
    private final BiMap<class_2960, T> map = HashBiMap.create();
    private int nextId;
    private final Reference2IntMap<T> tToId;
    private final List<T> idToT;

    public MapRegistry(String name) {
        this.name = name;
        this.idToT = Lists.newArrayListWithExpectedSize((int)32);
        this.tToId = new Reference2IntOpenHashMap(32);
        this.tToId.defaultReturnValue(-1);
        this.streamCodec = new StreamC();
    }

    public static <B> CodecMapRegistry<B> ofCodec(String name) {
        return new CodecMapRegistry(name);
    }

    public static <B> CodecMapRegistry<B> ofCodec() {
        return new CodecMapRegistry("unnamed codec registry");
    }

    public <B extends T> T register(class_2960 name, B value) {
        if (this.map.containsKey((Object)name)) {
            throw new IllegalStateException("Cannot register duplicate value " + String.valueOf(name));
        }
        this.map.put((Object)name, value);
        this.addMapping(value);
        return value;
    }

    public <B extends T> T register(String name, B value) {
        this.register(class_2960.method_60654((String)name), value);
        return value;
    }

    protected void addMapping(T key) {
        int value = this.nextId;
        this.tToId.put(key, value);
        while (this.idToT.size() <= value) {
            this.idToT.add(null);
        }
        this.idToT.set(value, key);
        if (this.nextId <= value) {
            this.nextId = value + 1;
        }
    }

    @Nullable
    public T getValue(class_2960 name) {
        return (T)this.map.get((Object)name);
    }

    @Nullable
    public T getValue(String name) {
        return this.getValue(class_2960.method_60654((String)name));
    }

    @Nullable
    public class_2960 getKey(T value) {
        return (class_2960)this.map.inverse().get(value);
    }

    public Set<class_2960> keySet() {
        return this.map.keySet();
    }

    public Set<T> getValues() {
        return this.map.values();
    }

    public T getValueOrDefault(class_2960 parse, T defaultType) {
        return (T)this.map.getOrDefault((Object)parse, defaultType);
    }

    public Set<Map.Entry<class_2960, T>> getEntries() {
        return this.map.entrySet();
    }

    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    public int method_10204() {
        return this.map.size();
    }

    public boolean containsKey(class_2960 name) {
        return this.map.containsKey((Object)name);
    }

    public <U> DataResult<Pair<T, U>> decode(DynamicOps<U> ops, U json) {
        return class_2960.field_25139.decode(ops, json).flatMap(pair -> {
            class_2960 id = (class_2960)pair.getFirst();
            T value = this.getValue(id);
            return value == null ? DataResult.error(() -> "Could not find any entry with key '" + String.valueOf(id) + "' in registry [" + this.name + "] \n Known keys: " + String.valueOf(this.keySet())) : DataResult.success((Object)Pair.of(value, (Object)pair.getSecond()));
        });
    }

    public <U> DataResult<U> encode(T object, DynamicOps<U> ops, U prefix) {
        class_2960 id = this.getKey(object);
        return id == null ? DataResult.error(() -> "Could not find element " + String.valueOf(object) + " in registry" + this.name) : ops.mergeToPrimitive(prefix, ops.createString(id.toString()));
    }

    public void clear() {
        this.map.clear();
    }

    public <E> Codec<E> dispatch(Function<? super E, ? extends T> type) {
        return super.dispatch(type, c -> (MapCodec)c);
    }

    public int method_10206(T value) {
        return this.tToId.getInt(value);
    }

    @Nullable
    public final T method_10200(int id) {
        return id >= 0 && id < this.idToT.size() ? (T)this.idToT.get(id) : null;
    }

    public Iterator<T> iterator() {
        return Iterators.filter(this.idToT.iterator(), Objects::nonNull);
    }

    public boolean contains(int id) {
        return this.method_10200(id) != null;
    }

    public class_9139<class_2540, T> getStreamCodec() {
        return this.streamCodec;
    }

    private class StreamC
    implements class_9139<class_2540, T> {
        private StreamC() {
        }

        public T decode(class_2540 buffer) {
            int i = class_8703.method_53016((ByteBuf)buffer);
            return MapRegistry.this.method_10200(i);
        }

        public void encode(class_2540 buffer, T value) {
            int i = MapRegistry.this.method_10206(value);
            class_8703.method_53017((ByteBuf)buffer, (int)i);
        }
    }
}

