/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.set.leaves;

import java.util.Collection;
import java.util.Optional;
import net.mehvahdjukaar.moonlight.api.events.AfterLanguageLoadEvent;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.api.set.leaves.LeavesType;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2397;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public class LeavesTypeRegistry
extends BlockTypeRegistry<LeavesType> {
    public static final LeavesTypeRegistry INSTANCE = new LeavesTypeRegistry();
    public static final LeavesType OAK_TYPE = new LeavesType(class_2960.method_60654((String)"oak"), class_2246.field_10503);

    public static Collection<LeavesType> getTypes() {
        return INSTANCE.getValues();
    }

    @Nullable
    public static LeavesType getValue(class_2960 leavesTypeId) {
        return (LeavesType)INSTANCE.get(leavesTypeId);
    }

    @Nullable
    public static LeavesType getValue(String leavesTypeId) {
        return (LeavesType)INSTANCE.get(class_2960.method_60654((String)leavesTypeId));
    }

    public static LeavesType fromNBT(String name) {
        return (LeavesType)INSTANCE.getFromNBT(name);
    }

    public LeavesTypeRegistry() {
        super(LeavesType.class, "leaves_type");
        LeavesType.CODEC = this.getCodec();
        LeavesType.STREAM_CODEC = this.getStreamCodec();
    }

    static void touch() {
    }

    @Override
    public LeavesType getDefaultType() {
        return OAK_TYPE;
    }

    @Override
    public Optional<LeavesType> detectTypeFromBlock(class_2248 baseBlock, class_2960 baseRes) {
        String name = null;
        String path = baseRes.method_12832();
        if (path.endsWith("_leaves")) {
            name = path.substring(0, path.length() - "_leaves".length());
        } else if (path.startsWith("leaves_")) {
            name = path.substring("leaves_".length());
        }
        String namespace = baseRes.method_12836();
        if (name != null && !namespace.equals("securitycraft") && !path.contains("hanging") && baseBlock instanceof class_2397) {
            class_2960 id = baseRes.method_45136(name);
            return Optional.of(new LeavesType(id, baseBlock));
        }
        return Optional.empty();
    }

    private static boolean isBlacklisted(String namespace, String path) {
        return namespace.equals("securitycraft") || namespace.equals("dynamic_trees") || namespace.matches("dynamictrees|dt") || path.contains("hanging");
    }

    @Override
    public void addTypeTranslations(AfterLanguageLoadEvent language) {
        this.getValues().forEach(w -> {
            if (language.isDefault()) {
                language.addEntry(w.getTranslationKey(), w.getReadableName());
            }
        });
    }
}

