/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.util;

import it.unimi.dsi.fastutil.objects.ReferenceOpenHashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.block.ISoftFluidTankProvider;
import net.mehvahdjukaar.moonlight.api.fluids.SoftFluidTank;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockAccessor;
import net.mehvahdjukaar.moonlight.core.mixins.accessor.DispenserBlockEntityAccessor;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1278;
import net.minecraft.class_1747;
import net.minecraft.class_1750;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2315;
import net.minecraft.class_2338;
import net.minecraft.class_2342;
import net.minecraft.class_2347;
import net.minecraft.class_2350;
import net.minecraft.class_2357;
import net.minecraft.class_2371;
import net.minecraft.class_2586;
import net.minecraft.class_2601;
import net.minecraft.class_2769;
import net.minecraft.class_2968;
import net.minecraft.class_2969;
import net.minecraft.class_3218;
import net.minecraft.class_5455;
import org.jetbrains.annotations.ApiStatus;

public class DispenserHelper {
    private static final Map<class_1792, List<class_2357>> MODDED_BEHAVIORS = new HashMap<class_1792, List<class_2357>>();
    private static final Map<Priority, List<Consumer<Event>>> EVENT_LISTENERS = Map.of(Priority.LOW, new ArrayList(), Priority.NORMAL, new ArrayList(), Priority.HIGH, new ArrayList());
    @Deprecated(forRemoval=true)
    public static final class_2347 PLACE_BLOCK_BEHAVIOR = new PlaceBlockDispenseBehavior();
    private static final class_2347 SHOOT_BEHAVIOR = new class_2347();

    public static void addListener(Consumer<Event> listener, Priority priority) {
        EVENT_LISTENERS.get((Object)priority).add(listener);
    }

    @ApiStatus.Internal
    public static void reload(final class_5455 registryAccess, boolean isClient) {
        class_1792 item;
        if (isClient) {
            return;
        }
        final HashSet<class_1792> failed = new HashSet<class_1792>();
        HashMap<class_1792, class_2357> originals = new HashMap<class_1792, class_2357>();
        for (Map.Entry<class_1792, List<class_2357>> entry : MODDED_BEHAVIORS.entrySet()) {
            item = entry.getKey();
            ReferenceOpenHashSet expected = new ReferenceOpenHashSet((Collection)entry.getValue());
            class_2357 current = (class_2357)class_2315.field_10919.get(item);
            if (current instanceof AdditionalDispenserBehavior) {
                AdditionalDispenserBehavior behavior = (AdditionalDispenserBehavior)current;
                ReferenceOpenHashSet visited = new ReferenceOpenHashSet();
                class_2357 original = DispenserHelper.unwrapBehavior(behavior, (Set<AdditionalDispenserBehavior>)visited);
                if (expected.contains((Object)original)) {
                    expected.remove((Object)original);
                    original = null;
                }
                if (expected.equals((Object)visited)) {
                    originals.put(item, original);
                    continue;
                }
                Moonlight.LOGGER.warn("Failed to unwrap original behavior for item: {}, {}, {}", (Object)item, (Object)current, (Object)expected);
                failed.add(item);
                continue;
            }
            if (expected.size() == 1 && expected.stream().findAny().get() == current) {
                originals.put(item, null);
                continue;
            }
            failed.add(item);
            Moonlight.LOGGER.error("Failed to restore original behavior for item: {}, {}", (Object)item, (Object)current);
        }
        for (Map.Entry<Object, List<Object>> entry : originals.entrySet()) {
            item = (class_1792)entry.getKey();
            class_2357 behavior = (class_2357)entry.getValue();
            if (behavior != null) {
                class_2315.method_10009((class_1935)item, (class_2357)behavior);
                continue;
            }
            class_2315.field_10919.remove(item);
        }
        MODDED_BEHAVIORS.clear();
        Event event = new Event(){

            @Override
            public void register(class_1792 i, class_2357 behavior) {
                if (!failed.contains(i)) {
                    MODDED_BEHAVIORS.computeIfAbsent(i, k -> new ArrayList()).add(behavior);
                    class_2315.method_10009((class_1935)i, (class_2357)behavior);
                }
            }

            @Override
            public class_5455 getRegistryAccess() {
                return registryAccess;
            }
        };
        EVENT_LISTENERS.get((Object)Priority.LOW).forEach(l -> l.accept(event));
        EVENT_LISTENERS.get((Object)Priority.NORMAL).forEach(l -> l.accept(event));
        EVENT_LISTENERS.get((Object)Priority.HIGH).forEach(l -> l.accept(event));
    }

    private static class_2357 unwrapBehavior(AdditionalDispenserBehavior behavior, Set<AdditionalDispenserBehavior> visited) {
        visited.add(behavior);
        class_2357 inner = behavior.fallback;
        if (inner instanceof AdditionalDispenserBehavior) {
            AdditionalDispenserBehavior ab = (AdditionalDispenserBehavior)inner;
            return DispenserHelper.unwrapBehavior(ab, visited);
        }
        return inner;
    }

    @Deprecated(forRemoval=true)
    public static void registerCustomBehavior(AdditionalDispenserBehavior behavior) {
        class_2315.method_10009((class_1935)behavior.item, (class_2357)behavior);
    }

    @Deprecated(forRemoval=true)
    public static void registerPlaceBlockBehavior(class_1935 block) {
        class_2315.method_10009((class_1935)block, (class_2357)PLACE_BLOCK_BEHAVIOR);
    }

    public static abstract class AdditionalDispenserBehavior
    implements class_2357 {
        private final class_2357 fallback;
        private final class_1792 item;

        protected AdditionalDispenserBehavior(class_1792 item) {
            this.item = item;
            this.fallback = DispenserBlockAccessor.getDispenserRegistry().get(item);
        }

        public final class_1799 dispense(class_2342 source, class_1799 stack) {
            try {
                class_1271<class_1799> result = this.customBehavior(source, stack);
                class_1269 type = result.method_5467();
                if (type != class_1269.field_5811) {
                    boolean success = type.method_23665();
                    this.playSound(source, success);
                    this.playAnimation(source, (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918));
                    if (success) {
                        class_1799 resultStack = (class_1799)result.method_5466();
                        if (resultStack.method_7909() == stack.method_7909()) {
                            return resultStack;
                        }
                        return this.fillItemInDispenser(source, stack, (class_1799)result.method_5466());
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.fallback.dispense(source, stack);
        }

        protected abstract class_1271<class_1799> customBehavior(class_2342 var1, class_1799 var2);

        protected void playSound(class_2342 source, boolean success) {
            source.comp_1967().method_20290(success ? 1000 : 1001, source.comp_1968(), 0);
        }

        protected void playAnimation(class_2342 source, class_2350 direction) {
            source.comp_1967().method_20290(2000, source.comp_1968(), direction.method_10146());
        }

        private class_1799 fillItemInDispenser(class_2342 source, class_1799 empty, class_1799 filled) {
            empty.method_7934(1);
            if (empty.method_7960()) {
                return filled.method_7972();
            }
            if (!this.mergeDispenserItem(source.comp_1970(), filled)) {
                SHOOT_BEHAVIOR.dispense(source, filled.method_7972());
            }
            return empty;
        }

        private boolean mergeDispenserItem(class_2601 te, class_1799 filled) {
            class_2371<class_1799> stacks = ((DispenserBlockEntityAccessor)te).getItems();
            for (int i = 0; i < te.method_5439(); ++i) {
                class_1799 s = (class_1799)stacks.get(i);
                if (!s.method_7960() && (s.method_7909() != filled.method_7909() || s.method_7914() <= s.method_7947())) continue;
                filled.method_7933(s.method_7947());
                te.method_5447(i, filled);
                return true;
            }
            return false;
        }
    }

    public static enum Priority {
        LOW,
        NORMAL,
        HIGH;

    }

    public static interface Event {
        public void register(class_1792 var1, class_2357 var2);

        default public void register(AdditionalDispenserBehavior behavior) {
            this.register(behavior.item, behavior);
        }

        default public void registerPlaceBlock(class_1935 i) {
            this.register(i.method_8389(), new PlaceBlockBehavior(i.method_8389()));
        }

        public class_5455 getRegistryAccess();
    }

    @Deprecated(forRemoval=true)
    public static class PlaceBlockDispenseBehavior
    extends class_2969 {
        public class_1799 method_10135(class_2342 source, class_1799 stack) {
            this.method_27955(false);
            class_1792 item = stack.method_7909();
            if (item instanceof class_1747) {
                class_1747 bi = (class_1747)item;
                class_2350 direction = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
                class_2338 blockpos = source.comp_1968().method_10093(direction);
                class_2350 direction1 = direction;
                class_1269 result = bi.method_7712((class_1750)new class_2968((class_1937)source.comp_1967(), blockpos, direction, stack, direction1));
                this.method_27955(result.method_23665());
            }
            return stack;
        }
    }

    public static class FillFluidHolderBehavior
    extends AdditionalDispenserBehavior {
        public FillFluidHolderBehavior(class_1792 item) {
            super(item);
        }

        @Override
        protected class_1271<class_1799> customBehavior(class_2342 source, class_1799 stack) {
            class_2338 blockpos = source.comp_1968().method_10093((class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918));
            class_2586 te = source.comp_1967().method_8321(blockpos);
            if (te instanceof ISoftFluidTankProvider) {
                class_1799 returnStack;
                SoftFluidTank tank;
                ISoftFluidTankProvider tile = (ISoftFluidTankProvider)te;
                if (tile.canInteractWithSoftFluidTank() && !(tank = tile.getSoftFluidTank()).isFull() && (returnStack = tank.interactWithItem(stack, (class_1937)source.comp_1967(), blockpos, false)) != null) {
                    te.method_5431();
                    return class_1271.method_22427((Object)returnStack);
                }
                return class_1271.method_22431((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        }
    }

    public static class PlaceBlockBehavior
    extends AdditionalDispenserBehavior {
        public PlaceBlockBehavior(class_1792 item) {
            super(item);
        }

        @Override
        protected class_1271<class_1799> customBehavior(class_2342 source, class_1799 stack) {
            class_1792 item = stack.method_7909();
            if (item instanceof class_1747) {
                class_1747 bi = (class_1747)item;
                class_2350 direction = (class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918);
                class_2338 blockpos = source.comp_1968().method_10093(direction);
                class_1269 result = bi.method_7712((class_1750)new class_2968((class_1937)source.comp_1967(), blockpos, direction, stack, direction));
                class_1271 res = new class_1271(result, (Object)stack);
                if (result.method_23665()) {
                    return res;
                }
            }
            return class_1271.method_22430((Object)stack);
        }
    }

    public static class AddItemToInventoryBehavior
    extends AdditionalDispenserBehavior {
        public AddItemToInventoryBehavior(class_1792 item) {
            super(item);
        }

        @Override
        protected class_1271<class_1799> customBehavior(class_2342 source, class_1799 stack) {
            class_2338 blockpos;
            class_3218 world = source.comp_1967();
            class_2586 te = world.method_8321(blockpos = source.comp_1968().method_10093((class_2350)source.comp_1969().method_11654((class_2769)class_2315.field_10918)));
            if (te instanceof class_1278) {
                class_1278 tile = (class_1278)te;
                if (tile.method_5437(0, stack)) {
                    if (tile.method_5442()) {
                        tile.method_5447(0, stack.method_7971(1));
                    } else {
                        tile.method_5438(0).method_7933(1);
                        stack.method_7934(1);
                    }
                    return class_1271.method_22427((Object)stack);
                }
                return class_1271.method_22431((Object)stack);
            }
            return class_1271.method_22430((Object)stack);
        }
    }
}

