/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import folk.sisby.surveyor.PlayerSummary;
import folk.sisby.surveyor.ServerSummary;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.Landmarks;
import folk.sisby.surveyor.landmark.SimplePointLandmark;
import folk.sisby.surveyor.landmark.WorldLandmarks;
import folk.sisby.surveyor.util.TextUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1767;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2232;
import net.minecraft.class_2262;
import net.minecraft.class_2280;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_7157;

public class SurveyorCommands {
    private static final Multimap<UUID, UUID> requests = HashMultimap.create();

    private static void informGroup(class_3222 player, Set<PlayerSummary> group, Consumer<class_2561> feedback) {
        feedback.accept((class_2561)class_2561.method_43470((String)"You're sharing your map with ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(group.size() - 1)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(" other" + (group.size() - 1 > 1 ? " players:" : " player:"))).method_27692(class_124.field_1065)));
        feedback.accept((class_2561)TextUtil.highlightStrings(group.stream().map(PlayerSummary::username).filter(u -> !u.equals(player.method_7334().getName())).toList(), s -> class_124.field_1068).method_27692(class_124.field_1065));
    }

    private static int informGlobal(ServerSummary serverSummary, class_3222 player, Consumer<class_2561> feedback) {
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"The server has global sharing enabled!").method_27692(class_124.field_1054)));
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You can't leave or modify the global sharing group!").method_27692(class_124.field_1054)));
        SurveyorCommands.informGroup(player, serverSummary.groupPlayers(Surveyor.getUuid(player), player.method_5682()), feedback);
        return 0;
    }

    private static int info(ServerSummary serverSummary, class_3222 player, SurveyorExploration exploration, Consumer<class_2561> feedback) {
        Set<PlayerSummary> group = serverSummary.groupPlayers(Surveyor.getUuid(player), player.method_5682());
        SurveyorExploration groupExploration = SurveyorExploration.ofShared(player);
        HashSet landmarks = new HashSet();
        HashSet waypoints = new HashSet();
        HashSet groupLandmarks = new HashSet();
        HashSet groupWaypoints = new HashSet();
        for (class_3218 world : player.method_5682().method_3738()) {
            WorldLandmarks summary = WorldSummary.of((class_1937)world).landmarks();
            if (summary == null) continue;
            summary.asMap(exploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? landmarks : waypoints).add(landmark)));
            summary.asMap(groupExploration).forEach((type, inner) -> inner.forEach((pos, landmark) -> (landmark.owner() == null ? groupLandmarks : groupWaypoints).add(landmark)));
        }
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"---Map Exploration Summary---").method_27692(class_124.field_1080)));
        feedback.accept((class_2561)class_2561.method_43470((String)"You've explored ").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(exploration.chunkCount())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" total chunks!").method_27692(class_124.field_1075)).method_10852((class_2561)(group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupExploration.chunkCount())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1075)))));
        feedback.accept((class_2561)class_2561.method_43470((String)"You've explored ").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(exploration.structureCount())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" structures!").method_27692(class_124.field_1076)).method_10852((class_2561)(group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupExploration.structureCount())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1076)))));
        feedback.accept((class_2561)class_2561.method_43470((String)"You've explored ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(landmarks.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" landmarks!").method_27692(class_124.field_1060)).method_10852((class_2561)(group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupLandmarks.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1060)))));
        feedback.accept((class_2561)class_2561.method_43470((String)"...and created ").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(waypoints.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" waypoints!").method_27692(class_124.field_1060)).method_10852((class_2561)(group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1060).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupWaypoints.size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" with friends)").method_27692(class_124.field_1060)))));
        if (group.size() > 1) {
            SurveyorCommands.informGroup(player, group, feedback);
        }
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"-------End Summary-------").method_27692(class_124.field_1080)));
        return 1;
    }

    private static int landmarkInfo(ServerSummary serverSummary, class_3222 player, SurveyorExploration exploration, Consumer<class_2561> feedback) {
        Set<PlayerSummary> group = serverSummary.groupPlayers(Surveyor.getUuid(player), player.method_5682());
        SurveyorExploration groupExploration = SurveyorExploration.ofShared(player);
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"---Landmark Types---").method_27692(class_124.field_1080)));
        HashSet<LandmarkType> waypoints = new HashSet<LandmarkType>();
        HashMultimap keys = HashMultimap.create();
        HashMultimap groupKeys = HashMultimap.create();
        HashMultimap personalKeys = HashMultimap.create();
        for (class_3218 world : player.method_5682().method_3738()) {
            WorldLandmarks summary = WorldSummary.of((class_1937)world).landmarks();
            if (summary == null) continue;
            waypoints.addAll(summary.asMap(null).values().stream().flatMap(e -> e.values().stream().filter(l -> l.owner() != null)).map(Landmark::type).toList());
            keys.putAll(summary.keySet(null));
            groupKeys.putAll(summary.keySet(groupExploration));
            personalKeys.putAll(summary.keySet(exploration));
        }
        keys.asMap().forEach((arg_0, arg_1) -> SurveyorCommands.lambda$landmarkInfo$8(feedback, waypoints, (Multimap)personalKeys, group, (Multimap)groupKeys, player, (Multimap)keys, arg_0, arg_1));
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"-------End Landmarks-------").method_27692(class_124.field_1080)));
        return 1;
    }

    private static int share(ServerSummary serverSummary, class_3222 player, Consumer<class_2561> feedback, String username) {
        class_3222 sharePlayer = player.method_5682().method_3760().method_14566(username);
        if (sharePlayer == null) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"Can't find an online player named ").method_27692(class_124.field_1054)).method_10852((class_2561)class_2561.method_43470((String)username).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1054)));
            return 0;
        }
        if (sharePlayer == player) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You can't share map exploration with yourself!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (requests.containsEntry((Object)Surveyor.getUuid(player), (Object)Surveyor.getUuid(sharePlayer))) {
            if (serverSummary.groupSize(Surveyor.getUuid(player)) > 1 && serverSummary.groupSize(Surveyor.getUuid(sharePlayer)) > 1) {
                feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You're in a group! leave your group first with:").method_27692(class_124.field_1054)));
                feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"/surveyor unshare").method_27692(class_124.field_1065)));
                return 0;
            }
            requests.removeAll((Object)Surveyor.getUuid(player));
            ServerSummary.of(player.method_5682()).joinGroup(Surveyor.getUuid(player), Surveyor.getUuid(sharePlayer), player.method_5682());
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You're now sharing map exploration with ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)) - 1)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(serverSummary.groupSize(Surveyor.getUuid(player)) - 1 > 1 ? " players:" : " player:")).method_27692(class_124.field_1060)));
            feedback.accept((class_2561)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(player), player.method_5682()).stream().map(PlayerSummary::username).filter(u -> !u.equals(player.method_7334().getName())).toList(), s -> class_124.field_1068).method_27692(class_124.field_1060));
            for (class_3222 friend : serverSummary.groupOtherServerPlayers(Surveyor.getUuid(player), player.method_5682())) {
                friend.method_43496((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" is now sharing their map with you.").method_27692(class_124.field_1075)));
                friend.method_43496((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You're now sharing map exploration with ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)) - 1)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(serverSummary.groupSize(Surveyor.getUuid(player)) - 1 > 1 ? " players:" : " player:")).method_27692(class_124.field_1075)));
                friend.method_43496((class_2561)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(player), player.method_5682()).stream().map(PlayerSummary::username).filter(u -> !u.equals(friend.method_7334().getName())).toList(), s -> class_124.field_1068).method_27692(class_124.field_1075));
            }
            return 1;
        }
        if (!requests.containsEntry((Object)Surveyor.getUuid(sharePlayer), (Object)Surveyor.getUuid(player))) {
            requests.put((Object)Surveyor.getUuid(sharePlayer), (Object)Surveyor.getUuid(player));
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"Share request sent to ").method_27692(class_124.field_1060)).method_10852((class_2561)sharePlayer.method_5476().method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
            sharePlayer.method_43496((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" wants to share map exploration!").method_27692(class_124.field_1075)));
            if (serverSummary.groupSize(Surveyor.getUuid(player)) <= 1 && serverSummary.groupSize(Surveyor.getUuid(sharePlayer)) <= 1) {
                feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"If accepted, you'll share your map exploration.").method_27692(class_124.field_1060)));
                sharePlayer.method_43496((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"To share your explored map area, enter:").method_27692(class_124.field_1075)));
            } else if (serverSummary.groupSize(Surveyor.getUuid(player)) <= 1) {
                feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"If accepted, you'll share with their group of ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(sharePlayer)))).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
                sharePlayer.method_43496((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"To share your group of ").method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(sharePlayer)))).method_27692(class_124.field_1068)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)", enter:").method_27692(class_124.field_1075)));
            } else {
                feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"If accepted, they'll share with your group of ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)))).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)".").method_27692(class_124.field_1060)));
                sharePlayer.method_43496((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"To share with their group of ").method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(serverSummary.groupSize(Surveyor.getUuid(player)))).method_27692(class_124.field_1068)).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)", enter:").method_27692(class_124.field_1075)));
            }
            sharePlayer.method_43496((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"/surveyor share %s".formatted(player.method_7334().getName())).method_27692(class_124.field_1065)));
            return 1;
        }
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You've already sent this player a share request!").method_27692(class_124.field_1054)));
        return 0;
    }

    private static int unshare(ServerSummary serverSummary, class_3222 player, Consumer<class_2561> feedback) {
        int shareNumber = serverSummary.groupSize(Surveyor.getUuid(player)) - 1;
        if (shareNumber == 0) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You're not sharing map exploration with anyone!").method_27692(class_124.field_1054)));
            return 0;
        }
        Set<class_3222> friends = serverSummary.groupOtherServerPlayers(Surveyor.getUuid(player), player.method_5682());
        ServerSummary.of(player.method_5682()).leaveGroup(Surveyor.getUuid(player), player.method_5682());
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"Stopped sharing map exploration with ").method_27692(class_124.field_1060)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(shareNumber)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(shareNumber > 1 ? " players." : " player.")).method_27692(class_124.field_1060)));
        for (class_3222 friend : friends) {
            int groupSize = serverSummary.groupSize(Surveyor.getUuid(friend)) - 1;
            friend.method_43496((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)player.method_5476().method_27661().method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" is no longer sharing with you.").method_27692(class_124.field_1075)));
            friend.method_43496((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You're now sharing map exploration with ").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupSize)).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)(groupSize == 0 ? " players." : (groupSize > 1 ? " players:" : " player:"))).method_27692(class_124.field_1075)));
            if (groupSize <= 0) continue;
            friend.method_43496((class_2561)TextUtil.highlightStrings(serverSummary.groupPlayers(Surveyor.getUuid(friend), friend.method_5682()).stream().map(PlayerSummary::username).filter(u -> !u.equals(friend.method_7334().getName())).toList(), s -> class_124.field_1068).method_27692(class_124.field_1075));
        }
        return 1;
    }

    private static int getLandmarks(WorldSummary summary, class_3222 player, SurveyorExploration exploration, Consumer<class_2561> feedback, class_2960 type) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        Map<class_2338, ?> landmarks = summary.landmarks().asMap(Landmarks.getType(type), player.method_5687(2) ? null : exploration);
        if (landmarks.isEmpty()) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"There are no landmarks of that type in this world!").method_27692(class_124.field_1054)));
            return 0;
        }
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"---World %s Landmarks---".formatted(type)).method_27692(class_124.field_1080)));
        for (Landmark landmark : landmarks.values()) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[").method_27692(class_124.field_1075).method_10852((class_2561)class_2561.method_43470((String)landmark.pos().method_23854()).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"]").method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)" - ").method_27692(landmark.owner() != null ? class_124.field_1060 : class_124.field_1061)).method_10852((class_2561)class_2561.method_43470((String)"\"").method_27692(class_124.field_1065)).method_10852((class_2561)(landmark.name() == null ? class_2561.method_30163((String)"") : landmark.name().method_27661().method_27694(s -> s.method_36139(landmark.color() != null ? landmark.color().method_7790() : class_124.field_1068.method_532().intValue())))).method_10852((class_2561)class_2561.method_43470((String)"\"").method_27692(class_124.field_1065)));
        }
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"---End %s Landmarks---".formatted(type)).method_27692(class_124.field_1080)));
        return landmarks.size();
    }

    private static int removeLandmark(WorldSummary summary, class_3222 player, class_3218 world, Consumer<class_2561> feedback, class_2960 type, class_2338 pos) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"No landmark exists of that type and position!").method_27692(class_124.field_1054)));
            return 0;
        }
        Landmark<?> landmark = summary.landmarks().get(Landmarks.getType(type), pos);
        if (!(landmark.owner() != null && landmark.owner() == Surveyor.getUuid(player) || player.method_5687(2))) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You don't have permission to delete that landmark!").method_27692(class_124.field_1054)));
            return 0;
        }
        summary.landmarks().remove((class_1937)world, Landmarks.getType(type), pos);
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"%s removed successfully!".formatted(landmark.owner() == null ? "Landmark" : "Waypoint")).method_27692(class_124.field_1060)));
        return 1;
    }

    private static int addLandmark(WorldSummary summary, class_3222 player, class_3218 world, Consumer<class_2561> feedback, class_2960 type, class_2338 pos, class_1767 color, String name, boolean global) {
        if (summary.landmarks() == null) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"The landmark system is dynamically disabled!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (!SimplePointLandmark.TYPE.id().equals((Object)type)) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You can't create a landmark of that type!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (global && !player.method_5687(2)) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"You don't have permission to add that landmark!").method_27692(class_124.field_1054)));
            return 0;
        }
        if (summary.landmarks().contains(Landmarks.getType(type), pos)) {
            feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"A landmark exists of that type and position!").method_27692(class_124.field_1054)));
            return 0;
        }
        summary.landmarks().put((class_1937)world, new SimplePointLandmark(pos, global ? null : Surveyor.getUuid(player), color, class_2561.method_30163((String)name), class_2960.method_12829((String)"")));
        feedback.accept((class_2561)class_2561.method_43470((String)"[Surveyor] ").method_27692(class_124.field_1079).method_10852((class_2561)class_2561.method_43470((String)"%s added successfully!".formatted(global ? "Landmark" : "Waypoint")).method_27692(class_124.field_1060)));
        return 1;
    }

    public static int execute(CommandContext<class_2168> context, SurveyorCommandExecutor<Integer> executor) {
        class_3222 player;
        try {
            player = ((class_2168)context.getSource()).method_9207();
        }
        catch (CommandSyntaxException e) {
            Surveyor.LOGGER.error("[Surveyor] Commands cannot be invoked by a non-player");
            return 0;
        }
        SurveyorExploration exploration = SurveyorExploration.of(player);
        try {
            return executor.execute(ServerSummary.of(player.method_5682()), WorldSummary.of((class_1937)((class_2168)context.getSource()).method_9225()), player, ((class_2168)context.getSource()).method_9225(), exploration, t -> ((class_2168)context.getSource()).method_9226(() -> t, false));
        }
        catch (Exception e) {
            ((class_2168)context.getSource()).method_9226(() -> class_2561.method_43470((String)"Command failed! Check log for details.").method_27692(class_124.field_1061), false);
            Surveyor.LOGGER.error("[Surveyor] Error while executing command: {}", (Object)context.getInput(), (Object)e);
            return 0;
        }
    }

    public static void registerCommands(CommandDispatcher<class_2168> dispatcher, class_7157 registryAccess, class_2170.class_5364 environment) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"surveyor").executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, w, p, sw, e, f) -> SurveyorCommands.info(s, p, e, f)))).then(Surveyor.CONFIG.networking.globalSharing ? class_2170.method_9247((String)"share").executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, w, p, sw, e, f) -> SurveyorCommands.informGlobal(s, p, f))) : class_2170.method_9247((String)"share").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(((class_2168)c.getSource()).method_9211().method_3760().method_14571().stream().filter(p -> ((class_2168)c.getSource()).method_44023() != p).map(p -> p.method_7334().getName()), (SuggestionsBuilder)b)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, w, p, sw, e, f) -> SurveyorCommands.share(s, p, f, (String)c.getArgument("player", String.class))))))).then(Surveyor.CONFIG.networking.globalSharing ? class_2170.method_9247((String)"unshare").executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, w, p, sw, e, f) -> SurveyorCommands.informGlobal(s, p, f))) : class_2170.method_9247((String)"unshare").executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, w, p, sw, e, f) -> SurveyorCommands.unshare(s, p, f))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"landmarks").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.DISABLED)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, w, p, sw, e, f) -> SurveyorCommands.landmarkInfo(s, p, e, f)))).then(class_2170.method_9247((String)"get").then(class_2170.method_9244((String)"type", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(Landmarks.keySet(), (SuggestionsBuilder)b)).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, w, p, sw, e, f) -> SurveyorCommands.getLandmarks(w, p, e, f, (class_2960)c.getArgument("type", class_2960.class))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(class_2170.method_9244((String)"type", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(Landmarks.keySet(), (SuggestionsBuilder)b)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, w, p, sw, e, f) -> SurveyorCommands.removeLandmark(w, p, sw, f, (class_2960)c.getArgument("type", class_2960.class), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource())))))))).then(((LiteralArgumentBuilder)class_2170.method_9247((String)"add").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).then(class_2170.method_9244((String)"type", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(Arrays.stream(class_1767.values()).map(class_1767::method_7792), (SuggestionsBuilder)b)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, w, p, sw, e, f) -> SurveyorCommands.addLandmark(w, p, sw, f, (class_2960)c.getArgument("type", class_2960.class), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource()), class_1767.method_7793((String)((String)c.getArgument("color", String.class)), (class_1767)class_1767.field_7952), (String)c.getArgument("name", String.class), false))))))))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"global").requires(c -> Surveyor.CONFIG.landmarks != SystemMode.FROZEN)).requires(c -> c.method_44023() == null || c.method_44023().method_5687(2))).then(class_2170.method_9244((String)"type", (ArgumentType)class_2232.method_9441()).suggests((c, b) -> class_2172.method_9270(List.of(SimplePointLandmark.TYPE.id()), (SuggestionsBuilder)b)).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2262.method_9698()).then(class_2170.method_9244((String)"color", (ArgumentType)StringArgumentType.word()).suggests((c, b) -> class_2172.method_9264(Arrays.stream(class_1767.values()).map(class_1767::method_7792), (SuggestionsBuilder)b)).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(c -> SurveyorCommands.execute((CommandContext<class_2168>)c, (s, w, p, sw, e, f) -> SurveyorCommands.addLandmark(w, p, sw, f, (class_2960)c.getArgument("type", class_2960.class), ((class_2280)c.getArgument("pos", class_2280.class)).method_9704((class_2168)c.getSource()), class_1767.method_7793((String)((String)c.getArgument("color", String.class)), (class_1767)class_1767.field_7952), (String)c.getArgument("name", String.class), true))))))))));
    }

    private static /* synthetic */ void lambda$landmarkInfo$8(Consumer feedback, Set waypoints, Multimap personalKeys, Set group, Multimap groupKeys, class_3222 player, Multimap keys, LandmarkType type, Collection list) {
        feedback.accept(class_2561.method_43470((String)"%s".formatted(type.id())).method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)(waypoints.contains(type) ? ": created " : ": explored ")).method_27692(class_124.field_1075)).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(personalKeys.get((Object)type).size())).method_27692(class_124.field_1068)).method_10852((class_2561)(group.size() <= 1 ? class_2561.method_43473() : class_2561.method_43470((String)" (").method_27692(class_124.field_1076).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(groupKeys.get((Object)type).size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)" shared)").method_27692(class_124.field_1076)))).method_10852((class_2561)(!player.method_5687(2) ? class_2561.method_43473() : class_2561.method_43470((String)" {of ").method_27692(class_124.field_1065).method_10852((class_2561)class_2561.method_43470((String)"%d".formatted(keys.get((Object)type).size())).method_27692(class_124.field_1068)).method_10852((class_2561)class_2561.method_43470((String)"}").method_27692(class_124.field_1065)))));
    }

    public static interface SurveyorCommandExecutor<T> {
        public T execute(ServerSummary var1, WorldSummary var2, class_3222 var3, class_3218 var4, SurveyorExploration var5, Consumer<class_2561> var6);
    }
}

