/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.client;

import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.SurveyorNetworking;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.client.NetworkHandlerSummary;
import folk.sisby.surveyor.client.SurveyorClient;
import folk.sisby.surveyor.config.NetworkMode;
import folk.sisby.surveyor.packet.C2SKnownLandmarksPacket;
import folk.sisby.surveyor.packet.C2SKnownStructuresPacket;
import folk.sisby.surveyor.packet.C2SKnownTerrainPacket;
import folk.sisby.surveyor.packet.S2CGroupChangedPacket;
import folk.sisby.surveyor.packet.S2CGroupUpdatedPacket;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.S2CStructuresAddedPacket;
import folk.sisby.surveyor.packet.S2CUpdateRegionPacket;
import folk.sisby.surveyor.packet.SyncLandmarksAddedPacket;
import folk.sisby.surveyor.packet.SyncLandmarksRemovedPacket;
import folk.sisby.surveyor.terrain.RegionSummary;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_310;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import net.minecraft.class_8710;

public class SurveyorClientNetworking {
    public static void init() {
        SurveyorNetworking.C2S_SENDER = p -> {
            if (!ClientPlayNetworking.canSend((class_8710.class_9154)p.method_56479())) {
                return;
            }
            p.toPayloads().forEach(ClientPlayNetworking::send);
        };
        ClientPlayNetworking.registerGlobalReceiver(S2CStructuresAddedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleStructuresAdded));
        ClientPlayNetworking.registerGlobalReceiver(S2CUpdateRegionPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleTerrainAdded));
        ClientPlayNetworking.registerGlobalReceiver(S2CGroupChangedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleGroupChanged));
        ClientPlayNetworking.registerGlobalReceiver(S2CGroupUpdatedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleGroupUpdated));
        ClientPlayNetworking.registerGlobalReceiver(SyncLandmarksAddedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleLandmarksAdded));
        ClientPlayNetworking.registerGlobalReceiver(SyncLandmarksRemovedPacket.ID, (packet, context) -> SurveyorClientNetworking.handleClient(packet, context, SurveyorClientNetworking::handleLandmarksRemoved));
    }

    private static void handleTerrainAdded(class_638 world, WorldSummary summary, S2CUpdateRegionPacket packet) {
        if (summary.terrain() == null) {
            return;
        }
        summary.terrain().getRegion(packet.regionPos()).readUpdatePacket(world.method_30349(), packet);
        (packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration()).mergeRegion((class_5321<class_1937>)world.method_27983(), packet.regionPos(), packet.set());
        SurveyorEvents.Invoke.terrainUpdated((class_1937)world, packet.set().stream().mapToObj(i -> RegionSummary.chunkForBit(packet.regionPos(), i)).toList());
    }

    private static void handleStructuresAdded(class_638 world, WorldSummary summary, S2CStructuresAddedPacket packet) {
        if (summary.structures() == null) {
            return;
        }
        Multimap<class_5321<class_3195>, class_1923> keySet = summary.structures().readUpdatePacket((class_1937)world, packet);
        if (class_310.method_1551().field_1724 != null) {
            SurveyorExploration exploration = packet.shared() ? SurveyorClient.getSharedExploration() : SurveyorClient.getPersonalExploration();
            keySet.forEach((key, pos) -> exploration.addStructure((class_5321<class_1937>)world.method_27983(), (class_5321<class_3195>)key, (class_1923)pos));
        }
    }

    private static void handleGroupChanged(class_638 world, WorldSummary summary, S2CGroupChangedPacket packet) {
        if (!SurveyorClient.getSharedExploration().groupPlayers().equals(packet.players().keySet())) {
            SurveyorClient.getSharedExploration().groupPlayers().clear();
            SurveyorClient.getSharedExploration().groupPlayers().addAll(packet.players().keySet());
        }
        NetworkHandlerSummary.of(class_310.method_1551().method_1562()).mergeSummaries(packet.players());
        SurveyorClient.getSharedExploration().replaceTerrain((class_5321<class_1937>)world.method_27983(), packet.regionBits());
        SurveyorClient.getSharedExploration().replaceStructures((class_5321<class_1937>)world.method_27983(), packet.structureKeys());
        SurveyorClient.getExploration().updateClientForLandmarks((class_1937)world);
        if (summary != null) {
            if (summary.terrain() != null && Surveyor.CONFIG.networking.terrain.atLeast(NetworkMode.SOLO)) {
                new C2SKnownTerrainPacket(summary.terrain().bitSet(null)).send();
            }
            if (summary.structures() != null && Surveyor.CONFIG.networking.structures.atLeast(NetworkMode.SOLO)) {
                new C2SKnownStructuresPacket(summary.structures().keySet(null)).send();
            }
            if (summary.landmarks() != null && Surveyor.CONFIG.networking.landmarks.atLeast(NetworkMode.SOLO)) {
                new C2SKnownLandmarksPacket(summary.landmarks().keySet(null)).send();
            }
        }
    }

    private static void handleGroupUpdated(class_638 world, WorldSummary summary, S2CGroupUpdatedPacket packet) {
        NetworkHandlerSummary.of(class_310.method_1551().method_1562()).mergeSummaries(packet.players());
    }

    private static void handleLandmarksAdded(class_638 world, WorldSummary summary, SyncLandmarksAddedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((class_1937)world, packet, null);
    }

    private static void handleLandmarksRemoved(class_638 world, WorldSummary summary, SyncLandmarksRemovedPacket packet) {
        if (summary.landmarks() == null) {
            return;
        }
        summary.landmarks().readUpdatePacket((class_1937)world, packet, null);
    }

    private static <T extends S2CPacket> void handleClient(T packet, ClientPlayNetworking.Context context, ClientPacketHandler<T> handler) {
        WorldSummary summary;
        class_638 world = context.client().field_1687;
        WorldSummary worldSummary = summary = world == null ? null : WorldSummary.of((class_1937)world);
        if (summary != null && !summary.isClient()) {
            return;
        }
        class_310.method_1551().execute(() -> handler.handle(world, summary, packet));
    }

    public static interface ClientPacketHandler<T> {
        public void handle(class_638 var1, WorldSummary var2, T var3);
    }
}

