/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.landmark;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import folk.sisby.surveyor.landmark.Landmark;
import folk.sisby.surveyor.landmark.LandmarkType;
import folk.sisby.surveyor.landmark.NetherPortalLandmark;
import folk.sisby.surveyor.landmark.PlayerDeathLandmark;
import folk.sisby.surveyor.landmark.SimplePointLandmark;
import folk.sisby.surveyor.landmark.SimplePointOfInterestLandmark;
import folk.sisby.surveyor.util.DispatchMapCodec;
import folk.sisby.surveyor.util.SurveyorCodecs;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class Landmarks {
    public static final String KEY_LANDMARKS = "landmarks";
    private static final Map<class_2960, LandmarkType<?>> TYPES = new HashMap();
    public static final Codec<LandmarkType<?>> TYPE_CODEC = class_2960.field_25139.comapFlatMap(Landmarks::decode, LandmarkType::id);
    public static final Codec<Map<LandmarkType<?>, Map<class_2338, Landmark<?>>>> CODEC = DispatchMapCodec.of(TYPE_CODEC, Landmarks::typedCodec);

    public static <T extends Landmark<T>> Codec<Map<class_2338, Landmark<?>>> typedCodec(LandmarkType<T> type) {
        return DispatchMapCodec.of(SurveyorCodecs.STRINGIFIED_BLOCKPOS, pos -> type.createCodec((class_2338)pos));
    }

    private static DataResult<? extends LandmarkType<?>> decode(class_2960 id) {
        return Optional.ofNullable(TYPES.get(id)).map(DataResult::success).orElse(DataResult.error(() -> "No landmark type found with id " + String.valueOf(id)));
    }

    public static boolean containsType(class_2960 id) {
        return TYPES.containsKey(id);
    }

    public static class_2487 writeNbt(Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> landmarks, class_2487 nbt) {
        nbt.method_10566(KEY_LANDMARKS, (class_2520)CODEC.encodeStart((DynamicOps)class_2509.field_11560, landmarks).getOrThrow());
        return nbt;
    }

    public static Map<LandmarkType<?>, Map<class_2338, Landmark<?>>> fromNbt(class_2487 nbt) {
        return (Map)((Pair)CODEC.decode((DynamicOps)class_2509.field_11560, (Object)nbt.method_10562(KEY_LANDMARKS)).getOrThrow()).getFirst();
    }

    public static LandmarkType<?> getType(class_2960 id) {
        return TYPES.get(id);
    }

    public static Set<class_2960> keySet() {
        return new HashSet<class_2960>(TYPES.keySet());
    }

    public static void register(LandmarkType<?> type) {
        if (Landmarks.containsType(type.id())) {
            throw new IllegalArgumentException("Multiple landmark types registered to the same ID: %s".formatted(type.id()));
        }
        TYPES.put(type.id(), type);
    }

    static {
        Landmarks.register(SimplePointLandmark.TYPE);
        Landmarks.register(SimplePointOfInterestLandmark.TYPE);
        Landmarks.register(NetherPortalLandmark.TYPE);
        Landmarks.register(PlayerDeathLandmark.TYPE);
    }
}

