/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.SurveyorPacket;
import folk.sisby.surveyor.packet.SurveyorPacketCodecs;
import folk.sisby.surveyor.structure.StructureStartSummary;
import folk.sisby.surveyor.structure.WorldStructureSummary;
import folk.sisby.surveyor.util.MapUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3195;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7151;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record S2CStructuresAddedPacket(boolean shared, Map<class_5321<class_3195>, Map<class_1923, StructureStartSummary>> structures, Map<class_5321<class_3195>, class_5321<class_7151<?>>> types, Multimap<class_5321<class_3195>, class_6862<class_3195>> tags) implements S2CPacket
{
    public static final class_8710.class_9154<S2CStructuresAddedPacket> ID = new class_8710.class_9154(class_2960.method_60655((String)"surveyor", (String)"s2c_structures_added"));
    public static final class_9139<class_2540, S2CStructuresAddedPacket> CODEC = class_9139.method_56905((class_9139)class_9135.field_48547, S2CStructuresAddedPacket::shared, SurveyorPacketCodecs.STRUCTURE_SUMMARIES, S2CStructuresAddedPacket::structures, SurveyorPacketCodecs.STRUCTURE_TYPES, S2CStructuresAddedPacket::types, SurveyorPacketCodecs.STRUCTURE_TAGS, S2CStructuresAddedPacket::tags, S2CStructuresAddedPacket::new);

    public static S2CStructuresAddedPacket of(boolean shared, Multimap<class_5321<class_3195>, class_1923> keys, WorldStructureSummary summary) {
        return summary.createUpdatePacket(shared, keys);
    }

    public static S2CStructuresAddedPacket of(boolean shared, class_5321<class_3195> key, class_1923 pos, WorldStructureSummary summary) {
        return S2CStructuresAddedPacket.of(shared, MapUtil.asMultiMap(Map.of(key, List.of(pos))), summary);
    }

    @Override
    public List<SurveyorPacket> toPayloads() {
        ArrayList<SurveyorPacket> payloads = new ArrayList<SurveyorPacket>();
        class_2540 buf = new class_2540(Unpooled.buffer());
        CODEC.encode((Object)buf, (Object)this);
        if (buf.readableBytes() < 0x100000) {
            payloads.add(this);
        } else {
            Multimap<class_5321<class_3195>, class_1923> keySet = MapUtil.keyMultiMap(this.structures);
            if (keySet.size() == 1) {
                Surveyor.LOGGER.error("Couldn't create a structure update packet for {} at {} - an individual structure would be too large to send!", (Object)((class_5321)keySet.keys().stream().findFirst().orElseThrow()).method_29177(), keySet.values().stream().findFirst().orElseThrow());
                return List.of();
            }
            HashMultimap firstHalf = HashMultimap.create();
            HashMultimap secondHalf = HashMultimap.create();
            keySet.forEach((arg_0, arg_1) -> S2CStructuresAddedPacket.lambda$toPayloads$0((Multimap)firstHalf, keySet, (Multimap)secondHalf, arg_0, arg_1));
            payloads.addAll(new S2CStructuresAddedPacket(this.shared, MapUtil.splitByKeyMap(this.structures, firstHalf), MapUtil.splitByKeySet(this.types, firstHalf.keySet()), MapUtil.asMultiMap(MapUtil.splitByKeySet(this.tags.asMap(), firstHalf.keySet()))).toPayloads());
            payloads.addAll(new S2CStructuresAddedPacket(this.shared, MapUtil.splitByKeyMap(this.structures, secondHalf), MapUtil.splitByKeySet(this.types, secondHalf.keySet()), MapUtil.asMultiMap(MapUtil.splitByKeySet(this.tags.asMap(), secondHalf.keySet()))).toPayloads());
        }
        return payloads;
    }

    public class_8710.class_9154<S2CStructuresAddedPacket> method_56479() {
        return ID;
    }

    private static /* synthetic */ void lambda$toPayloads$0(Multimap firstHalf, Multimap keySet, Multimap secondHalf, class_5321 key, class_1923 pos) {
        if (firstHalf.size() < keySet.size() / 2) {
            firstHalf.put((Object)key, (Object)pos);
        } else {
            secondHalf.put((Object)key, (Object)pos);
        }
    }
}

