/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.packet;

import com.mojang.serialization.Codec;
import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.packet.S2CPacket;
import folk.sisby.surveyor.packet.SurveyorPacket;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.BitSetUtil;
import folk.sisby.surveyor.util.ListUtil;
import io.netty.buffer.Unpooled;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import net.minecraft.class_1923;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_5699;
import net.minecraft.class_8710;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record S2CUpdateRegionPacket(boolean shared, class_1923 regionPos, List<Integer> biomePalette, List<Integer> blockPalette, BitSet set, List<ChunkSummary> chunks) implements S2CPacket
{
    public static final class_8710.class_9154<S2CUpdateRegionPacket> ID = new class_8710.class_9154(class_2960.method_60655((String)"surveyor", (String)"s2c_update_region"));
    public static final class_9139<class_2540, S2CUpdateRegionPacket> CODEC = class_9139.method_58025((class_9139)class_9135.field_48547, S2CUpdateRegionPacket::shared, (class_9139)class_9135.field_48551.method_56432(class_1923::new, class_1923::method_8324), S2CUpdateRegionPacket::regionPos, (class_9139)class_9135.field_49675.method_56433(class_9135.method_56363()), S2CUpdateRegionPacket::biomePalette, (class_9139)class_9135.field_49675.method_56433(class_9135.method_56363()), S2CUpdateRegionPacket::blockPalette, (class_9139)class_9135.method_56368((Codec)class_5699.field_40724), S2CUpdateRegionPacket::set, (class_9139)class_9139.method_56438(ChunkSummary::writeBuf, ChunkSummary::new).method_56433(class_9135.method_56363()), S2CUpdateRegionPacket::chunks, S2CUpdateRegionPacket::new);

    public static S2CUpdateRegionPacket of(boolean shared, class_1923 regionPos, RegionSummary summary, BitSet keys) {
        return summary.createUpdatePacket(shared, regionPos, keys);
    }

    @Override
    public List<SurveyorPacket> toPayloads() {
        ArrayList<SurveyorPacket> payloads = new ArrayList<SurveyorPacket>();
        class_2540 buf = new class_2540(Unpooled.buffer());
        CODEC.encode((Object)buf, (Object)this);
        if (buf.readableBytes() < 0x100000) {
            payloads.add(this);
        } else {
            if (this.set.cardinality() == 1) {
                int bit = this.set.stream().findFirst().orElseThrow();
                Surveyor.LOGGER.error("Couldn't create a terrain update packet at {} - an individual chunk would be too large to send!", (Object)"[%d,%d]".formatted(this.regionPos.field_9181 + RegionSummary.xForBit(bit), this.regionPos.field_9180 + RegionSummary.zForBit(bit)));
                return List.of();
            }
            for (BitSet splitChunks : BitSetUtil.half(this.set)) {
                payloads.addAll(new S2CUpdateRegionPacket(this.shared, this.regionPos, this.biomePalette, this.blockPalette, splitChunks, ListUtil.splitSet(this.chunks, splitChunks, this.set)).toPayloads());
            }
        }
        return payloads;
    }

    public class_8710.class_9154<S2CUpdateRegionPacket> method_56479() {
        return ID;
    }
}

