/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.terrain;

import folk.sisby.surveyor.Surveyor;
import folk.sisby.surveyor.SurveyorEvents;
import folk.sisby.surveyor.SurveyorExploration;
import folk.sisby.surveyor.WorldSummary;
import folk.sisby.surveyor.config.SystemMode;
import folk.sisby.surveyor.terrain.ChunkSummary;
import folk.sisby.surveyor.terrain.RegionSummary;
import folk.sisby.surveyor.util.ChunkUtil;
import folk.sisby.surveyor.util.RegistryPalette;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_2791;
import net.minecraft.class_2818;
import net.minecraft.class_5321;
import net.minecraft.class_5455;

public class WorldTerrainSummary {
    protected final class_5321<class_1937> worldKey;
    protected final class_5455 registryManager;
    protected final Map<class_1923, RegionSummary> regions = new ConcurrentHashMap<class_1923, RegionSummary>();

    public WorldTerrainSummary(class_5321<class_1937> worldKey, class_5455 registryManager, Map<class_1923, RegionSummary> regions) {
        this.worldKey = worldKey;
        this.registryManager = registryManager;
        this.regions.putAll(regions);
    }

    protected static class_1923 regionPosOf(class_1923 pos) {
        return new class_1923(pos.field_9181 >> 5, pos.field_9180 >> 5);
    }

    public static Set<class_1923> toKeys(Map<class_1923, BitSet> bitSets) {
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingInt(pos -> pos.field_9181 + pos.field_9180));
    }

    public static Set<class_1923> toKeys(Map<class_1923, BitSet> bitSets, class_1923 originChunk) {
        class_1923 oPos = new class_1923(RegionSummary.chunkToRegion(originChunk.field_9181), RegionSummary.chunkToRegion(originChunk.field_9180));
        return WorldTerrainSummary.toKeys(bitSets, Comparator.comparingDouble(pos -> (oPos.field_9181 - pos.field_9181) * (oPos.field_9181 - pos.field_9181) + (oPos.field_9180 - pos.field_9180) * (oPos.field_9180 - pos.field_9180)));
    }

    public static Set<class_1923> toKeys(Map<class_1923, BitSet> bitSets, Comparator<class_1923> regionComparator) {
        LinkedHashSet<class_1923> set = new LinkedHashSet<class_1923>();
        bitSets.entrySet().stream().sorted(Map.Entry.comparingByKey(regionComparator)).forEach(e -> ((BitSet)e.getValue()).stream().forEach(i -> set.add(RegionSummary.chunkForBit((class_1923)e.getKey(), i))));
        return set;
    }

    public static WorldTerrainSummary load(class_1937 world, File folder) {
        HashMap<class_1923, RegionSummary> regions = new HashMap<class_1923, RegionSummary>();
        ChunkUtil.getRegionNbt(folder, "c").forEach((pos, nbt) -> regions.put((class_1923)pos, RegionSummary.readNbt(nbt, world.method_30349(), pos)));
        return new WorldTerrainSummary((class_5321<class_1937>)world.method_27983(), world.method_30349(), regions);
    }

    public static void onChunkLoad(class_1937 world, class_2818 chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (!(summary.terrain() == null || summary.terrain().contains(chunk.method_12004()) && ChunkUtil.airCount((class_2791)chunk).equals(summary.terrain().get(chunk.method_12004()).getAirCount()))) {
            summary.terrain().put(world, chunk);
        }
    }

    public static void onChunkUnload(class_1937 world, class_2818 chunk) {
        WorldSummary summary = WorldSummary.of(world);
        if (summary.terrain() != null && chunk.method_12044()) {
            summary.terrain().put(world, chunk);
        }
    }

    public boolean contains(class_1923 pos) {
        class_1923 regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.containsKey(regionPos) && this.regions.get(regionPos).contains(pos);
    }

    public ChunkSummary get(class_1923 pos) {
        class_1923 regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.containsKey(regionPos) ? this.regions.get(regionPos).get(pos) : null;
    }

    public RegionSummary getRegion(class_1923 regionPos) {
        return this.regions.computeIfAbsent(regionPos, k -> new RegionSummary(this.registryManager));
    }

    public RegistryPalette.ValueView getBiomePalette(class_1923 pos) {
        class_1923 regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.get(regionPos).getBiomePalette();
    }

    public RegistryPalette.ValueView getBlockPalette(class_1923 pos) {
        class_1923 regionPos = WorldTerrainSummary.regionPosOf(pos);
        return this.regions.get(regionPos).getBlockPalette();
    }

    public Map<class_1923, BitSet> bitSet(SurveyorExploration exploration) {
        HashMap<class_1923, BitSet> map = new HashMap<class_1923, BitSet>();
        this.regions.forEach((p, r) -> map.put((class_1923)p, r.bitSet()));
        return exploration == null ? map : exploration.limitTerrainBitset(this.worldKey, map);
    }

    public void put(class_1937 world, class_2818 chunk) {
        if (Surveyor.CONFIG.terrain == SystemMode.FROZEN) {
            return;
        }
        this.regions.computeIfAbsent(WorldTerrainSummary.regionPosOf(chunk.method_12004()), k -> new RegionSummary(this.registryManager)).putChunk(world, chunk);
        SurveyorEvents.Invoke.terrainUpdated(world, chunk.method_12004());
    }

    public int save(class_1937 world, File folder) {
        ArrayList savedRegions = new ArrayList();
        this.regions.forEach((pos, summary) -> {
            if (!summary.isDirty()) {
                return;
            }
            savedRegions.add(pos);
            class_2487 regionCompound = summary.writeNbt(world.method_30349(), new class_2487(), (class_1923)pos);
            File regionFile = new File(folder, "c.%d.%d.dat".formatted(pos.field_9181, pos.field_9180));
            try {
                class_2507.method_30614((class_2487)regionCompound, (Path)regionFile.toPath());
                summary.dirty = false;
            }
            catch (IOException e) {
                Surveyor.LOGGER.error("[Surveyor] Error writing region summary file {}.", (Object)regionFile.getName(), (Object)e);
            }
        });
        return savedRegions.size();
    }

    public boolean isDirty() {
        return this.regions.values().stream().anyMatch(RegionSummary::isDirty);
    }
}

