/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.surveyor.util;

import folk.sisby.surveyor.Surveyor;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1923;
import net.minecraft.class_2487;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2791;

public class ChunkUtil {
    public static Integer airCount(class_2791 chunk) {
        return Arrays.stream(chunk.method_12006()).mapToInt(s -> 4096 - s.field_12877).sum();
    }

    public static File[] getRegionFiles(File folder, String prefix) {
        return folder.listFiles((file, name) -> {
            String[] split = name.split("\\.");
            if (split.length == 4 && split[0].equals(prefix) && split[3].equals("dat")) {
                try {
                    Integer.parseInt(split[1]);
                    Integer.parseInt(split[2]);
                    return true;
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            return false;
        });
    }

    public static Map<class_1923, class_2487> getRegionNbt(File folder, String prefix) {
        File[] regionFiles = ChunkUtil.getRegionFiles(folder, prefix);
        HashMap<class_1923, class_2487> regions = new HashMap<class_1923, class_2487>();
        if (regionFiles != null) {
            for (File regionFile : regionFiles) {
                class_1923 regionPos = new class_1923(Integer.parseInt(regionFile.getName().split("\\.")[1]), Integer.parseInt(regionFile.getName().split("\\.")[2]));
                class_2487 regionCompound = null;
                try {
                    regionCompound = class_2507.method_30613((Path)regionFile.toPath(), (class_2505)class_2505.method_53898());
                }
                catch (IOException e) {
                    Surveyor.LOGGER.error("[Surveyor] Error loading region nbt file {}.", (Object)regionFile.getName(), (Object)e);
                }
                if (regionCompound == null) continue;
                regions.put(regionPos, regionCompound);
            }
        }
        return regions;
    }
}

