/*
 * Decompiled with CFR 0.152.
 */
package com.github.QPCrummer.slumber;

import com.github.QPCrummer.slumber.SlumberCommand;
import com.github.QPCrummer.slumber.TickManagerInterface;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.util.Objects;
import java.util.Properties;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_8915;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Slumber
implements ModInitializer {
    static final String CONFIG_VERSION_KEY = "config-version";
    static final String TOGGLE_KEY = "toggle";
    static final String FREEZE_DELAY_SECONDS_KEY = "freeze-delay-seconds";
    static final String SAFE_STARTING_KEY = "safe-starting";
    static final String DEBUG_KEY = "debug-messages";
    private static final Path config = FabricLoader.getInstance().getConfigDir().resolve("slumber.properties");
    public static final Properties properties = new Properties();
    public static final String cfgver = "1.3";
    public static int delay;
    public static boolean enabled;
    public static boolean safe_starting;
    public static boolean debug;
    private static long beginningTime;
    private static long endingTime;
    private static final ScheduledExecutorService wait;
    private static volatile ScheduledFuture<?> task;
    private static final Logger logger;

    public void onInitialize() {
        if (Files.notExists(config, new LinkOption[0])) {
            try {
                Slumber.storecfg();
            }
            catch (IOException e) {
                logger.error("Config storing failed", (Throwable)e);
            }
        } else {
            try {
                Slumber.loadcfg();
            }
            catch (IOException e) {
                logger.error("Config creation failed", (Throwable)e);
            }
            if (!Objects.equals(properties.getProperty(CONFIG_VERSION_KEY), cfgver)) {
                properties.setProperty(CONFIG_VERSION_KEY, cfgver);
                try {
                    Slumber.storecfg();
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            } else {
                Slumber.parse();
            }
        }
        SlumberCommand.register();
        ServerLifecycleEvents.SERVER_STARTING.register(server -> {
            if (safe_starting) {
                ((TickManagerInterface)server.method_54833()).setFrozenNoPacket(true);
                Slumber.calculateTimeElapsed(true);
                Slumber.sendToDebugLogger("Safe Starting Active");
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            ((TickManagerInterface)server.method_54833()).setFrozenNoPacket(enabled);
            Slumber.calculateTimeElapsed(enabled);
            Slumber.sendToDebugLogger("Safe Starting Finished; Continued Freeze: " + enabled);
        });
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            if (enabled) {
                ScheduledFuture<?> future = task;
                if (future != null && !future.isDone()) {
                    future.cancel(false);
                }
                Slumber.freeze(false, server);
            }
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            if (enabled && server.method_3788() <= 1) {
                task = wait.schedule(() -> {
                    if (server.method_3788() == 0) {
                        server.execute(() -> Slumber.freeze(true, server));
                    }
                }, (long)delay, TimeUnit.SECONDS);
            }
        });
    }

    public static void storecfg() throws IOException {
        try (OutputStream output = Files.newOutputStream(config, StandardOpenOption.CREATE);){
            Slumber.fillDefaults();
            properties.store(output, null);
        }
        Slumber.parse();
    }

    private static void fillDefaults() {
        if (!properties.containsKey(CONFIG_VERSION_KEY)) {
            properties.setProperty(CONFIG_VERSION_KEY, cfgver);
        }
        if (!properties.containsKey(SAFE_STARTING_KEY)) {
            properties.setProperty(SAFE_STARTING_KEY, "true");
        }
        if (!properties.containsKey(FREEZE_DELAY_SECONDS_KEY)) {
            properties.setProperty(FREEZE_DELAY_SECONDS_KEY, "20");
        }
        if (!properties.containsKey(TOGGLE_KEY)) {
            properties.setProperty(TOGGLE_KEY, "true");
        }
        if (!properties.containsKey(DEBUG_KEY)) {
            properties.setProperty(DEBUG_KEY, "false");
        }
    }

    public static void loadcfg() throws IOException {
        try (InputStream input = Files.newInputStream(config, new OpenOption[0]);){
            properties.load(input);
        }
    }

    public static void parse() {
        Slumber.fillDefaults();
        delay = Integer.parseInt(properties.getProperty(FREEZE_DELAY_SECONDS_KEY));
        enabled = Boolean.parseBoolean(properties.getProperty(TOGGLE_KEY));
        safe_starting = Boolean.parseBoolean(properties.getProperty(SAFE_STARTING_KEY));
        debug = Boolean.parseBoolean(properties.getProperty(DEBUG_KEY));
    }

    public static void freeze(boolean frozen, MinecraftServer server) {
        class_8915 tickManager = server.method_54833();
        Slumber.sendToDebugLogger("Enabled:" + enabled + ", Game is Frozen: " + tickManager.method_54754() + ", Trying to Freeze: " + frozen);
        if (enabled || tickManager.method_54754() != frozen) {
            ((TickManagerInterface)tickManager).setFrozenNoPacket(frozen);
            Slumber.calculateTimeElapsed(frozen);
            Slumber.sendToDebugLogger("Frozen: " + frozen);
        }
    }

    public static void sendToDebugLogger(String message) {
        if (debug) {
            logger.info(message);
        }
    }

    private static void calculateTimeElapsed(boolean frozen) {
        if (debug) {
            if (frozen && beginningTime == 0L) {
                beginningTime = System.currentTimeMillis();
            } else if (!frozen && beginningTime != 0L && endingTime == 0L) {
                endingTime = System.currentTimeMillis();
            }
            if (endingTime != 0L) {
                int timeElapsed = (int)((endingTime - beginningTime) / 1000L);
                Slumber.sendToDebugLogger("Unfroze after " + timeElapsed + " seconds");
                beginningTime = 0L;
                endingTime = 0L;
            }
        }
    }

    static {
        wait = Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setDaemon(true).build());
        logger = LogManager.getLogger((String)"Slumber");
    }
}

