/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.overpoweredmending.forge;

import fr.rakambda.overpoweredmending.common.inventory.IInventoryProvider;
import fr.rakambda.overpoweredmending.forge.common.OverpoweredMendingImpl;
import fr.rakambda.overpoweredmending.forge.inventory.CuriosInventoryProvider;
import java.lang.reflect.InvocationTargetException;
import java.util.Optional;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Mod(value="overpoweredmending")
public class OverpoweredMending {
    private static final Logger log = LogManager.getLogger(OverpoweredMending.class);
    public static final String MOD_ID = "overpoweredmending";
    private static final OverpoweredMendingImpl mod = new OverpoweredMendingImpl();

    public OverpoweredMending() {
        this.initCurios().ifPresent(mod::addInventoryProvider);
        mod.registerForge(MinecraftForge.EVENT_BUS);
    }

    @NotNull
    private Optional<IInventoryProvider> initCurios() {
        if (ModList.get().isLoaded("curios")) {
            try {
                return Optional.of((IInventoryProvider)Class.forName("fr.rakambda.overpoweredmending.forge.inventory.CuriosInventoryProvider").asSubclass(CuriosInventoryProvider.class).getConstructor(new Class[0]).newInstance(new Object[0]));
            }
            catch (ClassNotFoundException | IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                log.error("Failed to hook into Curios", (Throwable)e);
            }
        }
        return Optional.empty();
    }

    public static OverpoweredMendingImpl getMod() {
        return mod;
    }
}

