/*
 * Decompiled with CFR 0.152.
 */
package fr.rakambda.overpoweredmending.forge.wrapper;

import fr.rakambda.overpoweredmending.common.wrapper.IItemStack;
import fr.rakambda.overpoweredmending.common.wrapper.IPlayer;
import fr.rakambda.overpoweredmending.common.wrapper.IXpOrb;
import fr.rakambda.overpoweredmending.forge.wrapper.ItemStackWrapper;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import org.jetbrains.annotations.NotNull;

public class PlayerWrapper
implements IPlayer {
    @NotNull
    private final Player raw;

    @Override
    @NotNull
    public Stream<IItemStack> streamInventory() {
        Inventory playerInventory = this.raw.getInventory();
        return IntStream.range(0, playerInventory.getContainerSize()).mapToObj(arg_0 -> ((Inventory)playerInventory).getItem(arg_0)).map(ItemStackWrapper::new);
    }

    @Override
    public void addExperience(int amount) {
        this.raw.giveExperiencePoints(amount);
    }

    @Override
    public void sendPickup(@NotNull IXpOrb xp, int count) {
        this.raw.take((Entity)xp.getRaw(), count);
    }

    @Override
    public void setExperiencePickUpDelay(int delay) {
        this.raw.takeXpDelay = delay;
    }

    public PlayerWrapper(@NotNull Player raw) {
        if (raw == null) {
            throw new NullPointerException("raw is marked non-null but is null");
        }
        this.raw = raw;
    }

    public String toString() {
        return "PlayerWrapper(raw=" + String.valueOf(this.getRaw()) + ")";
    }

    @NotNull
    public Player getRaw() {
        return this.raw;
    }
}

