/*
 * Decompiled with CFR 0.152.
 */
package ewewukek.musketmod;

import ewewukek.musketmod.Config;
import ewewukek.musketmod.GunItem;
import ewewukek.musketmod.Items;
import ewewukek.musketmod.MusketMod;
import ewewukek.musketmod.ScopedMusketItem;
import ewewukek.musketmod.SmokeEffectPacket;
import net.minecraft.class_1268;
import net.minecraft.class_1306;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1604;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3417;
import net.minecraft.class_3532;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_5272;
import net.minecraft.class_572;
import net.minecraft.class_630;
import net.minecraft.class_638;
import net.minecraft.class_6395;
import net.minecraft.class_742;
import net.minecraft.class_759;
import net.minecraft.class_7833;
import net.minecraft.class_811;
import org.apache.commons.lang3.tuple.Pair;

public class ClientUtilities {
    public static boolean canUseScope;
    public static boolean attackKeyDown;
    public static boolean preventFiring;
    public static boolean disableMainHandEquipAnimation;
    public static boolean disableOffhandEquipAnimation;

    public static void registerItemProperties() {
        ClientUtilities.registerItemPredicate(MusketMod.resource("loaded"), (stack, level, entity, seed) -> GunItem.isLoaded(stack) ? 1.0f : 0.0f);
        ClientUtilities.registerItemPredicate(MusketMod.resource("loading"), (stack, level, entity, seed) -> entity != null && entity.method_6115() && entity.method_5998(entity.method_6058()) == stack ? 1.0f : 0.0f);
        ClientUtilities.registerItemPredicate(MusketMod.resource("aiming"), (stack, level, entity, seed) -> entity != null && ClientUtilities.shouldAim(entity, stack) ? 1.0f : 0.0f);
    }

    public static void registerItemPredicate(class_2960 location, class_6395 predicate) {
        class_5272.method_27879((class_1792)Items.MUSKET, (class_2960)location, (class_6395)predicate);
        class_5272.method_27879((class_1792)Items.MUSKET_WITH_BAYONET, (class_2960)location, (class_6395)predicate);
        class_5272.method_27879((class_1792)Items.MUSKET_WITH_SCOPE, (class_2960)location, (class_6395)predicate);
        class_5272.method_27879((class_1792)Items.BLUNDERBUSS, (class_2960)location, (class_6395)predicate);
        class_5272.method_27879((class_1792)Items.PISTOL, (class_2960)location, (class_6395)predicate);
    }

    public static void handleSmokeEffectPacket(SmokeEffectPacket packet) {
        class_310 instance = class_310.method_1551();
        class_638 level = instance.field_1687;
        class_243 origin = new class_243(packet.origin());
        class_243 direction = new class_243(packet.direction());
        GunItem.fireParticles((class_1937)level, origin, direction);
    }

    public static void setScoping(class_1657 player, boolean scoping) {
        if (scoping != ScopedMusketItem.isScoping) {
            player.method_5783(scoping ? class_3417.field_26972 : class_3417.field_26973, 1.0f, 1.0f);
            ScopedMusketItem.isScoping = scoping;
        }
        if (!scoping) {
            ScopedMusketItem.recoilTicks = 0;
        }
    }

    public static boolean poseArm(class_1309 entity, class_572<? extends class_1309> model, class_630 arm) {
        class_1308 mob;
        if (entity.method_6115() || entity instanceof class_1308 && !(mob = (class_1308)entity).method_6510()) {
            return false;
        }
        boolean isRight = arm == model.field_3401;
        class_1268 hand = entity.method_6068() == (isRight ? class_1306.field_6183 : class_1306.field_6182) ? class_1268.field_5808 : class_1268.field_5810;
        class_1799 stack = entity.method_5998(hand);
        if (stack.method_7909() instanceof GunItem && ClientUtilities.shouldAim(entity, stack, hand)) {
            arm.field_3654 = model.field_3398.field_3654 + 0.1f - 1.5707964f;
            if (model.field_3400) {
                arm.field_3654 -= 0.4f;
            }
            arm.field_3675 = model.field_3398.field_3675 + (isRight ? -0.3f : 0.3f);
            return true;
        }
        class_1268 hand2 = hand == class_1268.field_5808 ? class_1268.field_5810 : class_1268.field_5808;
        class_1799 stack2 = entity.method_5998(hand2);
        class_1792 class_17922 = stack2.method_7909();
        if (class_17922 instanceof GunItem) {
            GunItem gun2 = (GunItem)class_17922;
            if (ClientUtilities.shouldAim(entity, stack2, hand2) && (gun2.twoHanded() || stack == class_1799.field_8037)) {
                arm.field_3654 = model.field_3398.field_3654 - 1.5f;
                if (model.field_3400) {
                    arm.field_3654 -= 0.4f;
                }
                arm.field_3675 = model.field_3398.field_3675 + (isRight ? -0.6f : 0.6f);
                return true;
            }
        }
        return false;
    }

    public static boolean shouldAim(class_1309 entity, class_1799 stack, class_1268 hand) {
        if (entity.method_6115()) {
            return false;
        }
        if (entity instanceof class_1308) {
            class_1308 mob = (class_1308)entity;
            return mob.method_6510() || mob instanceof class_1604;
        }
        return ((GunItem)stack.method_7909()).canUseFrom(entity, hand) && (GunItem.isLoaded(stack) || Config.alwaysAim);
    }

    public static boolean shouldAim(class_1309 entity, class_1799 stack) {
        class_1268 hand = stack == entity.method_6047() ? class_1268.field_5808 : class_1268.field_5810;
        return ClientUtilities.shouldAim(entity, stack, hand);
    }

    public static void renderGunInHand(class_759 renderer, class_742 player, class_1268 hand, float dt, float pitch, float swingProgress, float equipProgress, class_1799 stack, class_4587 poseStack, class_4597 bufferSource, int light) {
        if (player.method_31550()) {
            return;
        }
        class_1306 arm = hand == class_1268.field_5808 ? player.method_6068() : player.method_6068().method_5928();
        boolean isRightHand = arm == class_1306.field_6183;
        float sign = isRightHand ? 1.0f : -1.0f;
        GunItem gun = (GunItem)stack.method_7909();
        if (!gun.canUseFrom((class_1309)player, hand)) {
            poseStack.method_22903();
            poseStack.method_22904((double)sign * 0.5, -0.5 - 0.6 * (double)equipProgress, -0.7);
            poseStack.method_22907(class_7833.field_40714.rotationDegrees(70.0f));
            renderer.method_3233((class_1309)player, stack, isRightHand ? class_811.field_4322 : class_811.field_4321, !isRightHand, poseStack, bufferSource, light);
            poseStack.method_22909();
            return;
        }
        class_1799 activeStack = GunItem.getActiveStack(hand);
        if (stack == activeStack) {
            ClientUtilities.setEquipAnimationDisabled(hand, true);
        } else if (activeStack != null && activeStack.method_7909() != gun) {
            ClientUtilities.setEquipAnimationDisabled(hand, false);
        }
        poseStack.method_22903();
        poseStack.method_22904((double)sign * 0.15, -0.25, -0.35);
        if (swingProgress > 0.0f) {
            float swingSharp = class_3532.method_15374((float)(class_3532.method_15355((float)swingProgress) * (float)Math.PI));
            float swingNormal = class_3532.method_15374((float)(swingProgress * (float)Math.PI));
            if (gun == Items.MUSKET_WITH_BAYONET) {
                poseStack.method_22904((double)sign * -0.05 * (double)swingNormal, 0.0, 0.05 - 0.3 * (double)swingSharp);
                poseStack.method_22907(class_7833.field_40716.rotationDegrees(5.0f * swingSharp));
            } else {
                poseStack.method_22904((double)sign * 0.05 * (double)(1.0f - swingNormal), 0.05 * (double)(1.0f - swingNormal), 0.05 - 0.4 * (double)swingSharp);
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(180.0f + sign * 20.0f * (1.0f - swingSharp)));
            }
        } else if (player.method_6115() && player.method_6058() == hand) {
            Pair<Integer, Integer> loadingDuration = GunItem.getLoadingDuration(stack);
            int loadingStages = (Integer)loadingDuration.getLeft();
            int ticksPerLoadingStage = (Integer)loadingDuration.getRight();
            float usingTicks = (float)player.method_6048() + dt - 1.0f;
            int loadingStage = GunItem.getLoadingStage(stack) + (int)(usingTicks / (float)ticksPerLoadingStage);
            int reloadDuration = GunItem.reloadDuration(stack);
            if (reloadDuration > 0 && usingTicks < (float)(reloadDuration + 5)) {
                poseStack.method_22904(0.0, -0.3, 0.05);
                poseStack.method_22907(class_7833.field_40714.rotationDegrees(60.0f));
                poseStack.method_22907(class_7833.field_40718.rotationDegrees(sign * 10.0f));
                float t = 0.0f;
                if (usingTicks >= (float)ticksPerLoadingStage && loadingStage <= loadingStages && (usingTicks %= (float)ticksPerLoadingStage) < 4.0f) {
                    t = (4.0f - usingTicks) / 4.0f;
                }
                if (usingTicks >= (float)(ticksPerLoadingStage - 2) && loadingStage < loadingStages) {
                    t = (usingTicks - (float)ticksPerLoadingStage + 2.0f) / 2.0f;
                    t = class_3532.method_15374((float)(1.5707964f * class_3532.method_15355((float)t)));
                }
                poseStack.method_22904(0.0, 0.0, 0.025 * (double)t);
                if (gun == Items.BLUNDERBUSS) {
                    poseStack.method_22904(0.0, 0.0, -0.06);
                } else if (gun == Items.PISTOL) {
                    poseStack.method_22904(0.0, 0.0, -0.12);
                }
            }
        } else if (ClientUtilities.isEquipAnimationDisabled(hand)) {
            if (equipProgress == 0.0f) {
                ClientUtilities.setEquipAnimationDisabled(hand, false);
                GunItem.setActiveStack(hand, null);
            }
        } else {
            poseStack.method_22904(0.0, -0.6 * (double)equipProgress, 0.0);
        }
        renderer.method_3233((class_1309)player, stack, isRightHand ? class_811.field_4322 : class_811.field_4321, !isRightHand, poseStack, bufferSource, light);
        poseStack.method_22909();
    }

    public static boolean isEquipAnimationDisabled(class_1268 hand) {
        if (hand == class_1268.field_5808) {
            return disableMainHandEquipAnimation;
        }
        return disableOffhandEquipAnimation;
    }

    public static void setEquipAnimationDisabled(class_1268 hand, boolean disabled) {
        if (hand == class_1268.field_5808) {
            disableMainHandEquipAnimation = disabled;
        } else {
            disableOffhandEquipAnimation = disabled;
        }
    }
}

