/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.inventory_tabs;

import folk.sisby.inventory_tabs.ControlHintToast;
import folk.sisby.inventory_tabs.InventoryTabs;
import folk.sisby.inventory_tabs.TabProviders;
import folk.sisby.inventory_tabs.duck.InventoryTabsScreen;
import folk.sisby.inventory_tabs.tabs.BlockTab;
import folk.sisby.inventory_tabs.tabs.EntityTab;
import folk.sisby.inventory_tabs.tabs.ItemTab;
import folk.sisby.inventory_tabs.tabs.PlayerInventoryTab;
import folk.sisby.inventory_tabs.tabs.Tab;
import folk.sisby.inventory_tabs.tabs.VehicleInventoryTab;
import folk.sisby.inventory_tabs.util.HandlerSlotUtil;
import folk.sisby.inventory_tabs.util.RaycastCache;
import folk.sisby.inventory_tabs.util.WidgetPosition;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.BiFunction;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1703;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2596;
import net.minecraft.class_2815;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_368;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_490;
import net.minecraft.class_634;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;
import net.minecraft.class_768;

public class TabManager {
    public static final class_2960 BUTTONS_TEXTURE = InventoryTabs.id("textures/gui/buttons.png");
    public static final int TAB_WIDTH = 24;
    public static final int TAB_HEIGHT = 21;
    public static final int BUTTON_WIDTH = 10;
    public static final int BUTTON_HEIGHT = 18;
    public static final Map<class_2960, BiFunction<class_465<?>, List<Tab>, Tab>> tabGuessers = new HashMap();
    public static Tab nextTab;
    public static class_465<?> currentScreen;
    public static final List<Tab> tabs;
    public static int currentPage;
    public static Tab currentTab;
    public static List<WidgetPosition> tabPositions;
    public static int holdTabCooldown;
    public static boolean enabled;
    public static Map<class_2338, RaycastCache> blockRaycastCache;

    public static void initScreen(class_310 client, class_465<?> screen) {
        currentScreen = screen;
        tabPositions = ((InventoryTabsScreen)currentScreen).getTabPositions(24);
        if (nextTab == null) {
            nextTab = TabManager.guessOpenedTab(client, screen);
            TabManager.finishOpeningScreen(screen.method_17577());
        }
    }

    public static void finishOpeningScreen(class_1703 handler) {
        if (nextTab != null) {
            if (currentTab != null && currentTab != nextTab) {
                currentTab.close(class_310.method_1551().field_1724, class_310.method_1551().field_1687, handler, class_310.method_1551().field_1761);
            }
            HandlerSlotUtil.tryPop(class_310.method_1551().field_1724, class_310.method_1551().field_1761, handler);
            currentTab = nextTab;
            TabManager.setCurrentPage(tabPositions.isEmpty() ? 0 : tabs.indexOf(nextTab) / tabPositions.size());
            nextTab = null;
        }
    }

    public static void screenDiscarded() {
        if (currentTab != null) {
            currentTab.close(class_310.method_1551().field_1724, class_310.method_1551().field_1687, class_310.method_1551().field_1724 != null ? class_310.method_1551().field_1724.field_7512 : null, class_310.method_1551().field_1761);
            currentTab = null;
        }
        nextTab = null;
        currentPage = 0;
    }

    public static void tick(class_638 world) {
        blockRaycastCache.values().removeIf(timer -> !timer.validThisTick && timer.ticksInvalid >= InventoryTabs.CONFIG.blockRaycastTimeout);
        blockRaycastCache.values().forEach(RaycastCache::tick);
        if (holdTabCooldown > 0) {
            holdTabCooldown = InventoryTabs.NEXT_TAB.method_1434() ? --holdTabCooldown : 0;
        }
        if (tabs.removeIf(t -> t.shouldBeRemoved((class_1937)world, t == currentTab))) {
            TabManager.sortTabs();
        }
        TabProviders.REGISTRY.values().forEach(tabProvider -> tabProvider.addAvailableTabs(class_310.method_1551().field_1724, TabManager::tryAddTab));
        if (currentTab != null && !tabs.contains(currentTab)) {
            currentTab = null;
        }
    }

    public static void openTabImmediate(Tab tab, class_746 player, class_636 interactionManager, class_638 world) {
        nextTab = tab;
        HandlerSlotUtil.push(player, class_310.method_1551().field_1761, currentScreen.method_17577(), tab.isInstant());
        player.field_3944.method_52787((class_2596)new class_2815(TabManager.currentScreen.method_17577().field_7763));
        tab.open(player, world, currentScreen.method_17577(), interactionManager);
        if (tab.isInstant()) {
            TabManager.finishOpeningScreen(currentScreen.method_17577());
        }
    }

    public static void openTab(Tab tab) {
        if (tab != currentTab) {
            class_638 world;
            class_1937 class_19372;
            class_746 player = class_310.method_1551().field_1724;
            class_636 interactionManager = class_310.method_1551().field_1761;
            class_634 networkHandler = class_310.method_1551().method_1562();
            if (player != null && interactionManager != null && networkHandler != null && (class_19372 = player.method_37908()) instanceof class_638 && !tab.shouldBeRemoved((class_1937)(world = (class_638)class_19372), false)) {
                if (tab.isBuffered()) {
                    TabManager.openTabImmediate(new PlayerInventoryTab(), player, interactionManager, world);
                }
                TabManager.openTabImmediate(tab, player, interactionManager, world);
            }
        }
    }

    public static Tab guessOpenedTab(class_310 client, class_465<?> screen) {
        Object guessedTab;
        class_1937 world = client.field_1724.method_37908();
        if (currentScreen instanceof class_490) {
            return tabs.get(0);
        }
        if (client.field_1724.method_5765()) {
            for (Tab tab : tabs) {
                if (!(tab instanceof VehicleInventoryTab)) continue;
                VehicleInventoryTab vit = (VehicleInventoryTab)tab;
                if (!client.field_1724.method_5854().equals((Object)vit.entity)) continue;
                return tab;
            }
        }
        for (BiFunction biFunction : tabGuessers.values()) {
            guessedTab = (Tab)biFunction.apply(screen, tabs);
            if (guessedTab == null) continue;
            return guessedTab;
        }
        guessedTab = client.field_1765;
        if (guessedTab instanceof class_3965) {
            class_3965 result = (class_3965)guessedTab;
            pos = result.method_17777();
            class_2586 blockEntity = world.method_8321((class_2338)pos);
            for (Tab tab : tabs) {
                if (!(tab instanceof BlockTab)) continue;
                BlockTab bt = (BlockTab)tab;
                if (!pos.equals((Object)bt.pos) && blockEntity != world.method_8321(bt.pos) && !bt.multiblockPositions.contains(pos)) continue;
                return tab;
            }
        } else {
            pos = client.field_1765;
            if (pos instanceof class_3966) {
                class_3966 class_39662 = (class_3966)pos;
                class_1297 entity = class_39662.method_17782();
                for (Tab tab : tabs) {
                    if (!(tab instanceof EntityTab)) continue;
                    EntityTab et = (EntityTab)tab;
                    if (!entity.equals((Object)et.entity)) continue;
                    return tab;
                }
            }
        }
        Iterator<Object> iterator = List.of(Integer.valueOf(client.field_1724.method_31548().field_7545), Integer.valueOf(40)).iterator();
        while (iterator.hasNext()) {
            int n = (Integer)iterator.next();
            for (Tab tab : tabs) {
                if (!(tab instanceof ItemTab)) continue;
                ItemTab it = (ItemTab)tab;
                if (n != it.slot) continue;
                return tab;
            }
        }
        return null;
    }

    public static void tryAddTab(Tab tab) {
        if (!tabs.contains(tab)) {
            tabs.add(tab);
            TabManager.sortTabs();
        }
    }

    public static void sortTabs() {
        tabs.sort(Comparator.comparingInt(Tab::getPriority).reversed().thenComparing(t -> t.getHoverText().getString()));
    }

    public static void clearTabs() {
        tabs.clear();
    }

    public static boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (TabManager.isLocked()) {
            return true;
        }
        if (TabManager.isHidden()) {
            return false;
        }
        if (button == 0) {
            if (TabManager.getPageButton(true).method_3318((int)mouseX, (int)mouseY)) {
                if (currentPage > 0) {
                    TabManager.setCurrentPage(currentPage - 1);
                    TabManager.playClick();
                }
                return true;
            }
            if (TabManager.getPageButton(false).method_3318((int)mouseX, (int)mouseY)) {
                if (currentPage < TabManager.getMaximumPage()) {
                    TabManager.setCurrentPage(currentPage + 1);
                    TabManager.playClick();
                }
                return true;
            }
            for (int i = 0; i < Math.min(tabPositions.size(), tabs.size() - currentPage * tabPositions.size()); ++i) {
                WidgetPosition pos = tabPositions.get(i);
                Tab tab = tabs.get(currentPage * tabPositions.size() + i);
                if (pos == null || tab == null || tab == currentTab || !TabManager.getTabArea(pos).method_3318((int)mouseX, (int)mouseY)) continue;
                TabManager.openTab(tab);
                TabManager.playClick();
                return true;
            }
        }
        return false;
    }

    public static boolean mouseReleased(double mouseX, double mouseY, int button) {
        return TabManager.isLocked();
    }

    public static boolean isClickOutsideBounds(double mouseX, double mouseY) {
        return !TabManager.getPageButton(true).method_3318((int)mouseX, (int)mouseY) && !TabManager.getPageButton(false).method_3318((int)mouseX, (int)mouseY) && tabPositions.stream().noneMatch(pos -> TabManager.getTabArea(pos).method_3318((int)mouseX, (int)mouseY));
    }

    public static boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        if (InventoryTabs.TOGGLE_TABS.method_1417(keyCode, scanCode)) {
            boolean bl = enabled = !enabled;
            if (!enabled) {
                class_310.method_1551().method_1566().method_1999((class_368)new ControlHintToast((class_2561)class_2561.method_43471((String)"toast.inventory_tabs.disabled.title").method_27692(class_124.field_1067), InventoryTabs.TOGGLE_TABS));
            }
        }
        if (TabManager.isHidden() || TabManager.isLocked()) {
            return false;
        }
        if (holdTabCooldown <= 0 && InventoryTabs.NEXT_TAB.method_1417(keyCode, scanCode)) {
            holdTabCooldown = InventoryTabs.CONFIG.holdTabCooldown;
            if (class_437.method_25442()) {
                if (tabs.indexOf(currentTab) == 0) {
                    TabManager.openTab(tabs.get(tabs.size() - 1));
                } else {
                    TabManager.openTab(tabs.get(tabs.indexOf(currentTab) - 1));
                }
            } else if (tabs.indexOf(currentTab) == tabs.size() - 1) {
                TabManager.openTab(tabs.get(0));
            } else {
                TabManager.openTab(tabs.get(tabs.indexOf(currentTab) + 1));
            }
            return true;
        }
        return false;
    }

    public static void setCurrentPage(int page) {
        if (page == 0 || tabs.size() >= tabPositions.size()) {
            currentPage = page;
        }
    }

    public static int getMaximumPage() {
        return tabs.size() / (tabPositions.size() + 1);
    }

    public static void render(class_332 drawContext, double mouseX, double mouseY) {
        if (TabManager.isHidden()) {
            return;
        }
        for (int i = 0; i < Math.min(tabPositions.size(), tabs.size() - currentPage * tabPositions.size()); ++i) {
            WidgetPosition pos = tabPositions.get(i);
            Tab tab = tabs.get(currentPage * tabPositions.size() + i);
            if (pos == null || tab == null) continue;
            tab.render(drawContext, pos, 24, 21, mouseX, mouseY, tab == currentTab);
        }
        if (TabManager.getMaximumPage() > 0) {
            TabManager.drawButton(drawContext, mouseX, mouseY, true);
            TabManager.drawButton(drawContext, mouseX, mouseY, false);
        }
    }

    public static class_768 getPageButton(boolean left) {
        WidgetPosition pos = tabPositions.get(left ? 0 : tabPositions.size() - 1);
        return new class_768(pos.x + (left ? -10 : 24), pos.y - (pos.up ? 18 : 0), 10, 18);
    }

    public static class_768 getTabArea(WidgetPosition pos) {
        return new class_768(pos.x, pos.y + (pos.up ? -21 : 0), 24, 21);
    }

    public static void drawButton(class_332 drawContext, double mouseX, double mouseY, boolean left) {
        class_768 rect = TabManager.getPageButton(left);
        boolean hovered = rect.method_3318((int)mouseX, (int)mouseY);
        boolean active = left ? currentPage > 0 : currentPage < TabManager.getMaximumPage();
        int u = 10 * (left ? 0 : 1);
        int v = 18 * (active ? (hovered ? 2 : 1) : 0);
        drawContext.method_25302(BUTTONS_TEXTURE, rect.method_3321(), rect.method_3322(), u, v, rect.method_3319(), rect.method_3320());
        if (hovered) {
            drawContext.method_51438(class_310.method_1551().field_1772, (class_2561)class_2561.method_43470((String)(currentPage + 1 + "/" + (TabManager.getMaximumPage() + 1))), (int)mouseX, (int)mouseY);
        }
    }

    public static void playClick() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4758((class_3414)((class_3414)class_3417.field_15015.comp_349()), (float)1.0f));
    }

    public static boolean isHidden() {
        return !enabled || currentScreen == null;
    }

    public static boolean isLocked() {
        return nextTab != null;
    }

    static {
        tabs = new ArrayList<Tab>();
        currentPage = 0;
        tabPositions = new ArrayList<WidgetPosition>();
        holdTabCooldown = 0;
        enabled = true;
        blockRaycastCache = new HashMap<class_2338, RaycastCache>();
    }
}

