/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.inventory_tabs;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.HashMultiset;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import folk.sisby.inventory_tabs.InventoryTabs;
import folk.sisby.inventory_tabs.ScreenSupport;
import folk.sisby.inventory_tabs.TabManager;
import folk.sisby.inventory_tabs.providers.BlockTabProvider;
import folk.sisby.inventory_tabs.providers.ChestBlockTabProvider;
import folk.sisby.inventory_tabs.providers.EnderChestTabProvider;
import folk.sisby.inventory_tabs.providers.EntityTabProvider;
import folk.sisby.inventory_tabs.providers.ItemTabProvider;
import folk.sisby.inventory_tabs.providers.PlayerInventoryTabProvider;
import folk.sisby.inventory_tabs.providers.RegistryTabProvider;
import folk.sisby.inventory_tabs.providers.ShulkerBoxTabProvider;
import folk.sisby.inventory_tabs.providers.SimpleBlockTabProvider;
import folk.sisby.inventory_tabs.providers.SimpleEntityTabProvider;
import folk.sisby.inventory_tabs.providers.SimpleItemTabProvider;
import folk.sisby.inventory_tabs.providers.SimpleStorageBlockTabProvider;
import folk.sisby.inventory_tabs.providers.SneakEntityTabProvider;
import folk.sisby.inventory_tabs.providers.SneakItemTabProvider;
import folk.sisby.inventory_tabs.providers.TabProvider;
import folk.sisby.inventory_tabs.providers.UniqueBlockTabProvider;
import folk.sisby.inventory_tabs.providers.UniqueItemTabProvider;
import folk.sisby.inventory_tabs.providers.VehicleInventoryTabProvider;
import folk.sisby.inventory_tabs.util.RegistryMatcher;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.class_1299;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7871;
import net.minecraft.class_7924;

public class TabProviders {
    public static final BiMap<class_2960, TabProvider> REGISTRY = HashBiMap.create();
    public static final ShulkerBoxTabProvider BLOCK_SHULKER_BOX = TabProviders.register(InventoryTabs.id("block_shulker_box"), new ShulkerBoxTabProvider());
    public static final EnderChestTabProvider BLOCK_ENDER_CHEST = TabProviders.register(InventoryTabs.id("block_ender_chest"), new EnderChestTabProvider());
    public static final ChestBlockTabProvider BLOCK_CHEST = TabProviders.register(InventoryTabs.id("block_chest"), new ChestBlockTabProvider());
    public static final UniqueBlockTabProvider BLOCK_UNIQUE = TabProviders.register(InventoryTabs.id("block_unique"), new UniqueBlockTabProvider());
    public static final SimpleStorageBlockTabProvider BLOCK_SIMPLE_CONTAINER = TabProviders.register(InventoryTabs.id("block_simple_storage"), new SimpleStorageBlockTabProvider());
    public static final SimpleBlockTabProvider BLOCK_SIMPLE = TabProviders.register(InventoryTabs.id("block_simple"), new SimpleBlockTabProvider());
    public static final SneakEntityTabProvider ENTITY_SNEAK = TabProviders.register(InventoryTabs.id("entity_sneak"), new SneakEntityTabProvider());
    public static final SimpleEntityTabProvider ENTITY_SIMPLE = TabProviders.register(InventoryTabs.id("entity_simple"), new SimpleEntityTabProvider());
    public static final ItemTabProvider ITEM_UNIQUE = TabProviders.register(InventoryTabs.id("item_unique"), new UniqueItemTabProvider());
    public static final ItemTabProvider ITEM_SNEAK = TabProviders.register(InventoryTabs.id("item_sneak"), new SneakItemTabProvider());
    public static final ItemTabProvider ITEM_SIMPLE = TabProviders.register(InventoryTabs.id("item_simple"), new SimpleItemTabProvider());
    public static final PlayerInventoryTabProvider PLAYER_INVENTORY = TabProviders.register(InventoryTabs.id("player_inventory"), new PlayerInventoryTabProvider());
    public static final VehicleInventoryTabProvider VEHICLE_INVENTORY = TabProviders.register(InventoryTabs.id("vehicle_inventory"), new VehicleInventoryTabProvider());
    public static Set<class_1299<?>> warmEntities = new HashSet();

    public static void reload(class_5455 manager) {
        Map<String, List<class_5321>> types;
        InventoryTabs.LOGGER.info("[InventoryTabs] Reloading tab providers.");
        TabProviders.refreshConfigPlaceholders();
        if (InventoryTabs.CONFIG.configLogging && !(types = manager.method_30530(class_7924.field_41207).method_42021().stream().filter(k -> ScreenSupport.allowTabs(k) == null && InventoryTabs.CONFIG.allowScreensByDefault).collect(Collectors.groupingBy(k -> k.method_29177().method_12836()))).isEmpty()) {
            InventoryTabs.LOGGER.warn("[Inventory Tabs] {} Automatically tabbed screen handlers:", (Object)types.values().stream().mapToInt(Collection::size).sum());
            types.forEach((namespace, ids) -> InventoryTabs.LOGGER.info(" | {}: {}", namespace, (Object)ids.stream().map(class_5321::method_29177).map(class_2960::method_12832).collect(Collectors.joining(", "))));
        }
        TabProviders.reloadRegistryProviders(manager, class_7924.field_41254, TabProviders.getProviders(BlockTabProvider.class), InventoryTabs.CONFIG.blockProviderOverrides);
        warmEntities = TabProviders.reloadRegistryProviders(manager, class_7924.field_41266, TabProviders.getProviders(EntityTabProvider.class), InventoryTabs.CONFIG.entityProviderOverrides);
        TabProviders.reloadRegistryProviders(manager, class_7924.field_41197, TabProviders.getProviders(ItemTabProvider.class), InventoryTabs.CONFIG.itemProviderOverrides);
        TabManager.clearTabs();
        InventoryTabs.LOGGER.info("[InventoryTabs] Finished reloading tab providers.");
    }

    public static <T extends RegistryTabProvider<?>> Map<class_2960, T> getProviders(Class<T> clazz) {
        return REGISTRY.values().stream().filter(p -> clazz.isAssignableFrom(p.getClass())).sorted(Comparator.comparingInt(p -> ((RegistryTabProvider)p).getRegistryPriority()).reversed()).collect(Collectors.toMap(p -> (class_2960)REGISTRY.inverse().get(p), p -> (RegistryTabProvider)p, (a, b) -> b, LinkedHashMap::new));
    }

    public static <T> Set<T> reloadRegistryProviders(class_5455 manager, class_5321<class_2378<T>> registryKey, Map<class_2960, ? extends RegistryTabProvider<T>> providers, Map<String, String> overrideConfig) {
        HashSet warmValues = new HashSet();
        HashSet<String> valueNamespaces = new HashSet<String>();
        HashMultiset tagSizes = HashMultiset.create();
        HashMap tagProviders = new HashMap();
        HashMultimap providerTags = HashMultimap.create();
        HashMultimap providerValues = HashMultimap.create();
        providers.values().forEach(p -> p.values.clear());
        HashMap<RegistryMatcher<T>, RegistryTabProvider<T>> unsortedOverrides = new HashMap<RegistryMatcher<T>, RegistryTabProvider<T>>();
        for (Map.Entry<String, String> override : overrideConfig.entrySet()) {
            RegistryMatcher<T> registryMatcher = RegistryMatcher.fromRegistryString(manager, registryKey, override.getKey());
            if (registryMatcher == null) {
                InventoryTabs.LOGGER.warn("[Inventory Tabs] Unknown override registry value ID {}, skipping...", (Object)override.getKey());
                continue;
            }
            if (override.getValue().isEmpty()) {
                unsortedOverrides.put(registryMatcher, null);
                continue;
            }
            if (class_2960.method_12829((String)override.getValue()) == null || providers.get(class_2960.method_12829((String)override.getValue())) == null) {
                InventoryTabs.LOGGER.warn("[Inventory Tabs] Unknown override tab provider ID {}, skipping...", (Object)override.getValue());
                continue;
            }
            unsortedOverrides.put(registryMatcher, providers.get(class_2960.method_60654((String)override.getValue())));
        }
        LinkedHashMap overrides = new LinkedHashMap();
        unsortedOverrides.entrySet().stream().sorted(Comparator.comparingInt(e -> ((RegistryMatcher)e.getKey()).priority())).forEach(e -> overrides.put((RegistryMatcher)e.getKey(), (RegistryTabProvider)e.getValue()));
        for (Map.Entry entry : manager.method_30530(registryKey).method_29722()) {
            class_6880.class_6883 holder = ((class_7871)manager.method_46758().method_46750(registryKey).orElseThrow()).method_46747((class_5321)entry.getKey());
            Optional<Map.Entry> override = overrides.entrySet().stream().filter(arg_0 -> TabProviders.lambda$reloadRegistryProviders$11((class_6880)holder, arg_0)).findFirst();
            if (override.isPresent()) {
                if (override.get().getValue() == null) continue;
                class_2960 providerId = (class_2960)REGISTRY.inverse().get(override.get().getValue());
                if (InventoryTabs.CONFIG.configLogging && (InventoryTabs.CONFIG.configLoggingVanilla || !((class_5321)entry.getKey()).method_29177().method_12836().equals("minecraft"))) {
                    holder.method_40228().forEach(arg_0 -> TabProviders.lambda$reloadRegistryProviders$12(tagProviders, providerId, (Multimap)providerTags, arg_0));
                }
                ((RegistryTabProvider)override.get().getValue()).values.add(entry.getValue());
                continue;
            }
            for (Map.Entry<class_2960, RegistryTabProvider<T>> provider2 : providers.entrySet()) {
                if (!InventoryTabs.CONFIG.registryProviderDefaults.getOrDefault(provider2.getKey().toString(), true).booleanValue() || !provider2.getValue().consumes(entry.getValue())) continue;
                if (!InventoryTabs.CONFIG.configLogging || !InventoryTabs.CONFIG.configLoggingVanilla && ((class_5321)entry.getKey()).method_29177().method_12836().equals("minecraft")) break;
                class_2960 providerId = provider2.getKey();
                holder.method_40228().forEach(arg_0 -> TabProviders.lambda$reloadRegistryProviders$13(tagProviders, providerId, (Multiset)tagSizes, (Multimap)providerTags, arg_0));
                providerValues.put((Object)providerId, (Object)((class_5321)entry.getKey()).method_29177());
                valueNamespaces.add(((class_5321)entry.getKey()).method_29177().method_12836());
                break;
            }
            warmValues.add(entry.getValue());
        }
        if (InventoryTabs.CONFIG.configLogging) {
            providerTags.asMap().values().forEach(tags -> tags.removeIf(tag -> !"c".equals(tag.comp_327().method_12836()) && !valueNamespaces.contains(tag.comp_327().method_12836())));
            if (!providerTags.isEmpty()) {
                InventoryTabs.LOGGER.warn("[Inventory Tabs] {} Re-assignable provider tags for {}:", (Object)providerTags.size(), (Object)registryKey.method_29177());
                providerTags.asMap().forEach((arg_0, arg_1) -> TabProviders.lambda$reloadRegistryProviders$19((Multiset)tagSizes, arg_0, arg_1));
            }
            if (!providerValues.isEmpty()) {
                InventoryTabs.LOGGER.warn("[Inventory Tabs] {} Re-assignable provider values for {}:", (Object)providerValues.size(), (Object)registryKey.method_29177());
                providerValues.asMap().forEach((provider, values) -> {
                    if (!values.isEmpty()) {
                        InventoryTabs.LOGGER.info(" | {}", provider);
                        values.stream().collect(Collectors.groupingBy(class_2960::method_12836)).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> InventoryTabs.LOGGER.info(" |  | {} - {}", e.getKey(), (Object)((List)e.getValue()).stream().map(class_2960::method_12832).sorted().collect(Collectors.joining(", "))));
                    }
                });
            }
        }
        return warmValues;
    }

    public static void refreshConfigPlaceholders() {
        HashMap<String, Boolean> tempMap = new HashMap<String, Boolean>(InventoryTabs.CONFIG.registryProviderDefaults);
        InventoryTabs.CONFIG.registryProviderDefaults.clear();
        REGISTRY.keySet().forEach(id -> InventoryTabs.CONFIG.registryProviderDefaults.put(id.toString(), tempMap.getOrDefault(id.toString(), true)));
    }

    public static <T extends TabProvider> T register(class_2960 id, T tabProvider) {
        REGISTRY.put((Object)id, tabProvider);
        return tabProvider;
    }

    private static /* synthetic */ void lambda$reloadRegistryProviders$19(Multiset tagSizes, class_2960 provider, Collection tags) {
        if (!tags.isEmpty()) {
            InventoryTabs.LOGGER.info(" | {}", (Object)provider);
            tags.stream().collect(Collectors.groupingBy(t -> t.comp_327().method_12836())).entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(e -> InventoryTabs.LOGGER.info(" |  | #{} - {}", e.getKey(), (Object)((List)e.getValue()).stream().sorted(Comparator.comparingInt(arg_0 -> ((Multiset)tagSizes).count(arg_0)).reversed()).map(s -> "%s (%s)".formatted(s.comp_327().method_12832(), tagSizes.count(s))).collect(Collectors.joining(", "))));
        }
    }

    private static /* synthetic */ void lambda$reloadRegistryProviders$13(Map tagProviders, class_2960 providerId, Multiset tagSizes, Multimap providerTags, class_6862 tag) {
        if (tagProviders.containsKey(tag) && !providerId.equals(tagProviders.get(tag))) {
            if (tagProviders.get(tag) != null) {
                tagSizes.setCount((Object)tag, 0);
                providerTags.remove(tagProviders.get(tag), (Object)tag);
                tagProviders.put(tag, null);
            }
        } else {
            tagSizes.add((Object)tag);
            providerTags.put((Object)providerId, (Object)tag);
            tagProviders.put(tag, providerId);
        }
    }

    private static /* synthetic */ void lambda$reloadRegistryProviders$12(Map tagProviders, class_2960 providerId, Multimap providerTags, class_6862 tag) {
        if (tagProviders.containsKey(tag) && !providerId.equals(tagProviders.get(tag))) {
            if (tagProviders.get(tag) != null) {
                providerTags.remove(tagProviders.get(tag), (Object)tag);
                tagProviders.put(tag, null);
            }
        } else {
            tagProviders.put(tag, providerId);
        }
    }

    private static /* synthetic */ boolean lambda$reloadRegistryProviders$11(class_6880 holder, Map.Entry e) {
        return ((RegistryMatcher)e.getKey()).is(holder);
    }
}

