/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.inventory_tabs.tabs;

import folk.sisby.inventory_tabs.InventoryTabs;
import folk.sisby.inventory_tabs.tabs.ItemTab;
import folk.sisby.inventory_tabs.tabs.Tab;
import folk.sisby.inventory_tabs.util.BlockUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.stream.Collectors;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1533;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2183;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2625;
import net.minecraft.class_2960;
import net.minecraft.class_3965;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class BlockTab
implements Tab {
    public final int priority;
    public final class_2248 block;
    public final class_2338 pos;
    public final boolean unique;
    public final Map<class_2960, BiPredicate<class_1937, class_2338>> preclusions;
    public List<class_2338> multiblockPositions;
    public class_1799 itemStack;
    public class_2561 hoverText;

    public BlockTab(class_1937 world, class_2338 pos, Map<class_2960, BiPredicate<class_1937, class_2338>> preclusions, int priority, boolean unique) {
        this.priority = priority;
        this.unique = unique;
        this.block = world.method_8320(pos).method_26204();
        this.pos = pos;
        this.preclusions = preclusions;
        this.multiblockPositions = new ArrayList<class_2338>(List.of(pos));
        this.refreshMultiblock(world);
        this.refreshPreview(world);
    }

    @Override
    public void open(class_746 player, class_638 world, class_1703 handler, class_636 interactionManager) {
        if (InventoryTabs.CONFIG.rotatePlayer) {
            player.method_5702(class_2183.class_2184.field_9851, class_243.method_24953((class_2382)this.pos));
        }
        interactionManager.method_2896(player, class_1268.field_5808, new class_3965(this.pos.method_46558(), class_2350.field_11034, this.pos, false));
    }

    @Override
    public boolean shouldBeRemoved(class_1937 world, boolean current) {
        if (!world.method_8320(this.pos).method_26204().equals(this.block)) {
            return true;
        }
        this.refreshMultiblock(world);
        this.refreshPreview(world);
        if (current) {
            return false;
        }
        return this.preclusions.values().stream().anyMatch(p -> p.test(world, this.pos));
    }

    @Override
    public class_1799 getTabIcon() {
        return this.itemStack;
    }

    @Override
    public class_2561 getHoverText() {
        return this.hoverText;
    }

    protected void refreshPreviewAtPos(class_1937 world, class_2338 previewPos) {
        String name;
        List<class_2625> signs;
        class_2624 lcbe;
        class_2586 class_25862;
        List itemFrames = world.method_18467(class_1533.class, new class_238(previewPos.method_46558(), previewPos.method_46558()).method_1009(0.6, 0.3, 0.6));
        if (!itemFrames.isEmpty()) {
            this.itemStack = ((class_1533)itemFrames.get(0)).method_6940();
            if (!this.itemStack.method_7964().equals((Object)this.itemStack.method_7909().method_7864(this.itemStack))) {
                this.hoverText = this.itemStack.method_7964().method_27661().method_27692(class_124.field_1056);
            }
        }
        if ((class_25862 = world.method_8321(previewPos)) instanceof class_2624 && (lcbe = (class_2624)class_25862).method_16914()) {
            this.hoverText = lcbe.method_5797().method_27661().method_27692(class_124.field_1056);
        }
        if (!(signs = BlockUtil.getAttachedBlocks(world, previewPos, (w, p) -> {
            class_2625 sbe;
            class_2586 patt0$temp = w.method_8321(p);
            return patt0$temp instanceof class_2625 ? (sbe = (class_2625)patt0$temp) : null;
        })).isEmpty() && !(name = Arrays.stream(signs.get(0).method_49853().method_49877(false)).map(class_2561::getString).filter(s -> !s.isBlank()).collect(Collectors.joining(" "))).isBlank()) {
            this.hoverText = class_2561.method_43470((String)name).method_27692(class_124.field_1056);
        }
    }

    protected void refreshPreview(class_1937 world) {
        this.itemStack = new class_1799((class_1935)this.block);
        this.hoverText = this.getDefaultHoverText(world);
        for (class_2338 multiPos : this.multiblockPositions) {
            this.refreshPreviewAtPos(world, multiPos);
        }
    }

    protected class_2561 getDefaultHoverText(class_1937 world) {
        return this.block.method_9518();
    }

    protected void refreshMultiblock(class_1937 world) {
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.unique) {
            if (other instanceof ItemTab) {
                ItemTab it = (ItemTab)other;
                if (Objects.equals(this.block.method_8389(), it.stack.method_7909())) return true;
            }
            if (!(other instanceof BlockTab)) return false;
            BlockTab bt = (BlockTab)other;
            if (!Objects.equals(this.block, bt.block)) return false;
            return true;
        }
        if (!(other instanceof BlockTab)) return false;
        BlockTab bt = (BlockTab)other;
        if (!Objects.equals(this.multiblockPositions.get(0), bt.multiblockPositions.get(0))) return false;
        return true;
    }
}

