/*
 * Decompiled with CFR 0.152.
 */
package folk.sisby.inventory_tabs.tabs;

import folk.sisby.inventory_tabs.tabs.BlockTab;
import folk.sisby.inventory_tabs.tabs.Tab;
import folk.sisby.inventory_tabs.util.HandlerSlotUtil;
import java.util.Map;
import java.util.Objects;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1263;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2848;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_465;
import net.minecraft.class_636;
import net.minecraft.class_638;
import net.minecraft.class_746;

public class ItemTab
implements Tab {
    public final class_1799 stack;
    public int slot;
    public final boolean unique;
    public final boolean sneakInteract;
    public final Map<class_2960, Predicate<class_1799>> preclusions;
    public class_1799 swappedStack = null;
    public int swappedSlot = -1;

    public ItemTab(class_1799 stack, int slot, Map<class_2960, Predicate<class_1799>> preclusions, boolean unique, boolean sneakInteract) {
        this.stack = stack;
        this.slot = slot;
        this.preclusions = preclusions;
        this.unique = unique;
        this.sneakInteract = sneakInteract;
    }

    public ItemTab(class_1799 stack, int slot, Map<class_2960, Predicate<class_1799>> preclusions, boolean unique) {
        this(stack, slot, preclusions, unique, false);
    }

    @Override
    public void close(class_746 player, class_638 world, class_1703 handler, class_636 interactionManager) {
        class_1799 inSwappedSlot;
        if (player == null) {
            return;
        }
        if (this.swappedSlot != -1 && class_1799.method_7973((class_1799)(inSwappedSlot = player.method_31548().method_5438(this.swappedSlot)), (class_1799)this.swappedStack)) {
            int slotIndex = handler.method_37418((class_1263)player.method_31548(), this.swappedSlot).getAsInt();
            interactionManager.method_2906(handler.field_7763, slotIndex, player.method_31548().field_7545, class_1713.field_7791, (class_1657)player);
        }
    }

    @Override
    public void open(class_746 player, class_638 world, class_1703 handler, class_636 interactionManager) {
        int slotIndex = handler.method_37418((class_1263)player.method_31548(), this.slot).getAsInt();
        if (slotIndex != player.method_31548().field_7545) {
            interactionManager.method_2906(handler.field_7763, slotIndex, player.method_31548().field_7545, class_1713.field_7791, (class_1657)player);
        }
        if (this.sneakInteract) {
            player.field_3944.method_52787((class_2596)new class_2848((class_1297)player, class_2848.class_2849.field_12979));
        }
        interactionManager.method_2919((class_1657)player, class_1268.field_5808);
        if (this.sneakInteract) {
            player.field_3944.method_52787((class_2596)new class_2848((class_1297)player, class_2848.class_2849.field_12984));
        }
        if (this.unique && slotIndex != player.method_31548().field_7545) {
            HandlerSlotUtil.mainHandSwapSlot = this.slot;
        }
        if (!this.unique) {
            this.swappedSlot = this.slot;
            this.swappedStack = player.method_31548().method_5438(this.slot);
            this.slot = player.method_31548().field_7545;
        }
    }

    @Override
    public boolean shouldBeRemoved(class_1937 world, boolean current) {
        class_465 hs;
        if (current) {
            return false;
        }
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return true;
        }
        if (!player.method_31548().method_5438(this.slot).equals(this.stack)) {
            return true;
        }
        if (this.preclusions.values().stream().anyMatch(p -> p.test(this.stack))) {
            return true;
        }
        class_437 class_4372 = class_310.method_1551().field_1755;
        return class_4372 instanceof class_465 && (hs = (class_465)class_4372).method_17577().method_37418((class_1263)player.method_31548(), this.slot).isEmpty();
    }

    @Override
    public boolean isBuffered() {
        return true;
    }

    @Override
    public class_2561 getHoverText() {
        return !this.stack.method_7964().equals((Object)this.stack.method_7909().method_7864(this.stack)) ? this.stack.method_7964().method_27661().method_27692(class_124.field_1056) : this.stack.method_7964();
    }

    @Override
    public class_1799 getTabIcon() {
        return this.stack;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (this.unique) {
            if (other instanceof ItemTab) {
                ItemTab it = (ItemTab)other;
                if (Objects.equals(this.stack.method_7909(), it.stack.method_7909())) return true;
            }
            if (!(other instanceof BlockTab)) return false;
            BlockTab bt = (BlockTab)other;
            if (!Objects.equals(this.stack.method_7909(), bt.block.method_8389())) return false;
            return true;
        }
        if (!(other instanceof ItemTab)) return false;
        ItemTab it = (ItemTab)other;
        if (!Objects.equals(this.slot, it.slot)) return false;
        return true;
    }
}

