/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.common.block.entity.inventory;

import java.util.Iterator;
import java.util.List;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.item.base.SingleItemStorage;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.refabricated.inventory.ItemHandler;
import vectorwing.farmersdelight.refabricated.inventory.ItemStackHandler;

public class CookingPotItemHandler
implements ItemHandler {
    private static final int SLOTS_INPUT = 6;
    private static final int SLOT_CONTAINER_INPUT = 7;
    private static final int SLOT_MEAL_OUTPUT = 8;
    private final ItemStackHandler itemHandler;
    private final class_2350 side;

    public CookingPotItemHandler(ItemStackHandler itemHandler, @Nullable class_2350 side) {
        this.itemHandler = itemHandler;
        this.side = side;
    }

    @Override
    public boolean isItemValid(int slot, @NotNull class_1799 stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }

    @Override
    public int getSlotCount() {
        return this.itemHandler.getSlotCount();
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return this.itemHandler.getSlot(slot);
    }

    @NotNull
    public class_1799 insertItem(int slot, @NotNull class_1799 stack, boolean simulate) {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return slot < 6 ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
        }
        return slot == 7 ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
    }

    @NotNull
    public class_1799 extractItem(int slot, int amount, boolean simulate) {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return slot < 6 ? this.itemHandler.removeItem(slot, amount, simulate) : class_1799.field_8037;
        }
        return slot == 8 ? this.itemHandler.removeItem(slot, amount, simulate) : class_1799.field_8037;
    }

    @Override
    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    @Override
    @NotNull
    public class_1799 getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Override
    public void commitModifiedStacks() {
        this.itemHandler.commitModifiedStacks();
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        this.itemHandler.setStackInSlot(slot, stack);
    }

    @Override
    public class_1799 removeItem(int slot, int amount) {
        return null;
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        SingleItemStorage slot;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long inserted = 0L;
        Iterator<SingleItemStorage> it = this.getInsertableSlotsFor(resource);
        while (it.hasNext() && (inserted += (slot = it.next()).insert((TransferVariant)resource, maxAmount - inserted, transaction)) < maxAmount) {
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        SingleItemStorage slot;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long extracted = 0L;
        Iterator<SingleItemStorage> it = this.getSlotsContaining(resource);
        while (it.hasNext() && (extracted += (slot = it.next()).extract((TransferVariant)resource, maxAmount - extracted, transaction)) < maxAmount) {
        }
        return extracted;
    }

    @Override
    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return slot < 6 ? this.itemHandler.insertSlot(slot, resource, maxAmount, transaction) : 0L;
        }
        return slot == 7 ? this.itemHandler.insertSlot(slot, resource, maxAmount, transaction) : 0L;
    }

    @Override
    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return slot < 6 ? this.itemHandler.extractSlot(slot, resource, maxAmount, transaction) : 0L;
        }
        return slot == 8 ? this.itemHandler.extractSlot(slot, resource, maxAmount, transaction) : 0L;
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        if (this.side == null || this.side.equals((Object)class_2350.field_11036)) {
            return this.itemHandler.getSlots().subList(0, 6).iterator();
        }
        return List.of((SingleSlotStorage)this.itemHandler.getSlots().get(8)).iterator();
    }

    private Iterator<SingleItemStorage> getInsertableSlotsFor(ItemVariant resource) {
        List slots = this.side == null || this.side.equals((Object)class_2350.field_11036) ? this.itemHandler.getSlots().subList(0, 6) : List.of((SingleSlotStorage)this.itemHandler.getSlots().get(8));
        return slots.stream().filter(views -> views.isResourceBlank() || ((ItemVariant)views.getResource()).equals((Object)resource)).iterator();
    }

    private Iterator<SingleItemStorage> getSlotsContaining(ItemVariant resource) {
        List slots = this.side == null || this.side.equals((Object)class_2350.field_11036) ? this.itemHandler.getSlots().subList(0, 6) : List.of((SingleSlotStorage)this.itemHandler.getSlots().get(8));
        return slots.stream().filter(views -> ((ItemVariant)views.getResource()).equals((Object)resource)).iterator();
    }
}

