/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.refabricated.inventory;

import com.google.common.cache.Cache;
import com.google.common.cache.CacheBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.transfer.v1.item.ItemVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.StoragePreconditions;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.TransferVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_7225;
import org.jetbrains.annotations.NotNull;
import vectorwing.farmersdelight.refabricated.inventory.ItemHandler;
import vectorwing.farmersdelight.refabricated.inventory.ItemStackStorage;

public class ItemStackHandler
implements ItemHandler {
    private final List<ItemStackStorage> slots;
    private final Cache<Integer, StackReference> stackRefs = CacheBuilder.newBuilder().expireAfterWrite(15L, TimeUnit.SECONDS).build();

    public ItemStackHandler() {
        this(1);
    }

    public ItemStackHandler(int size) {
        this.slots = new ObjectArrayList(size);
        for (int i = 0; i < size; ++i) {
            this.slots.add(new ItemStackStorage(i));
        }
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        return true;
    }

    @Override
    public class_1799 getStackInSlot(int slot) {
        ItemStackStorage slotRef = this.slots.get(slot);
        class_1799 stackRef = ((ItemVariant)slotRef.getResource()).toStack((int)slotRef.getAmount());
        this.stackRefs.put((Object)slot, (Object)new StackReference(stackRef.method_7972(), stackRef));
        return stackRef;
    }

    @Override
    public void commitModifiedStacks() {
        ConcurrentMap stackMap = this.stackRefs.asMap();
        if (stackMap.isEmpty()) {
            return;
        }
        for (Map.Entry stackRef : stackMap.entrySet()) {
            if (!class_1799.method_7973((class_1799)((StackReference)stackRef.getValue()).original(), (class_1799)((StackReference)stackRef.getValue()).current())) {
                this.setStackInSlot((Integer)stackRef.getKey(), ((StackReference)stackRef.getValue()).current());
                this.onContentsChanged((Integer)stackRef.getKey());
            }
            this.stackRefs.invalidate(stackRef.getKey());
        }
    }

    @Override
    public void setStackInSlot(int slot, class_1799 stack) {
        if (!this.getSlot(slot).isResourceBlank()) {
            this.removeItem(slot, this.getSlotLimit(slot), false);
        }
        this.insertItem(slot, stack, false);
    }

    @Override
    public class_1799 removeItem(int slot, int amount) {
        return this.removeItem(slot, amount, false);
    }

    public class_1799 insertItem(int slot, class_1799 stack, boolean simulate) {
        if (stack.method_7960()) {
            return stack;
        }
        try (Transaction transaction = Transaction.openOuter();){
            stack = stack.method_46651(stack.method_7947() - (int)this.insertSlot(slot, ItemVariant.of((class_1799)stack), stack.method_7947(), (TransactionContext)transaction));
            if (!simulate) {
                transaction.commit();
            }
        }
        return stack;
    }

    @NotNull
    public class_1799 removeItem(int slot, int amount, boolean simulate) {
        class_1799 stack;
        try (Transaction transaction = Transaction.openOuter();){
            stack = this.getStackInSlot(slot).method_46651((int)this.extractSlot(slot, ItemVariant.of((class_1799)this.getStackInSlot(slot)), amount, (TransactionContext)transaction));
            if (!simulate) {
                transaction.commit();
            }
        }
        return stack;
    }

    @Override
    public int getSlotLimit(int slot) {
        return (int)this.slots.get(slot).getCapacity();
    }

    public int getStackLimit(int slot, ItemVariant resource) {
        return Math.min(this.getSlotLimit(slot), resource.getItem().method_7882());
    }

    @Override
    public int getSlotCount() {
        return this.slots.size();
    }

    public SingleSlotStorage<ItemVariant> getSlot(int slot) {
        return (SingleSlotStorage)this.slots.get(slot);
    }

    public long insert(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        ItemStackStorage storage;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        long inserted = 0L;
        Iterator<ItemStackStorage> it = this.getInsertableSlotsFor(resource);
        while (it.hasNext() && (inserted += (storage = it.next()).insert((TransferVariant)resource, maxAmount, transaction)) < maxAmount) {
            this.onContentsChanged(storage.index);
        }
        return inserted;
    }

    public long extract(ItemVariant resource, long maxAmount, TransactionContext transaction) {
        ItemStackStorage storage;
        StoragePreconditions.notBlankNotNegative((TransferVariant)resource, (long)maxAmount);
        SortedSet<ItemStackStorage> slots = this.getSlotsContaining(resource);
        if (slots.isEmpty()) {
            return 0L;
        }
        long extracted = 0L;
        Iterator iterator = slots.iterator();
        while (iterator.hasNext() && (extracted += (storage = (ItemStackStorage)((Object)iterator.next())).extract((TransferVariant)resource, maxAmount - extracted, transaction)) < maxAmount) {
            this.onContentsChanged(storage.index);
        }
        return extracted;
    }

    @Override
    public long insertSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (resource.isBlank()) {
            return 0L;
        }
        long amount = this.slots.get(slot).insert((TransferVariant)resource, maxAmount, transaction);
        this.onContentsChanged(slot);
        return amount;
    }

    @Override
    public long extractSlot(int slot, ItemVariant resource, long maxAmount, TransactionContext transaction) {
        if (resource.isBlank()) {
            return 0L;
        }
        long amount = this.slots.get(slot).extract((TransferVariant)resource, maxAmount, transaction);
        this.onContentsChanged(slot);
        return amount;
    }

    public SortedSet<ItemStackStorage> getSlotsContaining(ItemVariant resource) {
        return (SortedSet)this.slots.stream().filter(storageViews -> ((ItemVariant)storageViews.getResource()).equals((Object)resource)).collect(Collectors.toCollection(ObjectLinkedOpenHashSet::new));
    }

    public Iterator<ItemStackStorage> getInsertableSlotsFor(ItemVariant resource) {
        return this.slots.stream().filter(views -> views.isResourceBlank() || ((ItemVariant)views.getResource()).equals((Object)resource)).iterator();
    }

    public Iterator<StorageView<ItemVariant>> iterator() {
        return this.getSlots().iterator();
    }

    public class_2487 serializeNBT(class_7225.class_7874 provider) {
        class_2499 listTag = new class_2499();
        for (int i = 0; i < this.slots.size(); ++i) {
            if (this.slots.get(i).isResourceBlank()) continue;
            class_2487 itemTag = new class_2487();
            itemTag.method_10569("Slot", i);
            this.slots.get(i).writeNbt(itemTag, provider);
            listTag.add((Object)itemTag);
        }
        class_2487 tag = new class_2487();
        tag.method_10566("Items", (class_2520)listTag);
        return tag;
    }

    public void deserializeNBT(class_7225.class_7874 provider, class_2487 tag) {
        for (int i = 0; i < this.slots.size(); ++i) {
            this.setStackInSlot(i, class_1799.field_8037);
        }
        class_2499 listTag = tag.method_10554("Items", 10);
        for (int i = 0; i < listTag.size(); ++i) {
            class_2487 compound = listTag.method_10602(i);
            this.slots.get(compound.method_10550("Slot")).readNbt(compound, provider);
        }
    }

    protected void onContentsChanged(int slot) {
    }

    protected record StackReference(class_1799 original, class_1799 current) {
    }
}

