/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.refabricated.mlconfigs.fabric.values;

import com.google.common.base.Preconditions;
import com.google.gson.JsonObject;
import java.util.Objects;
import vectorwing.farmersdelight.refabricated.mlconfigs.ConfigBuilder;
import vectorwing.farmersdelight.refabricated.mlconfigs.fabric.values.ConfigValue;

public class IntConfigValue
extends ConfigValue<Integer> {
    private final Integer min;
    private final Integer max;

    public IntConfigValue(String name, Integer defaultValue, Integer min, Integer max) {
        super(name, defaultValue);
        this.min = Objects.requireNonNull(min);
        this.max = Objects.requireNonNull(max);
        Preconditions.checkState((boolean)this.isValid(defaultValue), (Object)"Config defaults are invalid");
    }

    @Override
    public boolean isValid(Integer value) {
        return value >= this.min && value <= this.max;
    }

    @Override
    public void loadFromJson(JsonObject element) {
        if (element.has(this.name)) {
            try {
                this.value = element.get(this.name).getAsInt();
                if (this.isValid((Integer)this.value)) {
                    return;
                }
                this.value = this.defaultValue;
            }
            catch (Exception exception) {
                // empty catch block
            }
            ConfigBuilder.LOGGER.warn("Config file had incorrect entry {}, correcting", (Object)this.name);
        } else {
            ConfigBuilder.LOGGER.warn("Config file had missing entry {}", (Object)this.name);
        }
    }

    @Override
    public void saveToJson(JsonObject object) {
        if (this.value == null) {
            this.value = this.defaultValue;
        }
        object.addProperty(this.name, (Number)this.value);
    }

    public Integer getMax() {
        return this.max;
    }

    public Integer getMin() {
        return this.min;
    }
}

