/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.catheter;

import com.github.cao.awa.catheter.ByteCatheter;
import com.github.cao.awa.catheter.Catheter;
import com.github.cao.awa.catheter.DoubleCatheter;
import com.github.cao.awa.catheter.IntCatheter;
import com.github.cao.awa.catheter.LongCatheter;
import com.github.cao.awa.catheter.action.BiBooleanPredicate;
import com.github.cao.awa.catheter.action.BooleanConsumer;
import com.github.cao.awa.catheter.action.BooleanFunction;
import com.github.cao.awa.catheter.action.BooleanPredicate;
import com.github.cao.awa.catheter.action.BooleanToByteFunction;
import com.github.cao.awa.catheter.action.BooleanToDoubleFunction;
import com.github.cao.awa.catheter.action.BooleanToIntegerFunction;
import com.github.cao.awa.catheter.action.BooleanToLongFunction;
import com.github.cao.awa.catheter.action.IntegerAndBiBooleanPredicate;
import com.github.cao.awa.catheter.action.IntegerAndBooleanConsumer;
import com.github.cao.awa.catheter.action.IntegerAndBooleanPredicate;
import com.github.cao.awa.catheter.matrix.MatrixFlockPos;
import com.github.cao.awa.catheter.matrix.MatrixPos;
import com.github.cao.awa.catheter.pair.IntegerAndBooleanPair;
import com.github.cao.awa.catheter.receptacle.BooleanReceptacle;
import com.github.cao.awa.catheter.receptacle.IntegerReceptacle;
import com.github.cao.awa.sinuatum.function.consumer.TriConsumer;
import com.github.cao.awa.sinuatum.function.function.QuinFunction;
import com.github.cao.awa.sinuatum.function.function.TriFunction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.random.RandomGenerator;
import java.util.stream.Stream;

public class BooleanCatheter {
    private static final Random RANDOM = new Random();
    private boolean[] targets;

    public BooleanCatheter(boolean[] targets) {
        this.targets = targets;
    }

    public static BooleanCatheter make(boolean ... targets) {
        return new BooleanCatheter(targets);
    }

    public static BooleanCatheter makeCapacity(int size) {
        return new BooleanCatheter(BooleanCatheter.array(size));
    }

    public static <X> BooleanCatheter of(boolean[] targets) {
        return new BooleanCatheter(targets);
    }

    public static BooleanCatheter of(Collection<Boolean> targets) {
        if (targets == null) {
            return new BooleanCatheter(BooleanCatheter.array(0));
        }
        boolean[] delegate = new boolean[targets.size()];
        int index = 0;
        for (boolean target : targets) {
            delegate[index++] = target;
        }
        return new BooleanCatheter(delegate);
    }

    public BooleanCatheter each(BooleanConsumer action) {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            action.accept(b);
        }
        return this;
    }

    public BooleanCatheter each(BooleanConsumer action, Runnable poster) {
        this.each(action);
        poster.run();
        return this;
    }

    public <X> BooleanCatheter each(X initializer, BiConsumer<X, Boolean> action) {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            action.accept(initializer, b);
        }
        return this;
    }

    public <X> BooleanCatheter each(X initializer, BiConsumer<X, Boolean> action, Consumer<X> poster) {
        this.each(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public <X> BooleanCatheter overall(X initializer, TriConsumer<X, Integer, Boolean> action) {
        boolean[] ts = this.targets;
        int index = 0;
        for (boolean b : ts) {
            action.accept(initializer, index++, b);
        }
        return this;
    }

    public <X> BooleanCatheter overall(X initializer, TriConsumer<X, Integer, Boolean> action, Consumer<X> poster) {
        this.overall(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public BooleanCatheter overall(IntegerAndBooleanConsumer action) {
        boolean[] ts = this.targets;
        int index = 0;
        for (boolean b : ts) {
            action.accept(index++, b);
        }
        return this;
    }

    public BooleanCatheter overall(IntegerAndBooleanConsumer action, Runnable poster) {
        this.overall(action);
        poster.run();
        return this;
    }

    public BooleanCatheter insert(IntegerAndBiBooleanPredicate maker) {
        HashMap indexes = new HashMap();
        BooleanReceptacle lastItem = new BooleanReceptacle(false);
        this.overall((index, item) -> {
            indexes.put(index + indexes.size(), new IntegerAndBooleanPair(index, maker.test(index, item, lastItem.get())));
            lastItem.set(item);
        });
        boolean[] ts = this.targets;
        boolean[] newDelegate = BooleanCatheter.array(ts.length + indexes.size());
        IntegerReceptacle lastIndex = new IntegerReceptacle(0);
        IntegerReceptacle lastDest = new IntegerReceptacle(0);
        IntCatheter.of(indexes.keySet()).sort().each((int index) -> {
            if (lastIndex.get() != index) {
                int maxCopyLength = Math.min(newDelegate.length - lastDest.get() - 1, index - lastIndex.get());
                System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), maxCopyLength);
            }
            IntegerAndBooleanPair item = (IntegerAndBooleanPair)indexes.get(index);
            newDelegate[index] = item.booleanValue();
            lastIndex.set(item.intValue());
            lastDest.set(index + 1);
        }, () -> System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), newDelegate.length - lastDest.get()));
        this.targets = newDelegate;
        return this;
    }

    public BooleanCatheter pluck(IntegerAndBiBooleanPredicate maker) {
        BooleanReceptacle lastItem = new BooleanReceptacle(false);
        return this.overallFilter((index, item) -> {
            if (maker.test(index, item, lastItem.get())) {
                return false;
            }
            lastItem.set(item);
            return true;
        });
    }

    public BooleanCatheter discardTo(BooleanPredicate predicate) {
        BooleanCatheter result = BooleanCatheter.make(new boolean[0]);
        this.overallFilter((index, item) -> !predicate.test(item), result::reset);
        return result;
    }

    public <X> BooleanCatheter discardTo(Predicate<X> predicate, BooleanFunction<X> converter) {
        BooleanCatheter result = BooleanCatheter.make(new boolean[0]);
        this.overallFilter((index, item) -> !predicate.test(converter.apply(item)), result::reset);
        return result;
    }

    public BooleanCatheter discardTo(boolean initializer, BiBooleanPredicate predicate) {
        BooleanCatheter result = BooleanCatheter.make(new boolean[0]);
        this.overallFilter((index, item) -> !predicate.test(item, initializer), result::reset);
        return result;
    }

    public BooleanCatheter orDiscardTo(boolean succeed, BooleanPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate);
    }

    public <X> BooleanCatheter orDiscardTo(boolean succeed, Predicate<X> predicate, BooleanFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate, converter);
    }

    public BooleanCatheter orDiscardTo(boolean succeed, boolean initializer, BiBooleanPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(initializer, predicate);
    }

    public BooleanCatheter discard(BooleanPredicate predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item));
    }

    public <X> BooleanCatheter discard(Predicate<X> predicate, BooleanFunction<X> converter) {
        return this.overallFilter((index, item) -> !predicate.test(converter.apply(item)));
    }

    public BooleanCatheter discard(boolean initializer, BiBooleanPredicate predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item, initializer));
    }

    public BooleanCatheter orDiscard(boolean succeed, BooleanPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate);
    }

    public <X> BooleanCatheter orDiscard(boolean succeed, Predicate<X> predicate, BooleanFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate, converter);
    }

    public BooleanCatheter orDiscard(boolean succeed, boolean initializer, BiBooleanPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(initializer, predicate);
    }

    public BooleanCatheter filterTo(BooleanPredicate predicate) {
        return this.dump().filter(predicate);
    }

    public <X> BooleanCatheter filterTo(Predicate<X> predicate, BooleanFunction<X> converter) {
        return this.dump().filter(predicate, converter);
    }

    public BooleanCatheter filterTo(boolean initializer, BiBooleanPredicate predicate) {
        return this.dump().filter(initializer, predicate);
    }

    public BooleanCatheter orFilterTo(boolean succeed, BooleanPredicate predicate) {
        return this.dump().orFilter(succeed, predicate);
    }

    public <X> BooleanCatheter orFilterTo(boolean succeed, Predicate<X> predicate, BooleanFunction<X> converter) {
        return this.dump().orFilter(succeed, predicate, converter);
    }

    public BooleanCatheter orFilterTo(boolean succeed, boolean initializer, BiBooleanPredicate predicate) {
        return this.dump().orFilter(succeed, initializer, predicate);
    }

    public BooleanCatheter filter(BooleanPredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(item));
    }

    public <X> BooleanCatheter filter(Predicate<X> predicate, BooleanFunction<X> converter) {
        return this.overallFilter((index, item) -> predicate.test(converter.apply(item)));
    }

    public BooleanCatheter overallFilter(IntegerAndBooleanPredicate predicate) {
        return this.overallFilter(predicate, (boolean[] x) -> {});
    }

    public BooleanCatheter overallFilter(IntegerAndBooleanPredicate predicate, Consumer<boolean[]> discarding) {
        if (this.isEmpty()) {
            return this;
        }
        boolean[] ts = this.targets;
        int length = ts.length;
        boolean[] deleting = BooleanCatheter.array(length);
        int newDelegateSize = length;
        int index = 0;
        for (boolean target : ts) {
            if (predicate.test(index, target)) {
                ++index;
                continue;
            }
            deleting[index++] = true;
            --newDelegateSize;
        }
        boolean[] newDelegate = BooleanCatheter.array(newDelegateSize);
        boolean[] discardingDelegate = BooleanCatheter.array(length - newDelegateSize);
        int discardingDelegateIndex = 0;
        int newDelegateIndex = 0;
        index = 0;
        for (boolean isDeleting : deleting) {
            boolean t = ts[index++];
            if (isDeleting) {
                discardingDelegate[discardingDelegateIndex++] = t;
                continue;
            }
            newDelegate[newDelegateIndex++] = t;
        }
        discarding.accept(discardingDelegate);
        this.targets = newDelegate;
        return this;
    }

    public BooleanCatheter overallFilter(boolean initializer, IntegerAndBiBooleanPredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(index, item, initializer));
    }

    public BooleanCatheter filter(boolean initializer, BiBooleanPredicate predicate) {
        return this.overallFilter((index, item) -> predicate.test(item, initializer));
    }

    public BooleanCatheter orFilter(boolean succeed, BooleanPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate);
    }

    public <X> BooleanCatheter orFilter(boolean succeed, Predicate<X> predicate, BooleanFunction<X> converter) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate, converter);
    }

    public BooleanCatheter orFilter(boolean succeed, boolean initializer, BiBooleanPredicate predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(initializer, predicate);
    }

    public BooleanCatheter removeWithIndex(int index) {
        if (this.isEmpty() || index >= this.count() || index < 0) {
            return this;
        }
        boolean[] newDelegate = BooleanCatheter.array(this.count() - 1);
        if (index > 0) {
            System.arraycopy(this.targets, 0, newDelegate, 0, index);
        }
        System.arraycopy(this.targets, index + 1, newDelegate, index, this.count() - 1 - index);
        this.targets = newDelegate;
        return this;
    }

    public boolean isPresent() {
        return this.count() > 0;
    }

    public BooleanCatheter ifPresent(Consumer<BooleanCatheter> action) {
        if (this.count() > 0) {
            action.accept(this);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public BooleanCatheter ifEmpty(Consumer<BooleanCatheter> action) {
        if (this.count() == 0) {
            action.accept(this);
        }
        return this;
    }

    public BooleanCatheter distinct() {
        HashMap map = new HashMap();
        return this.filter(item -> {
            if (map.getOrDefault(item, false).booleanValue()) {
                return false;
            }
            map.put(item, true);
            return true;
        });
    }

    public BooleanCatheter sort(Comparator<Boolean> comparator) {
        Boolean[] array = new Boolean[this.targets.length];
        int index = 0;
        for (boolean target : this.targets) {
            array[index++] = target;
        }
        Arrays.sort(array, comparator);
        index = 0;
        Boolean[] booleanArray = array;
        int n = booleanArray.length;
        for (int i = 0; i < n; ++i) {
            boolean target;
            target = booleanArray[i];
            this.targets[index++] = target;
        }
        return this;
    }

    public BooleanCatheter holdTill(int index) {
        if (this.isEmpty()) {
            return this;
        }
        index = Math.min(index, this.targets.length);
        boolean[] ts = this.targets;
        boolean[] newDelegate = BooleanCatheter.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public BooleanCatheter holdTill(BooleanPredicate predicate) {
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        boolean[] ts = this.targets;
        boolean[] newDelegate = BooleanCatheter.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public BooleanCatheter whenFlock(boolean source, BiBooleanPredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.flock(source, maker));
        return this;
    }

    public BooleanCatheter whenFlock(BiBooleanPredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.flock(maker));
        return this;
    }

    public boolean flock(boolean source, BiBooleanPredicate maker) {
        boolean[] ts = this.targets;
        boolean result = source;
        for (boolean b : ts) {
            result = maker.test(result, b);
        }
        return result;
    }

    public boolean flock(BiBooleanPredicate maker) {
        boolean[] ts = this.targets;
        int length = ts.length;
        boolean result = length > 0 && ts[0];
        for (int i = 1; i < length; ++i) {
            result = maker.test(result, ts[i]);
        }
        return result;
    }

    public <X> X alternate(X source, BiFunction<X, Boolean, X> maker) {
        boolean[] ts = this.targets;
        X result = source;
        for (boolean b : ts) {
            result = maker.apply(result, b);
        }
        return result;
    }

    public <X> BooleanCatheter whenAlternate(X source, BiFunction<X, Boolean, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public <X> BooleanCatheter whenAlternate(BiFunction<X, Boolean, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(null, maker));
        return this;
    }

    public boolean alternate(boolean source, BiBooleanPredicate maker) {
        BooleanReceptacle result = new BooleanReceptacle(source);
        this.flock((older, newer) -> {
            result.and(maker.test(older, newer));
            return newer;
        });
        return result.get();
    }

    public BooleanCatheter whenAlternate(boolean source, BiBooleanPredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public BooleanCatheter whenAlternate(BiBooleanPredicate maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(false, maker));
        return this;
    }

    public BooleanCatheter waiveTill(int index) {
        boolean[] newDelegate;
        if (this.isEmpty()) {
            return this;
        }
        boolean[] ts = this.targets;
        if (index >= ts.length) {
            newDelegate = BooleanCatheter.array(0);
        } else {
            newDelegate = BooleanCatheter.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public BooleanCatheter waiveTill(BooleanPredicate predicate) {
        boolean[] newDelegate;
        boolean[] ts;
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        if (index >= (ts = this.targets).length) {
            newDelegate = BooleanCatheter.array(0);
        } else {
            newDelegate = BooleanCatheter.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public BooleanCatheter till(BooleanPredicate predicate) {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            if (predicate.test(b)) break;
        }
        return this;
    }

    public int findTill(BooleanPredicate predicate) {
        boolean[] ts = this.targets;
        int index = 0;
        for (boolean b : ts) {
            if (predicate.test(b)) break;
            ++index;
        }
        return index;
    }

    public BooleanCatheter replace(BooleanPredicate handler) {
        if (this.isEmpty()) {
            return this;
        }
        boolean[] ts = this.targets;
        int index = 0;
        for (boolean b : ts) {
            ts[index++] = handler.test(b);
        }
        return this;
    }

    public BooleanCatheter vary(BooleanPredicate handler) {
        return this.replace(handler);
    }

    public DoubleCatheter vary(BooleanToDoubleFunction handler) {
        if (this.isEmpty()) {
            return DoubleCatheter.make(new double[0]);
        }
        boolean[] ts = this.targets;
        double[] array = new double[ts.length];
        int index = 0;
        for (boolean i : ts) {
            array[index++] = handler.applyAsDouble(i);
        }
        return DoubleCatheter.of(array);
    }

    public ByteCatheter vary(BooleanToByteFunction handler) {
        if (this.isEmpty()) {
            return ByteCatheter.make(new byte[0]);
        }
        boolean[] ts = this.targets;
        byte[] array = new byte[ts.length];
        int index = 0;
        for (boolean i : ts) {
            array[index++] = handler.applyAsByte(i);
        }
        return ByteCatheter.of(array);
    }

    public LongCatheter vary(BooleanToLongFunction handler) {
        if (this.isEmpty()) {
            return LongCatheter.make(new long[0]);
        }
        boolean[] ts = this.targets;
        long[] array = new long[ts.length];
        int index = 0;
        for (boolean i : ts) {
            array[index++] = handler.applyAsLong(i);
        }
        return LongCatheter.of(array);
    }

    public IntCatheter vary(BooleanToIntegerFunction handler) {
        if (this.isEmpty()) {
            return IntCatheter.make(new int[0]);
        }
        boolean[] ts = this.targets;
        int[] array = new int[ts.length];
        int index = 0;
        for (boolean i : ts) {
            array[index++] = handler.applyAsInteger(i);
        }
        return IntCatheter.of(array);
    }

    public <X> Catheter<X> vary(BooleanFunction<X> handler) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        boolean[] ts = this.targets;
        X[] array = BooleanCatheter.xArray(ts.length);
        int index = 0;
        for (boolean b : ts) {
            array[index++] = handler.apply(b);
        }
        return new Catheter<X>(array);
    }

    public <X> Catheter<X> vary(BooleanFunction<X> handler, IntFunction<X[]> arrayGenerator) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        boolean[] ts = this.targets;
        X[] array = arrayGenerator.apply(ts.length);
        int index = 0;
        for (boolean l : ts) {
            array[index++] = handler.apply(l);
        }
        return Catheter.of(array).arrayGenerator(arrayGenerator);
    }

    public BooleanCatheter whenAny(BooleanPredicate predicate, BooleanConsumer action) {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            if (!predicate.test(b)) continue;
            action.accept(b);
            break;
        }
        return this;
    }

    public BooleanCatheter whenAll(BooleanPredicate predicate, Runnable action) {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            if (predicate.test(b)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public BooleanCatheter whenAll(BooleanPredicate predicate, BooleanConsumer action) {
        return this.whenAll(predicate, () -> this.each(action));
    }

    private BooleanCatheter whenNone(BooleanPredicate predicate, Runnable action) {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            if (!predicate.test(b)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public boolean hasTrue() {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            if (!b) continue;
            return true;
        }
        return false;
    }

    public boolean hasFalse() {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            if (b) continue;
            return true;
        }
        return false;
    }

    public boolean hasAny(BooleanPredicate predicate) {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            if (!predicate.test(b)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAll(BooleanPredicate predicate) {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            if (predicate.test(b)) continue;
            return false;
        }
        return true;
    }

    public boolean hasNone(BooleanPredicate predicate) {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            if (!predicate.test(b)) continue;
            return false;
        }
        return true;
    }

    public boolean findFirst(BooleanPredicate predicate) {
        boolean[] ts;
        for (boolean b : ts = this.targets) {
            if (!predicate.test(b)) continue;
            return b;
        }
        return false;
    }

    public boolean findLast(BooleanPredicate predicate) {
        boolean[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            boolean t;
            if (!predicate.test(t = ts[index--])) continue;
            return t;
        }
        return false;
    }

    public <X> X whenFoundFirst(BooleanPredicate predicate, BooleanFunction<X> function) {
        boolean[] ts = this.targets;
        int length = ts.length;
        boolean index = false;
        for (boolean b : ts) {
            if (!predicate.test(b)) continue;
            return function.apply(b);
        }
        return null;
    }

    public <X> X whenFoundLast(BooleanPredicate predicate, BooleanFunction<X> function) {
        boolean[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            boolean t;
            if (!predicate.test(t = ts[index--])) continue;
            return function.apply(t);
        }
        return null;
    }

    public BooleanCatheter any(BooleanConsumer consumer) {
        if (this.targets.length > 0) {
            boolean[] ls = this.targets;
            int index = RANDOM.nextInt(ls.length);
            consumer.accept(ls.length > index ? ls[index] : ls[ls.length - 1]);
        }
        return this;
    }

    public BooleanCatheter first(BooleanConsumer consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[0]);
        }
        return this;
    }

    public BooleanCatheter tail(BooleanConsumer consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[this.targets.length - 1]);
        }
        return this;
    }

    public BooleanCatheter reverse() {
        if (this.isEmpty()) {
            return this;
        }
        boolean[] ts = this.targets;
        int length = ts.length;
        int split = length / 2;
        for (int index = 0; index < split; ++index) {
            int swapIndex = length - index - 1;
            boolean temp = ts[index];
            ts[index] = ts[swapIndex];
            ts[swapIndex] = temp;
        }
        return this;
    }

    public boolean max(Comparator<Boolean> comparator) {
        return this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result);
    }

    public boolean min(Comparator<Boolean> comparator) {
        return this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result);
    }

    public BooleanCatheter whenMax(Comparator<Boolean> comparator, BooleanConsumer action) {
        action.accept(this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result));
        return this;
    }

    public BooleanCatheter whenMin(Comparator<Boolean> comparator, BooleanConsumer action) {
        action.accept(this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result));
        return this;
    }

    public int count() {
        return this.targets.length;
    }

    public BooleanCatheter count(AtomicInteger target) {
        target.set(this.count());
        return this;
    }

    public BooleanCatheter count(IntegerReceptacle target) {
        target.set(this.count());
        return this;
    }

    public BooleanCatheter count(Consumer<Integer> consumer) {
        consumer.accept(this.count());
        return this;
    }

    public final BooleanCatheter append(boolean ... objects) {
        boolean[] ts = this.targets;
        boolean[] newDelegate = BooleanCatheter.array(ts.length + objects.length);
        System.arraycopy(ts, 0, newDelegate, 0, ts.length);
        System.arraycopy(objects, 0, newDelegate, ts.length, objects.length);
        this.targets = newDelegate;
        return this;
    }

    public BooleanCatheter append(BooleanCatheter objects) {
        return this.append(objects.array());
    }

    public BooleanCatheter repeat(int count) {
        boolean[] ts = this.array();
        for (int i = 0; i < count; ++i) {
            this.append(ts);
        }
        return this;
    }

    public boolean fetch(int index) {
        return this.targets[Math.min(index, this.targets.length - 1)];
    }

    public void fetch(int index, boolean item) {
        this.targets[index] = item;
    }

    public BooleanCatheter matrixEach(int width, BiConsumer<MatrixPos, Boolean> action) {
        return this.matrixReplace(width, (pos, item) -> {
            action.accept((MatrixPos)pos, (Boolean)item);
            return item;
        });
    }

    public <X> Catheter<X> matrixHomoVary(int width, BooleanCatheter input, TriFunction<MatrixPos, Boolean, Boolean, X> action) {
        if (input.count() == this.count()) {
            IntegerReceptacle index = new IntegerReceptacle(0);
            return this.matrixVary(width, (pos, item) -> {
                int indexValue = index.get();
                boolean inputX = input.fetch(indexValue);
                Object result = action.apply((MatrixPos)pos, (Boolean)item, inputX);
                index.set(indexValue + 1);
                return result;
            });
        }
        throw new IllegalArgumentException("The matrix is not homogeneous matrix");
    }

    public BooleanCatheter matrixMap(int width, int inputWidth, BooleanCatheter input, QuinFunction<MatrixFlockPos, MatrixPos, MatrixPos, Boolean, Boolean, Boolean> scanFlocked, TriFunction<MatrixPos, Boolean, Boolean, Boolean> combineFlocked) {
        int sourceHeight;
        boolean homoMatrix;
        int inputHeight = input.count() / inputWidth;
        boolean bl = homoMatrix = inputHeight == (sourceHeight = this.count() / width) && width == inputWidth;
        if (width != inputHeight && !homoMatrix) {
            throw new IllegalArgumentException("The matrix cannot be constructed because input height does not match to source width");
        }
        BooleanCatheter newMatrix = BooleanCatheter.makeCapacity(homoMatrix ? sourceHeight * width : sourceHeight * inputWidth);
        BooleanCatheter flockingCatheter = BooleanCatheter.makeCapacity(width);
        return newMatrix.matrixReplace(inputWidth, (pos, ignored) -> {
            int posX = pos.x();
            int posY = pos.y();
            int flockingIndex = 0;
            int inputY = 0;
            for (int sourceX = 0; sourceX < width; ++sourceX) {
                MatrixFlockPos flockPos = new MatrixFlockPos(posX, posY);
                MatrixPos inputPos = new MatrixPos(posX, inputY);
                MatrixPos sourcePos = new MatrixPos(sourceX, posY);
                boolean fetchedSource = this.fetch(posY * width + sourceX);
                boolean fetchedInput = input.fetch(inputY * inputWidth + posX);
                flockingCatheter.fetch(flockingIndex++, (Boolean)scanFlocked.apply(flockPos, sourcePos, inputPos, fetchedSource, fetchedInput));
                ++inputY;
            }
            return flockingCatheter.flock((current, next) -> (Boolean)combineFlocked.apply((MatrixPos)pos, current, next));
        });
    }

    public <X> Catheter<X> matrixVary(int width, boolean input, TriFunction<MatrixPos, Boolean, Boolean, X> action) {
        return this.matrixVary(width, (pos, item) -> action.apply((MatrixPos)pos, (Boolean)item, input));
    }

    public BooleanCatheter matrixReplace(int width, BiFunction<MatrixPos, Boolean, Boolean> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.replace(item -> {
            int wValue = w.get();
            int hValue = h.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return (Boolean)action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public <X> Catheter<X> matrixVary(int width, BiFunction<MatrixPos, Boolean, X> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.vary((boolean item) -> {
            int hValue = h.get();
            int wValue = w.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public Catheter<BooleanCatheter> matrixLines(int width) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        int sourceHeight = this.count() / width;
        Catheter<BooleanCatheter> results = Catheter.makeCapacity(sourceHeight);
        BooleanCatheter catheter = BooleanCatheter.makeCapacity(width);
        for (int y = 0; y < sourceHeight; ++y) {
            for (int x = 0; x < width; ++x) {
                boolean element = this.fetch(y * width + x);
                catheter.fetch(x, element);
            }
            results.fetch(y, catheter.dump());
        }
        return results;
    }

    public BooleanCatheter shuffle() {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public BooleanCatheter shuffle(RandomGenerator random) {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public BooleanCatheter swapShuffle(RandomGenerator random) {
        int i;
        boolean[] elements = this.targets;
        for (int j = i = elements.length; j > 1; --j) {
            int swapTo = random.nextInt(j);
            int swapFrom = j - 1;
            boolean fromElement = elements[swapFrom];
            boolean toElement = elements[swapTo];
            elements[swapTo] = fromElement;
            elements[swapFrom] = toElement;
        }
        return this;
    }

    public boolean has(boolean target) {
        if (target) {
            return this.hasTrue();
        }
        return this.hasFalse();
    }

    public boolean not(boolean target) {
        return !this.has(target);
    }

    public BooleanCatheter merge(BooleanCatheter other) {
        boolean otherHasTrue = other.hasTrue();
        boolean otherHasFalse = other.hasFalse();
        if (!this.hasTrue() && otherHasTrue) {
            return this.append(true);
        }
        if (!this.hasFalse() && otherHasFalse) {
            return this.append(false);
        }
        if (otherHasTrue) {
            return this.append(true);
        }
        if (otherHasFalse) {
            return this.append(false);
        }
        return this;
    }

    public BooleanCatheter dump() {
        return new BooleanCatheter(this.array());
    }

    public BooleanCatheter flat(BooleanFunction<BooleanCatheter> function) {
        if (this.isEmpty()) {
            return this;
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (boolean element : this.targets) {
            BooleanCatheter flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.count();
        }
        this.targets = BooleanCatheter.array(totalSize);
        int pos = 0;
        for (BooleanCatheter flat : (BooleanCatheter[])catheter.targets) {
            System.arraycopy(flat.targets, 0, this.targets, pos, flat.targets.length);
            pos += flat.targets.length;
        }
        return this;
    }

    public <X> Catheter<X> flatTo(BooleanFunction<Catheter<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (boolean element : this.targets) {
            Catheter<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.count();
        }
        return Catheter.flatting(catheter, totalSize);
    }

    public <X> Catheter<X> flatToByCollection(BooleanFunction<Collection<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (boolean element : this.targets) {
            Collection<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.size();
        }
        return Catheter.flattingCollection(catheter, totalSize);
    }

    public BooleanCatheter reset() {
        this.targets = BooleanCatheter.array(0);
        return this;
    }

    public BooleanCatheter reset(boolean[] targets) {
        this.targets = targets;
        return this;
    }

    public boolean[] array() {
        return (boolean[])this.targets.clone();
    }

    public boolean[] dArray() {
        return this.targets;
    }

    public Stream<Boolean> stream() {
        return this.list().stream();
    }

    public List<Boolean> list() {
        ArrayList<Boolean> list = new ArrayList<Boolean>();
        for (boolean l : this.array()) {
            list.add(l);
        }
        return list;
    }

    public Set<Boolean> set() {
        HashSet<Boolean> set = new HashSet<Boolean>();
        for (boolean l : this.array()) {
            set.add(l);
        }
        return set;
    }

    public static void main(String[] args) {
        BooleanCatheter source = BooleanCatheter.make(true, false, true, false, true, false, true, false, true);
        BooleanCatheter input = BooleanCatheter.make(true, true, true, false, false, false, true, true, true);
        source.dump().matrixHomoVary(3, input, (pos, sourceX, inputX) -> (sourceX != false ? 10 : 5) + (inputX != false ? 20 : 15)).matrixEach(3, (MatrixPos pos, T item) -> {
            System.out.println(pos);
            System.out.println(item);
        });
        System.out.println("------");
        source.matrixMap(3, 3, input, (flockPos, sourcePos, inputPos, sourceX, inputX) -> sourceX != false || inputX != false, (destPos, combine1, combine2) -> combine1 != false && combine2 != false).matrixEach(3, (pos, item) -> {
            System.out.println(pos);
            System.out.println(item);
        });
    }

    private static boolean[] array(int size) {
        return new boolean[size];
    }

    private static <X> X[] xArray(int size) {
        return new Object[size];
    }
}

