/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.catheter;

import com.github.cao.awa.catheter.BooleanCatheter;
import com.github.cao.awa.catheter.ByteCatheter;
import com.github.cao.awa.catheter.DoubleCatheter;
import com.github.cao.awa.catheter.IntCatheter;
import com.github.cao.awa.catheter.LongCatheter;
import com.github.cao.awa.catheter.action.BooleanConsumer;
import com.github.cao.awa.catheter.action.IntegerAndBiDiffExtraPredicate;
import com.github.cao.awa.catheter.action.IntegerAndBiExtraPredicate;
import com.github.cao.awa.catheter.action.IntegerAndBiExtraToExtraFunction;
import com.github.cao.awa.catheter.action.IntegerAndExtraConsumer;
import com.github.cao.awa.catheter.action.IntegerAndExtraPredicate;
import com.github.cao.awa.catheter.action.ToByteFunction;
import com.github.cao.awa.catheter.matrix.MatrixFlockPos;
import com.github.cao.awa.catheter.matrix.MatrixPos;
import com.github.cao.awa.catheter.pair.IntegerAndExtraPair;
import com.github.cao.awa.catheter.receptacle.BooleanReceptacle;
import com.github.cao.awa.catheter.receptacle.IntegerReceptacle;
import com.github.cao.awa.catheter.receptacle.Receptacle;
import com.github.cao.awa.sinuatum.function.consumer.TriConsumer;
import com.github.cao.awa.sinuatum.function.function.QuinFunction;
import com.github.cao.awa.sinuatum.function.function.TriFunction;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.random.RandomGenerator;
import java.util.stream.LongStream;
import java.util.stream.Stream;
import org.jetbrains.annotations.Nullable;

public class Catheter<T> {
    private static final Random RANDOM = new Random();
    protected T[] targets;
    protected IntFunction<T[]> arrayGenerator;

    public Catheter(T[] targets) {
        this.targets = targets;
    }

    @SafeVarargs
    public static <X> Catheter<X> make(X ... targets) {
        return new Catheter<X>(targets);
    }

    public static <X> Catheter<X> makeCapacity(int size) {
        return new Catheter<X>(Catheter.xArray(size));
    }

    public static <X> Catheter<X> makeCapacity(int size, IntFunction<X[]> arrayGenerator) {
        return new Catheter<X>(Catheter.xArray(arrayGenerator, size)).arrayGenerator(arrayGenerator);
    }

    public static <X> Catheter<X> of(X[] targets) {
        return new Catheter<X>(targets);
    }

    public Catheter<T> arrayGenerator(IntFunction<T[]> arrayGenerator) {
        this.arrayGenerator = arrayGenerator;
        return this;
    }

    public Catheter<T> flat(Function<T, Catheter<T>> function) {
        if (this.isEmpty()) {
            return this;
        }
        Catheter catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (T element : this.targets) {
            Catheter<T> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.count();
        }
        this.targets = this.array(totalSize);
        int pos = 0;
        for (Catheter flat : (Catheter[])catheter.targets) {
            System.arraycopy(flat.targets, 0, this.targets, pos, flat.targets.length);
            pos += flat.targets.length;
        }
        return this;
    }

    public <X> Catheter<X> flatTo(Function<T, Catheter<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter<Catheter<X>> catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (T element : this.targets) {
            Catheter<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.count();
        }
        return Catheter.flatting(catheter, totalSize);
    }

    public <X> Catheter<X> arrayFlatTo(Function<T, X[]> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter<X[]> catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (T element : this.targets) {
            X[] flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.length;
        }
        return Catheter.flattingArray(catheter, totalSize);
    }

    public <X> Catheter<X> collectionFlatTo(Function<T, Collection<X>> function) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        Catheter<Collection<X>> catheter = Catheter.makeCapacity(this.count());
        int totalSize = 0;
        int index = 0;
        for (T element : this.targets) {
            Collection<X> flatting = function.apply(element);
            catheter.fetch(index++, flatting);
            totalSize += flatting.size();
        }
        return Catheter.flattingCollection(catheter, totalSize);
    }

    public static <X> Catheter<X> flatting(Catheter<Catheter<X>> catheter, int totalSize) {
        Catheter<X> result = Catheter.makeCapacity(totalSize);
        if (totalSize == 0) {
            return result;
        }
        int pos = 0;
        T[] catheters = catheter.targets;
        for (int i = 0; i != catheters.length; ++i) {
            Catheter c = (Catheter)catheters[i];
            for (Object target : c.targets) {
                result.targets[pos++] = target;
            }
        }
        return result;
    }

    public static <X> Catheter<X> flattingCollection(Catheter<Collection<X>> catheter, int totalSize) {
        Catheter<X> result = Catheter.makeCapacity(totalSize);
        if (totalSize == 0) {
            return result;
        }
        int pos = 0;
        T[] catheters = catheter.targets;
        for (int i = 0; i != catheters.length; ++i) {
            Collection c = (Collection)catheters[i];
            for (Object element : c) {
                result.targets[pos++] = element;
            }
        }
        return result;
    }

    public static <X> Catheter<X> flattingArray(Catheter<X[]> catheter, int totalSize) {
        Catheter<X> result = Catheter.makeCapacity(totalSize);
        if (totalSize == 0) {
            return result;
        }
        int pos = 0;
        T[] catheters = catheter.targets;
        for (int i = 0; i != catheters.length; ++i) {
            Object[] c;
            for (Object element : c = (Object[])catheters[i]) {
                result.targets[pos++] = element;
            }
        }
        return result;
    }

    public static <X> Catheter<X> of(Collection<X> targets) {
        if (targets == null) {
            return new Catheter<X>(Catheter.xArray(0));
        }
        return new Catheter(targets.toArray(Object[]::new));
    }

    public static <X> Catheter<X> of(Collection<X> targets, IntFunction<X[]> arrayGenerator) {
        if (targets == null) {
            return new Catheter<X>(Catheter.xArray(arrayGenerator, 0)).arrayGenerator(arrayGenerator);
        }
        return new Catheter(targets.toArray(arrayGenerator)).arrayGenerator(arrayGenerator);
    }

    public Catheter<T> each(Consumer<T> action) {
        T[] ts;
        for (T t : ts = this.targets) {
            action.accept(t);
        }
        return this;
    }

    public Catheter<T> each(Consumer<T> action, Runnable poster) {
        this.each(action);
        poster.run();
        return this;
    }

    public <X> Catheter<T> each(X initializer, BiConsumer<X, T> action) {
        T[] ts;
        for (T t : ts = this.targets) {
            action.accept(initializer, t);
        }
        return this;
    }

    public <X> Catheter<T> each(X initializer, BiConsumer<X, T> action, Consumer<X> poster) {
        this.each(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public <X> Catheter<T> overall(X initializer, TriConsumer<X, Integer, T> action) {
        T[] ts = this.targets;
        int index = 0;
        for (T t : ts) {
            action.accept(initializer, index++, t);
        }
        return this;
    }

    public <X> Catheter<T> overall(X initializer, TriConsumer<X, Integer, T> action, Consumer<X> poster) {
        this.overall(initializer, action);
        poster.accept(initializer);
        return this;
    }

    public Catheter<T> overall(IntegerAndExtraConsumer<T> action) {
        T[] ts = this.targets;
        int index = 0;
        for (T t : ts) {
            action.accept(index++, t);
        }
        return this;
    }

    public Catheter<T> overall(IntegerAndExtraConsumer<T> action, Runnable poster) {
        this.overall(action);
        poster.run();
        return this;
    }

    public Catheter<T> insert(IntegerAndBiExtraToExtraFunction<T> maker) {
        HashMap indexes = new HashMap();
        Receptacle<Object> lastItem = new Receptacle<Object>(null);
        this.overall((index, item) -> {
            Object result = maker.apply(index, item, lastItem.get());
            if (result != null) {
                indexes.put(index + indexes.size(), new IntegerAndExtraPair<Object>(index, result));
            }
            lastItem.set(item);
        });
        Object[] ts = this.targets;
        Object[] newDelegate = this.array(ts.length + indexes.size());
        IntegerReceptacle lastIndex = new IntegerReceptacle(0);
        IntegerReceptacle lastDest = new IntegerReceptacle(0);
        IntCatheter.of(indexes.keySet()).sort().each((int index) -> {
            if (lastIndex.get() != index) {
                int maxCopyLength = Math.min(newDelegate.length - lastDest.get() - 1, index - lastIndex.get());
                System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), maxCopyLength);
            }
            IntegerAndExtraPair item = (IntegerAndExtraPair)indexes.get(index);
            newDelegate[index] = item.xValue();
            lastIndex.set(item.intValue());
            lastDest.set(index + 1);
        }, () -> System.arraycopy(ts, lastIndex.get(), newDelegate, lastDest.get(), newDelegate.length - lastDest.get()));
        this.targets = newDelegate;
        return this;
    }

    public Catheter<T> pluck(IntegerAndBiExtraPredicate<? super T> maker) {
        if (this.isEmpty()) {
            return this;
        }
        Receptacle<Object> lastItem = new Receptacle<Object>(null);
        return this.overallFilter((index, item) -> {
            if (maker.test(index, (Object)item, (Object)lastItem.get())) {
                return false;
            }
            lastItem.set(item);
            return true;
        });
    }

    public <X> Catheter<T> discardTo(Predicate<X> predicate, Function<? super T, X> converter) {
        Catheter<Object> result = Catheter.make(new Object[0]);
        this.overallFilter((index, item) -> !predicate.test(converter.apply(item)), result::reset);
        return result;
    }

    public Catheter<T> discardTo(Predicate<? super T> predicate) {
        Catheter<Object> result = Catheter.make(new Object[0]);
        this.overallFilter((index, item) -> !predicate.test(item), result::reset);
        return result;
    }

    public <X> Catheter<T> discardTo(X initializer, BiPredicate<? super T, X> predicate) {
        Catheter<Object> result = Catheter.make(new Object[0]);
        this.overallFilter((index, item) -> !predicate.test(item, initializer), result::reset);
        return result;
    }

    public Catheter<T> orDiscardTo(boolean succeed, Predicate<? super T> predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate);
    }

    public <X> Catheter<T> orDiscardTo(boolean succeed, Predicate<X> predicate, Function<? super T, X> converter) {
        if (succeed) {
            return this;
        }
        return this.discardTo(predicate, converter);
    }

    public <X> Catheter<T> orDiscardTo(boolean succeed, X initializer, BiPredicate<? super T, X> predicate) {
        if (succeed) {
            return this;
        }
        return this.discardTo(initializer, predicate);
    }

    public <X> Catheter<T> discard(Predicate<X> predicate, Function<? super T, X> converter) {
        return this.overallFilter((index, item) -> !predicate.test(converter.apply(item)));
    }

    public Catheter<T> discard(Predicate<? super T> predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item));
    }

    public <X> Catheter<T> discard(X initializer, BiPredicate<? super T, X> predicate) {
        return this.overallFilter((index, item) -> !predicate.test(item, initializer));
    }

    public Catheter<T> orDiscard(boolean succeed, Predicate<? super T> predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate);
    }

    public <X> Catheter<T> orDiscard(boolean succeed, Predicate<X> predicate, Function<? super T, X> converter) {
        if (succeed) {
            return this;
        }
        return this.discard(predicate, converter);
    }

    public <X> Catheter<T> orDiscard(boolean succeed, X initializer, BiPredicate<? super T, X> predicate) {
        if (succeed) {
            return this;
        }
        return this.discard(initializer, predicate);
    }

    public <X> Catheter<T> filterTo(Predicate<X> predicate, Function<? super T, X> converter) {
        return this.dump().filter(predicate, converter);
    }

    public Catheter<T> filterTo(Predicate<? super T> predicate) {
        return this.dump().filter(predicate);
    }

    public <X> Catheter<T> filterTo(X initializer, BiPredicate<? super T, X> predicate) {
        return this.dump().filter(initializer, predicate);
    }

    public <X> Catheter<T> filter(Predicate<X> predicate, Function<? super T, X> converter) {
        return this.overallFilter((index, item) -> predicate.test(converter.apply(item)));
    }

    public Catheter<T> filter(Predicate<? super T> predicate) {
        return this.overallFilter((index, item) -> predicate.test(item));
    }

    public <X> Catheter<T> filter(X initializer, BiPredicate<? super T, X> predicate) {
        return this.overallFilter((index, item) -> predicate.test(item, initializer));
    }

    public Catheter<T> overallFilter(IntegerAndExtraPredicate<? super T> predicate) {
        return this.overallFilter(predicate, (T[] x) -> {});
    }

    public Catheter<T> overallFilter(IntegerAndExtraPredicate<? super T> predicate, Consumer<T[]> discarding) {
        if (this.isEmpty()) {
            return this;
        }
        T[] ts = this.targets;
        boolean[] deleting = new boolean[ts.length];
        int newDelegateSize = ts.length;
        int index = 0;
        for (T target : ts) {
            if (predicate.test(index, target)) {
                ++index;
                continue;
            }
            deleting[index++] = true;
            --newDelegateSize;
        }
        T[] newDelegate = this.array(newDelegateSize);
        T[] discardingDelegate = this.array(ts.length - newDelegateSize);
        int newDelegateIndex = 0;
        int discardingDelegateIndex = 0;
        index = 0;
        for (boolean isDeleting : deleting) {
            T t = ts[index++];
            if (isDeleting) {
                discardingDelegate[discardingDelegateIndex++] = t;
                continue;
            }
            newDelegate[newDelegateIndex++] = t;
        }
        discarding.accept(discardingDelegate);
        this.targets = newDelegate;
        return this;
    }

    public <X, R> Catheter<R> filteringVary(Predicate<X> predicate, Function<X, R> handler, Function<? super T, X> converter) {
        return this.overallVaryFilter((index, item) -> predicate.test(item), handler, converter);
    }

    public <X> Catheter<X> filteringVary(Predicate<? super T> predicate, Function<T, X> handler) {
        return this.overallVaryFilter((index, item) -> predicate.test(item), handler);
    }

    public <I, X, R> Catheter<R> filteringVary(I initializer, BiPredicate<X, I> predicate, Function<X, R> handler) {
        return this.overallVaryFilter((index, item) -> predicate.test(item, initializer), handler, null);
    }

    public <X> Catheter<X> overallVaryFilter(IntegerAndExtraPredicate<T> predicate, Function<T, X> handler) {
        return this.overallVaryFilter(predicate, handler, null);
    }

    /*
     * WARNING - void declaration
     */
    public <X, Y> Catheter<X> overallVaryFilter(IntegerAndExtraPredicate<Y> predicate, Function<Y, X> handler, Function<? super T, Y> converter) {
        void var10_11;
        Object[] converted;
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        T[] ts = this.targets;
        Object[] objectArray = converted = converter == null ? this.targets : Catheter.xArray(this.count());
        if (converter == null) {
            converter = x -> x;
        }
        int newDelegateSize = ts.length;
        int index = 0;
        T[] TArray = ts;
        int n = TArray.length;
        boolean bl = false;
        while (var10_11 < n) {
            T target = TArray[var10_11];
            Object convertedTarget = converter.apply(target);
            if (predicate.test(index, convertedTarget)) {
                converted[index] = convertedTarget;
                ++index;
            } else {
                ts[index++] = null;
                --newDelegateSize;
            }
            ++var10_11;
        }
        X[] newDelegate = Catheter.xArray(newDelegateSize);
        int newDelegateIndex = 0;
        for (T t : converted) {
            if (t == null) continue;
            newDelegate[newDelegateIndex++] = handler.apply(t);
        }
        return Catheter.make(newDelegate);
    }

    public <X> Catheter<T> overallFilter(X initializer, IntegerAndBiDiffExtraPredicate<? super T, X> predicate) {
        return this.overallFilter((index, item) -> predicate.test(index, (Object)item, initializer));
    }

    public Catheter<T> orFilterTo(boolean succeed, Predicate<? super T> predicate) {
        return this.dump().orFilter(succeed, predicate);
    }

    public <X> Catheter<T> orFilterTo(boolean succeed, Predicate<X> predicate, Function<? super T, X> converter) {
        return this.dump().orFilter(succeed, predicate, converter);
    }

    public <X> Catheter<T> orFilterTo(boolean succeed, X initializer, BiPredicate<? super T, X> predicate) {
        return this.dump().orFilter(succeed, initializer, predicate);
    }

    public Catheter<T> orFilter(boolean succeed, Predicate<? super T> predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate);
    }

    public <X> Catheter<T> orFilter(boolean succeed, Predicate<X> predicate, Function<? super T, X> converter) {
        if (succeed) {
            return this;
        }
        return this.filter(predicate, converter);
    }

    public <X> Catheter<T> orFilter(boolean succeed, X initializer, BiPredicate<? super T, X> predicate) {
        if (succeed) {
            return this;
        }
        return this.filter(initializer, predicate);
    }

    public Catheter<T> distinct() {
        if (this.isEmpty()) {
            return this;
        }
        HashMap map = new HashMap();
        return this.filter(item -> {
            if (map.getOrDefault(item, false).booleanValue()) {
                return false;
            }
            map.put(item, true);
            return true;
        });
    }

    public Catheter<T> sort() {
        Arrays.sort(this.targets);
        return this;
    }

    public Catheter<T> sort(Comparator<T> comparator) {
        Arrays.sort(this.targets, comparator);
        return this;
    }

    public Catheter<T> holdTill(int index) {
        if (this.isEmpty()) {
            return this;
        }
        index = Math.min(index, this.targets.length);
        T[] ts = this.targets;
        T[] newDelegate = this.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public Catheter<T> holdTill(Predicate<? super T> predicate) {
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        T[] ts = this.targets;
        T[] newDelegate = this.array(index);
        if (index > 0) {
            System.arraycopy(ts, 0, newDelegate, 0, index);
        }
        this.targets = newDelegate;
        return this;
    }

    public Catheter<T> whenFlock(T source, BiFunction<T, T, T> maker, Consumer<T> consumer) {
        consumer.accept(this.flock(source, maker));
        return this;
    }

    public Catheter<T> whenFlock(BiFunction<T, T, T> maker, Consumer<T> consumer) {
        consumer.accept(this.flock(maker));
        return this;
    }

    public T flock(T source, BiFunction<T, T, T> maker) {
        T[] ts = this.targets;
        T result = source;
        for (T t : ts) {
            result = maker.apply(result, t);
        }
        return result;
    }

    public <X> X alternate(X source, BiFunction<X, T, X> maker) {
        T[] ts = this.targets;
        X result = source;
        for (T t : ts) {
            result = maker.apply(result, t);
        }
        return result;
    }

    public <X> Catheter<T> whenAlternate(X source, BiFunction<X, T, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public <X> Catheter<T> whenAlternate(BiFunction<X, T, X> maker, Consumer<X> consumer) {
        consumer.accept(this.alternate(null, maker));
        return this;
    }

    public boolean alternate(boolean source, BiPredicate<T, T> maker) {
        BooleanReceptacle result = new BooleanReceptacle(source);
        this.flock((older, newer) -> {
            if (older != null) {
                result.and(maker.test(older, newer));
            }
            return newer;
        });
        return result.get();
    }

    public Catheter<T> whenAlternate(boolean source, BiPredicate<T, T> maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(source, maker));
        return this;
    }

    public Catheter<T> whenAlternate(BiPredicate<T, T> maker, BooleanConsumer consumer) {
        consumer.accept(this.alternate(false, maker));
        return this;
    }

    @Nullable
    public T flock(BiFunction<T, T, T> maker) {
        Object result;
        T[] ts = this.targets;
        int length = ts.length;
        Object t = result = length > 0 ? (Object)ts[0] : null;
        if (result != null) {
            for (int i = 1; i < length; ++i) {
                result = maker.apply(result, ts[i]);
            }
        }
        return result;
    }

    public Catheter<T> waiveTill(int index) {
        T[] newDelegate;
        if (this.isEmpty()) {
            return this;
        }
        T[] ts = this.targets;
        if (index >= ts.length) {
            newDelegate = this.array(0);
        } else {
            newDelegate = this.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public Catheter<T> waiveTill(Predicate<? super T> predicate) {
        T[] newDelegate;
        T[] ts;
        if (this.isEmpty()) {
            return this;
        }
        int index = this.findTill(predicate);
        if (index >= (ts = this.targets).length) {
            newDelegate = this.array(0);
        } else {
            newDelegate = this.array(ts.length - index + 1);
            System.arraycopy(ts, index - 1, newDelegate, 0, newDelegate.length);
        }
        this.targets = newDelegate;
        return this;
    }

    public Catheter<T> till(Predicate<? super T> predicate) {
        T[] ts;
        for (T t : ts = this.targets) {
            if (predicate.test(t)) break;
        }
        return this;
    }

    public int findTill(Predicate<? super T> predicate) {
        T[] ts = this.targets;
        int index = 0;
        for (T t : ts) {
            if (predicate.test(t)) break;
            ++index;
        }
        return index;
    }

    public Catheter<T> replace(Function<T, T> handler) {
        if (this.isEmpty()) {
            return this;
        }
        T[] ts = this.targets;
        int index = 0;
        for (T t : ts) {
            ts[index++] = handler.apply(t);
        }
        return this;
    }

    public IntCatheter vary(ToIntFunction<T> handler) {
        if (this.isEmpty()) {
            return IntCatheter.make(new int[0]);
        }
        T[] ts = this.targets;
        int[] array = new int[ts.length];
        int index = 0;
        for (T t : ts) {
            array[index++] = handler.applyAsInt(t);
        }
        return IntCatheter.of(array);
    }

    public LongCatheter vary(ToLongFunction<T> handler) {
        if (this.isEmpty()) {
            return LongCatheter.make(new long[0]);
        }
        T[] ts = this.targets;
        long[] array = new long[ts.length];
        int index = 0;
        for (T t : ts) {
            array[index++] = handler.applyAsLong(t);
        }
        return LongCatheter.of(array);
    }

    public DoubleCatheter vary(ToDoubleFunction<T> handler) {
        if (this.isEmpty()) {
            return DoubleCatheter.make(new double[0]);
        }
        T[] ts = this.targets;
        double[] array = new double[ts.length];
        int index = 0;
        for (T t : ts) {
            array[index++] = handler.applyAsDouble(t);
        }
        return DoubleCatheter.of(array);
    }

    public ByteCatheter vary(ToByteFunction<T> handler) {
        if (this.isEmpty()) {
            return ByteCatheter.make(new byte[0]);
        }
        T[] ts = this.targets;
        byte[] array = new byte[ts.length];
        int index = 0;
        for (T t : ts) {
            array[index++] = handler.applyAsByte(t);
        }
        return ByteCatheter.of(array);
    }

    public BooleanCatheter vary(Predicate<? super T> handler) {
        if (this.isEmpty()) {
            return BooleanCatheter.make(new boolean[0]);
        }
        T[] ts = this.targets;
        boolean[] array = new boolean[ts.length];
        int index = 0;
        for (T t : ts) {
            array[index++] = handler.test(t);
        }
        return BooleanCatheter.of(array);
    }

    public <X> Catheter<X> varyTo(Function<T, X> handler) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        T[] ts = this.targets;
        X[] array = Catheter.xArray(ts.length);
        int index = 0;
        for (T t : ts) {
            array[index++] = handler.apply(t);
        }
        return Catheter.of(array);
    }

    public <X> Catheter<X> vary(Function<T, X> handler, IntFunction<X[]> arrayGenerator) {
        if (this.isEmpty()) {
            return Catheter.make(new Object[0]);
        }
        T[] ts = this.targets;
        X[] array = arrayGenerator.apply(ts.length);
        int index = 0;
        for (T t : ts) {
            array[index++] = handler.apply(t);
        }
        return Catheter.of(array).arrayGenerator(arrayGenerator);
    }

    public Catheter<T> whenAny(Predicate<? super T> predicate, Consumer<T> action) {
        T[] ts;
        for (T t : ts = this.targets) {
            if (!predicate.test(t)) continue;
            action.accept(t);
            break;
        }
        return this;
    }

    public Catheter<T> whenAll(Predicate<? super T> predicate, Runnable action) {
        T[] ts;
        for (T t : ts = this.targets) {
            if (predicate.test(t)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public Catheter<T> whenAll(Predicate<? super T> predicate, Consumer<T> action) {
        return this.whenAll(predicate, () -> this.each(action));
    }

    private Catheter<T> whenNone(Predicate<? super T> predicate, Runnable action) {
        T[] ts;
        for (T t : ts = this.targets) {
            if (!predicate.test(t)) continue;
            return this;
        }
        action.run();
        return this;
    }

    public boolean hasAny(Predicate<? super T> predicate) {
        T[] ts;
        for (T t : ts = this.targets) {
            if (!predicate.test(t)) continue;
            return true;
        }
        return false;
    }

    public boolean hasAll(Predicate<? super T> predicate) {
        T[] ts;
        for (T t : ts = this.targets) {
            if (predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    public boolean hasNone(Predicate<? super T> predicate) {
        T[] ts;
        for (T t : ts = this.targets) {
            if (!predicate.test(t)) continue;
            return false;
        }
        return true;
    }

    public T findFirst(Predicate<? super T> predicate) {
        T[] ts;
        for (T t : ts = this.targets) {
            if (!predicate.test(t)) continue;
            return t;
        }
        return null;
    }

    public T findLast(Predicate<? super T> predicate) {
        T[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            T t;
            if (!predicate.test(t = ts[index--])) continue;
            return t;
        }
        return null;
    }

    public <X> X whenFoundFirst(Predicate<? super T> predicate, Function<T, X> function) {
        T[] ts;
        for (T t : ts = this.targets) {
            if (!predicate.test(t)) continue;
            return function.apply(t);
        }
        return null;
    }

    public <X> X whenFoundLast(Predicate<? super T> predicate, Function<T, X> function) {
        T[] ts = this.targets;
        int index = ts.length - 1;
        while (index > -1) {
            T t;
            if (!predicate.test(t = ts[index--])) continue;
            return function.apply(t);
        }
        return null;
    }

    public Catheter<T> any(Consumer<T> consumer) {
        if (this.targets.length > 0) {
            consumer.accept(Catheter.select(this.targets, RANDOM));
        }
        return this;
    }

    public Optional<T> optionalFirst() {
        if (this.targets.length > 0) {
            return Optional.ofNullable(this.targets[0]);
        }
        return Optional.empty();
    }

    public Catheter<T> firstOrNull(Consumer<T> consumer) {
        consumer.accept(this.targets.length > 0 ? (Object)this.targets[0] : null);
        return this;
    }

    public Catheter<T> first(Consumer<T> consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[0]);
        }
        return this;
    }

    public Catheter<T> tailOrNull(Consumer<T> consumer) {
        consumer.accept(this.targets.length > 0 ? (Object)this.targets[this.targets.length - 1] : null);
        return this;
    }

    public Catheter<T> tail(Consumer<T> consumer) {
        if (this.targets.length > 0) {
            consumer.accept(this.targets[this.targets.length - 1]);
        }
        return this;
    }

    public Optional<T> optionalTail() {
        if (this.targets.length > 0) {
            return Optional.ofNullable(this.targets[this.targets.length - 1]);
        }
        return Optional.empty();
    }

    public Catheter<T> reverse() {
        if (this.isEmpty()) {
            return this;
        }
        T[] ts = this.targets;
        int length = ts.length;
        int split = length / 2;
        for (int index = 0; index < split; ++index) {
            int swapIndex = length - index - 1;
            T temp = ts[index];
            ts[index] = ts[swapIndex];
            ts[swapIndex] = temp;
        }
        return this;
    }

    public T max(Comparator<T> comparator) {
        return (T)this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result);
    }

    public T min(Comparator<T> comparator) {
        return (T)this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result);
    }

    public Optional<T> selectMax(Comparator<T> comparator) {
        return Optional.ofNullable(this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result));
    }

    public Optional<T> selectMin(Comparator<T> comparator) {
        return Optional.ofNullable(this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result));
    }

    public Catheter<T> whenMax(Comparator<T> comparator, Consumer<T> action) {
        Object t = this.flock((result, element) -> comparator.compare(result, element) < 0 ? element : result);
        if (t != null) {
            action.accept(t);
        }
        return this;
    }

    public Catheter<T> whenMin(Comparator<T> comparator, Consumer<T> action) {
        Object t = this.flock((result, element) -> comparator.compare(result, element) > 0 ? element : result);
        if (t != null) {
            action.accept(t);
        }
        return this;
    }

    public Catheter<T> exists() {
        return this.filter(Objects::nonNull);
    }

    public int count() {
        return this.targets.length;
    }

    public Catheter<T> count(AtomicInteger target) {
        target.set(this.count());
        return this;
    }

    public Catheter<T> count(Receptacle<Integer> target) {
        target.set(this.count());
        return this;
    }

    public Catheter<T> count(Consumer<Integer> consumer) {
        consumer.accept(this.count());
        return this;
    }

    @SafeVarargs
    public final Catheter<T> append(T ... objects) {
        T[] ts = this.targets;
        T[] newDelegate = this.array(ts.length + objects.length);
        System.arraycopy(ts, 0, newDelegate, 0, ts.length);
        System.arraycopy(objects, 0, newDelegate, ts.length, objects.length);
        this.targets = newDelegate;
        return this;
    }

    public Catheter<T> append(Catheter<T> objects) {
        return this.append(objects.array());
    }

    public Catheter<T> remove(T target) {
        int i;
        if (this.isEmpty()) {
            return this;
        }
        if (target == null) {
            return this.exists();
        }
        if (this.count() == 1 && target.equals(this.fetch(0))) {
            this.targets = this.array(0);
            return this;
        }
        int edge = this.targets.length - 1;
        boolean found = false;
        for (i = 0; i != edge; ++i) {
            if (!target.equals(this.fetch(i))) continue;
            found = true;
            break;
        }
        if (!found) {
            return this;
        }
        return this.removeWithIndex(i);
    }

    public Catheter<T> removeWithIndex(int index) {
        if (this.isEmpty() || index >= this.count() || index < 0) {
            return this;
        }
        int edge = this.count() - 1;
        T[] newDelegate = this.array(edge);
        if (index > 0) {
            System.arraycopy(this.targets, 0, newDelegate, 0, index);
        }
        System.arraycopy(this.targets, index + 1, newDelegate, index, edge - index);
        this.targets = newDelegate;
        return this;
    }

    public boolean isPresent() {
        return this.count() > 0;
    }

    public Catheter<T> ifPresent(Consumer<Catheter<T>> action) {
        if (this.count() > 0) {
            action.accept(this);
        }
        return this;
    }

    public boolean isEmpty() {
        return this.count() == 0;
    }

    public Catheter<T> ifEmpty(Consumer<Catheter<T>> action) {
        if (this.count() == 0) {
            action.accept(this);
        }
        return this;
    }

    public Catheter<T> repeat(int count) {
        T[] ts = this.array();
        for (int i = 0; i < count; ++i) {
            this.append(ts);
        }
        return this;
    }

    public T fetch(int index) {
        return this.targets[Math.min(index, this.targets.length - 1)];
    }

    public void fetch(int index, T item) {
        this.targets[index] = item;
    }

    public Catheter<T> matrixEach(int width, BiConsumer<MatrixPos, T> action) {
        return this.matrixReplace(width, (pos, item) -> {
            action.accept((MatrixPos)pos, (Object)item);
            return item;
        });
    }

    public <X, Y> Catheter<Y> matrixHomoVary(int width, Catheter<X> input, TriFunction<MatrixPos, T, X, Y> action) {
        if (input.count() == this.count()) {
            IntegerReceptacle index = new IntegerReceptacle(0);
            return this.matrixVary(width, (pos, item) -> {
                int indexValue = index.get();
                Object inputX = input.fetch(indexValue);
                Object result = action.apply((MatrixPos)pos, (Object)item, (Object)inputX);
                index.set(indexValue + 1);
                return result;
            });
        }
        throw new IllegalArgumentException("The matrix is not homogeneous matrix");
    }

    public <X, Y> Catheter<Y> matrixMap(int width, int inputWidth, Catheter<X> input, QuinFunction<MatrixFlockPos, MatrixPos, MatrixPos, T, X, Y> scanFlocked, TriFunction<MatrixPos, Y, Y, Y> combineFlocked) {
        int sourceHeight;
        boolean homoMatrix;
        int inputHeight = input.count() / inputWidth;
        boolean bl = homoMatrix = inputHeight == (sourceHeight = this.count() / width) && width == inputWidth;
        if (width != inputHeight && !homoMatrix) {
            throw new IllegalArgumentException("The matrix cannot be constructed because input height does not match to source width");
        }
        Catheter<Object> newMatrix = Catheter.makeCapacity(homoMatrix ? sourceHeight * width : sourceHeight * inputWidth);
        Catheter flockingCatheter = Catheter.makeCapacity(width);
        return newMatrix.matrixVary(inputWidth, (pos, ignored) -> {
            int posX = pos.x();
            int posY = pos.y();
            int flockingIndex = 0;
            int inputY = 0;
            for (int sourceX = 0; sourceX < width; ++sourceX) {
                MatrixFlockPos flockPos = new MatrixFlockPos(posX, posY);
                MatrixPos inputPos = new MatrixPos(posX, inputY);
                MatrixPos sourcePos = new MatrixPos(sourceX, posY);
                T fetchedSource = this.fetch(posY * width + sourceX);
                T fetchedInput = input.fetch(inputY * inputWidth + posX);
                flockingCatheter.fetch(flockingIndex++, scanFlocked.apply(flockPos, sourcePos, inputPos, fetchedSource, fetchedInput));
                ++inputY;
            }
            return flockingCatheter.flock((current, next) -> combineFlocked.apply((MatrixPos)pos, (Object)current, (Object)next));
        });
    }

    public Catheter<T> matrixTranspose(int width) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        int height = this.count() / width;
        T[] newDelegate = this.array(this.targets.length);
        int newDelegateIndex = 0;
        for (int x = 0; x < width; ++x) {
            for (int y = 0; y < height; ++y) {
                newDelegate[newDelegateIndex++] = this.fetch(y * width + x);
            }
        }
        this.targets = newDelegate;
        return this;
    }

    public <X, Y> Catheter<Y> matrixVary(int width, X input, TriFunction<MatrixPos, T, X, Y> action) {
        return this.matrixVary(width, (pos, item) -> action.apply((MatrixPos)pos, (Object)item, input));
    }

    public Catheter<T> matrixReplace(int width, BiFunction<MatrixPos, T, T> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.replace(item -> {
            int wValue = w.get();
            int hValue = h.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public <X> Catheter<X> matrixVary(int width, BiFunction<MatrixPos, T, X> action) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        IntegerReceptacle w = new IntegerReceptacle(0);
        IntegerReceptacle h = new IntegerReceptacle(0);
        int matrixEdge = width - 1;
        return this.varyTo(item -> {
            int hValue = h.get();
            int wValue = w.get();
            if (wValue == matrixEdge) {
                w.set(0);
                h.set(hValue + 1);
            } else {
                w.set(wValue + 1);
            }
            return action.apply(new MatrixPos(wValue, hValue), item);
        });
    }

    public Catheter<Catheter<T>> matrixLines(int width) {
        if (this.count() <= 0 || this.count() % width != 0) {
            throw new IllegalArgumentException("The elements does not is a matrix");
        }
        int sourceHeight = this.count() / width;
        Catheter results = Catheter.makeCapacity(sourceHeight);
        Catheter catheter = Catheter.makeCapacity(width);
        for (int y = 0; y < sourceHeight; ++y) {
            for (int x = 0; x < width; ++x) {
                T element = this.fetch(y * width + x);
                catheter.fetch(x, element);
            }
            results.fetch(y, catheter.dump());
        }
        return results;
    }

    public Catheter<T> shuffle() {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public Catheter<T> shuffle(RandomGenerator random) {
        this.sort((t1, t2) -> RANDOM.nextInt());
        return this;
    }

    public Catheter<T> swapShuffle(RandomGenerator random) {
        int i;
        T[] elements = this.targets;
        for (int j = i = elements.length; j > 1; --j) {
            int swapTo = random.nextInt(j);
            int swapFrom = j - 1;
            T fromElement = elements[swapFrom];
            T toElement = elements[swapTo];
            elements[swapTo] = fromElement;
            elements[swapFrom] = toElement;
        }
        return this;
    }

    public boolean has(T target) {
        return this.hasAny(t -> Objects.equals(t, target));
    }

    public boolean not(T target) {
        return !this.has(target);
    }

    public Catheter<T> merge(Catheter<T> other) {
        return this.append(other.filter(this::not));
    }

    public Catheter<T> dump() {
        return new Catheter<T>(this.array());
    }

    public Catheter<T> reset() {
        this.targets = this.array(0);
        return this;
    }

    public Catheter<T> reset(T[] targets) {
        this.targets = targets;
        return this;
    }

    public T[] safeArray() {
        T[] array = this.array(this.count());
        int index = 0;
        for (T target : this.targets) {
            array[index++] = target;
        }
        return array;
    }

    public T[] array() {
        return (Object[])this.targets.clone();
    }

    public T[] dArray() {
        return this.targets;
    }

    public Stream<T> stream() {
        return Arrays.stream(this.safeArray());
    }

    public List<T> list() {
        return Arrays.asList(this.array());
    }

    public Set<T> set() {
        return new HashSet<T>(this.list());
    }

    public static void main(String[] args) {
        Catheter.test2();
    }

    public static void test2() {
        Catheter<Long> strings = Catheter.make(1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L);
        strings.filteringVary(number -> number > 3L, String::valueOf).each(str -> System.out.println(str + "!"));
    }

    public static void test() {
        System.out.println("####");
        long[] catheterLongs = RANDOM.longs(0x400000L).toArray();
        long[] streamLongs = (long[])catheterLongs.clone();
        System.out.println("-- Catheter");
        LongCatheter strings = LongCatheter.make(catheterLongs);
        long start = System.currentTimeMillis();
        LongCatheter c1 = strings.arrayFlat(l -> {
            long[] sp = new long[8];
            Arrays.fill(sp, 1L);
            return sp;
        }).replace((long i) -> (long)Math.sqrt(i * i * i));
        System.out.println("Flat done in " + (System.currentTimeMillis() - start) + "ms");
        c1.each((long i) -> {});
        System.out.println("Done in " + (System.currentTimeMillis() - start) + "ms");
        System.out.println("-- Stream");
        LongStream s = Arrays.stream(streamLongs);
        start = System.currentTimeMillis();
        LongStream s1 = s.flatMap(l -> {
            long[] sp = new long[8];
            Arrays.fill(sp, 1L);
            return Arrays.stream(sp);
        }).map(i -> (long)Math.sqrt(i * i * i));
        System.out.println("Flat done in " + (System.currentTimeMillis() - start) + "ms");
        s1.forEach(i -> {});
        System.out.println("Done in " + (System.currentTimeMillis() - start) + "ms");
    }

    private T[] array(int size) {
        if (this.arrayGenerator != null) {
            return this.arrayGenerator.apply(size);
        }
        return new Object[size];
    }

    private static <X> X[] xArray(int size) {
        return new Object[size];
    }

    private static <X> X[] xArray(IntFunction<X[]> generator, int size) {
        return generator.apply(size);
    }

    public static <T> T select(T[] array, int index) {
        return array.length > index ? array[index] : array[array.length - 1];
    }

    public static <T> T select(T[] array, Random random) {
        return array[random.nextInt(array.length)];
    }
}

