/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.collection.binary.set;

import com.github.cao.awa.sepals.collection.binary.set.BinarySearchList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.Arrays;
import java.util.stream.Stream;

public class ReadonlyBinaryLongList
implements BinarySearchList<Long> {
    private final long[] elements;

    public ReadonlyBinaryLongList(long[] elements) {
        this.elements = elements;
    }

    public ReadonlyBinaryLongList(Integer[] elements) {
        this.elements = new long[elements.length];
        int elementsLength = elements.length;
        for (int i = 0; i < elementsLength; ++i) {
            this.elements[i] = elements[i].intValue();
        }
    }

    public boolean contains(long expected) {
        long[] elements = this.elements;
        int size = elements.length;
        if (size == 0) {
            return false;
        }
        int maxEdge = size - 1;
        int index = maxEdge / 2;
        int dynamicMaxEdge = maxEdge;
        while (index < size && index > -1) {
            long current = elements[index];
            if (current == expected) {
                return true;
            }
            if (current < expected) {
                index += Math.max((dynamicMaxEdge - index) / 2, 1);
            } else {
                dynamicMaxEdge = index;
                index -= Math.max(index / 2, 1);
            }
            if (index != dynamicMaxEdge) continue;
            break;
        }
        return false;
    }

    @Override
    public boolean containsElement(Long element) {
        return this.contains(element);
    }

    @Override
    public Long get(int index) {
        return this.elements[index];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public Stream<Long> stream() {
        return Arrays.stream(this.elements).boxed();
    }

    @Override
    public Iterable<Long> iterable() {
        return LongArrayList.of((long[])this.elements);
    }
}

