/*
 * Decompiled with CFR 0.152.
 */
package com.github.cao.awa.sepals.collection.binary.set;

import com.github.cao.awa.apricot.util.collection.ApricotCollectionFactor;
import com.github.cao.awa.sepals.collection.binary.set.BinarySearchList;
import it.unimi.dsi.fastutil.objects.ObjectArrays;
import java.util.Comparator;
import java.util.stream.Stream;
import net.minecraft.class_1297;

public class ReadonlyEntityBinaryList<T extends class_1297>
implements BinarySearchList<T> {
    private final T[] elements;

    public ReadonlyEntityBinaryList(T[] elements) {
        this.elements = elements;
        ObjectArrays.quickSort((Object[])this.elements, Comparator.comparingInt(class_1297::method_5628));
    }

    public boolean contains(T expected) {
        T[] elements = this.elements;
        int expectedId = expected.method_5628();
        int size = elements.length;
        if (size == 0) {
            return false;
        }
        int maxEdge = size - 1;
        int index = maxEdge / 2;
        int dynamicMaxEdge = maxEdge;
        while (index < size && index > -1) {
            int current = elements[index].method_5628();
            if (current == expectedId) {
                return true;
            }
            if (current < expectedId) {
                index += Math.max((dynamicMaxEdge - index) / 2, 1);
            } else {
                dynamicMaxEdge = index;
                index -= Math.max(index / 2, 1);
            }
            if (index != dynamicMaxEdge) continue;
            break;
        }
        return false;
    }

    @Override
    public boolean containsElement(T element) {
        return this.contains(element);
    }

    @Override
    public T get(int index) {
        return this.elements[index];
    }

    @Override
    public int size() {
        return this.elements.length;
    }

    @Override
    public Stream<T> stream() {
        return Stream.of(this.elements);
    }

    @Override
    public Iterable<T> iterable() {
        return ApricotCollectionFactor.arrayList(this.elements);
    }
}

